<?php

// Start Session
session_start();

// Include Functions File
include('../process/functions.php');

if(!isset($_SESSION['name']) || $_SESSION['user_type'] != "admin") {
    header("Location: login.php");
}

if(isset($_GET['id'])) {
    
    $patient_id = $_GET['id'];

    // Query to get patient details
    $sql = "SELECT * FROM `all_users` as au join `patients` as p on au.userid = p.user_id WHERE au.userid = '$patient_id'";
    $result = mysqli_query(ddxrxDBConnect(), $sql);
    $row = mysqli_fetch_array($result);

    // Free result set
    mysqli_free_result($result);

    // Close connection
    mysqli_close(ddxrxDBConnect());

}

// Get Profile Image
if( isset($_GET['id']) ){

    $userid = $_GET['id'];

    $sql = "SELECT * FROM `user_profile` WHERE `user_id` = '$userid' order by `id` DESC";
    $result = mysqli_query(ddxrxDBConnect(), $sql);
    $user_info = mysqli_fetch_assoc($result);

    // Free result set
    mysqli_free_result($result);

    mysqli_close(ddxrxDBConnect());

    if( empty($user_info) ){
        $profile_picture = 'dist/img/avatar.png';
    }else{
        $profile_picture = '../profile-images/'.$user_info['image_url'];
    }

}

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Edit <?php echo $row['patient_fname']." ".$row['patient_lname']; ?> - DDxRx Admin Panel | Dashboard</title>

    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <!-- JQuery CDN -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>

    <!-- Other JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="dist/js/patient-script.js" type="text/javascript"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
    <script src="dist/js/adminlte.min.js"></script>
    <script src="dist/js/custom.js"></script>

    <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <link rel="stylesheet" href="bower_components/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <link rel="stylesheet" href="dist/css/custom.css">

</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <?php
    include('includes/header.php');
    include('includes/sidebar.php');
    ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                Edit Patient
                <small>Patient</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">Edit patient</li>
            </ol>
        </section>
        
        <!-- Main content -->
        <section class="content">
            <!-- Small boxes (Stat box) -->
            <div class="row">

                <div class="col-md-12">
                    <div class="box box-primary">

                        <form method="POST" action="process/edit_patient.php" name="edit_patient_form" id="edit_patient_form">
                            <input type="hidden" name="patient_id" value="<?php echo $row['user_id']; ?>">
                            <div class="container-fluid">
                                <br>
                                Login Details
                                <hr>
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label>Username:</label>
                                    </div>
                                    <div class="col-md-4">
                                        <input type="text" name="username" value="<?php echo $row['username']; ?>" disabled class="form-control">
                                    </div>
                                    <div class="col-md-2">
                                        <label>Password:</label>
                                    </div>
                                    <div class="col-md-4">
                                        <input type="password" name="password" class="form-control">
                                    </div>
                                </div>
                                Personal Details
                                <hr>
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label>First Name:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="text" name="patient_fname" value="<?php echo $row['patient_fname']; ?>" class="form-control first_name" required>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label>Last Name:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="text" name="patient_lname" value="<?php echo $row['patient_lname']; ?>" class="form-control last_name" required>
                                    </div>
                                </div>
                                
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label for="email">Email:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="email" name="email_address" value="<?php echo $row['email_address']; ?>" id="email" Placeholder="patient@email.com" class="form-control" required>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label>Date of Birth:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="date" name="patient_dob" value="<?php echo $row['patient_dob']; ?>" class="form-control" required>
                                    </div>
                                    
                                </div>
                                
                                <div class="row form-group">
                                    
                                    <div class="col-md-2">
                                        <label>Mobile Number:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="text" name="cell" value="<?php echo $row['cell']; ?>" class="form-control">
                                    </div>
                                    
                                </div>

                                <div class="row form-group">
                                    <div class="col-md-4 col-md-offset-4">
                                        <button class="btn btn-primary col-md-12">Update patient</button>
                                    </div>
                                </div>


                            </div>
                        </form>
                        
                    </div>
                </div>

            </div>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <footer class="main-footer">
        <div class="pull-right hidden-xs">
            <b>Version</b> 2.4.0
        </div>
        <strong>Copyright &copy; 2014-2016 <a href="https://adminlte.io">Almsaeed Studio</a>.</strong> All rights
        reserved.
    </footer>
    <!-- Add the sidebar's background. This div must be placed
         immediately after the control sidebar -->
    <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

</body>
</html>
