<?php
session_start();  
if(!isset($_SESSION['name']) || $_SESSION['user_type'] != "admin") {
    header("Location: login.php");
}


include('../process/functions.php');

if( isset($_GET['id']) ) {
    
    $physician_id = $_GET['id'];
    $sql = "SELECT * FROM all_users as au join physician as p on au.userid = p.user_id WHERE p.user_id='$physician_id'";
    $result = ddxrxDBConnect()->query($sql);
    $row = $result->fetch_assoc();
    
}

// Get Profile Image
if( isset($_GET['id']) ){

    $userid = $_GET['id'];

    $sql = "SELECT * FROM `user_profile` WHERE `user_id` = '$userid' order by `id` DESC";
    $result = mysqli_query(ddxrxDBConnect(), $sql);
    $user_info = mysqli_fetch_assoc($result);

    // Free result set
    mysqli_free_result($result);

    mysqli_close(ddxrxDBConnect());

    if( empty($user_info) ){
        $profile_picture = 'dist/img/avatar.png';
    }else{
        $profile_picture = '../profile-images/'.$user_info['image_url'];
    }

}

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Edit <?php echo $row['physician_fname']." ".$row['physician_lname']; ?> - DDxRx Admin Panel | Dashboard</title>

    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    
    <!-- JQuery CDN -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>

    <!-- Other JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="dist/js/physician-script.js" type="text/javascript"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
    <script src="dist/js/adminlte.min.js"></script>
    <script src="dist/js/custom.js"></script>

    <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <link rel="stylesheet" href="bower_components/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <link rel="stylesheet" href="dist/css/custom.css">

</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <?php
    include('includes/header.php');
    include('includes/sidebar.php');
  ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Edit provider
        <small>Providers</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Edit Provider</li>
      </ol>
    </section>
    <!-- Main content -->
    <section class="content">
        <!-- Small boxes (Stat box) -->
        <div class="row">

            <div class="col-md-10">
                <div class="box box-primary">
                    <form method="POST" action="process/edit_physician.php" name="edit_provider_form" id="edit_provider_form">
                        <input type="hidden" name="physician_id" value="<?php echo $row['user_id']; ?>">
                        <div class="container-fluid">
                            <br>
                            Login Details
                            <hr>
                            <div class="row form-group">
                                <div class="col-md-2">
                                    <label>Username:</label>
                                </div>
                                <div class="col-md-4">
                                    <input type="text" name="username" value="<?php echo $row['username']; ?>" disabled class="form-control">
                                </div>
                                <div class="col-md-2">
                                    <label>Password:</label>
                                </div>
                                <div class="col-md-4">
                                    <input type="password" name="password" class="form-control">
                                </div>
                            </div>
                            Personal Details
                            <hr>
                            <div class="row form-group">
                                <div class="col-md-2">
                                    <label>First Name:</label>
                                </div>
                                <div class="col-md-4">
                                    <input type="text" name="fname" value="<?php echo $row['physician_fname']; ?>" class="form-control first_name" required>
                                </div>
                                <div class="col-md-2">
                                    <label>Last Name:</label>
                                </div>
                                <div class="col-md-4">
                                    <input type="text" name="lname" value="<?php echo $row['physician_lname']; ?>" class="form-control last_name" required>
                                </div>
                            </div>
                            
                            <div class="row form-group">
                                <div class="col-md-2">
                                    <label>Date of Birth:</label>
                                </div>
                                
                                <div class="col-md-4">
                                    <input type="date" name="dob" value="<?php echo $row['physician_dob']; ?>" class="form-control" required>
                                </div>
                                
                                <div class="col-md-2">
                                    <label>Gender:</label>
                                </div>
                                
                                <div class="col-md-4">
                                    <select class="form-control" name="gender" required>
                                        <option <?php if($row['physician_gender']=="male") echo "selected"; ?> value="male">Male</option>
                                        <option <?php if($row['physician_gender']=="female") echo "selected"; ?> value="female">Female</option>
                                    </select>
                                </div>
                            </div>
                            
                            
                            <div class="row form-group">
                                <div class="col-md-2">
                                    <label>Degree:</label>
                                </div>
                                <div class="col-md-4">
                                    <select class="form-control" name="degree" required>
                                        <option <?php if($row['physician_degree']=="") echo "selected"; ?> value="">Select..</option>
                                        <option <?php if($row['physician_degree']=="MD") echo "selected"; ?> value="MD">M.D.</option>
                                        <option <?php if($row['physician_degree']=="DO") echo "selected"; ?> value="DO">DO</option>
                                        <option <?php if($row['physician_degree']=="NP") echo "selected"; ?> value="NP">NP.</option>
                                        <option <?php if($row['physician_degree']=="PA") echo "selected"; ?> value="PA">PA</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label>Speciality:</label>
                                </div>
                                <div class="col-md-4">
                                    <input type="text" name="speciality" value="<?php echo $row['physician_speciality']; ?>" class="form-control" required>
                                    <!-- <select class="form-control" name="speciality">

                                        <option <?php /*if($row['physician_speciality']=="cardiologist") echo "selected"; */?> value="cardiologist">Cardiologist</option>
                                        <option <?php /*if($row['physician_speciality']=="inernalMedicine") echo "selected"; */?> value="inernalMedicine">Internal Medicine</option>
                                        <option <?php /*if($row['physician_speciality']=="Hospitalist") echo "selected"; */?> value="Hospitalist">Hospitalist</option>
                                    </select>
                                    -->
                                </div>
                            </div>
                            
                            <div class="row form-group">
                                <div class="col-md-2">
                                    <label>Phone Number:</label>
                                </div>
                                
                                <div class="col-md-4">
                                    <input type="text" name="cell_number" value="<?php echo $row['physician_phone']; ?>" class="form-control" required>
                                </div>
                                
                                
                                <div class="col-md-2">
                                    <label for="email">Email:</label>
                                </div>
                                
                                <div class="col-md-4">
                                    <input type="email" name="physician_email" id="email" value="<?php echo $row['physician_email']; ?>" class="form-control" placeholder="physician@email.com" required>
                                </div>
                            </div>
                            
                            <!-- Video Training -->
                            <div class="row form-group">

                                <div class="col-md-2">
                                    <label>Select Video Training:</label>
                                </div>

                                <div class="col-md-10">
                                    
                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_1">
                                        <span class="label-text">Clinical Assist Email Pitch</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_2">
                                        <span class="label-text">Clinical Assist for Hospital</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_3">
                                        <span class="label-text">Clinical Assist Introduction</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_4">
                                        <span class="label-text">Clinical Assist Medical Disclaimer</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_5">
                                        <span class="label-text">Clinical Assist Primary Care</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_6">
                                        <span class="label-text">Clinical Assist Fall Alert</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_7">
                                        <span class="label-text">Clinical Assist Urgent Care Clinics</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_8">
                                        <span class="label-text">Clinic Owner RPM Training</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_9">
                                        <span class="label-text">Doctor Ai Introduction</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_10">
                                        <span class="label-text">Doctor Ai RPM Onboarding</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_11">
                                        <span class="label-text">Doctor Ai RPM Phone Call Training</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_12">
                                        <span class="label-text">Doctor Ai RPM Pitch</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_13">
                                        <span class="label-text">Doctor Ai RPM</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_14">
                                        <span class="label-text">RPM Engagement Rules</span>
                                    </label>
                                </div>

                            </div>
                            <!-- End Video Training -->

                            <div class="row form-group">
                                <div class="col-md-4 col-md-offset-4">
                                    <button class="btn btn-primary col-md-12">Update Provider</button>
                                </div>
                            </div>

                        </div>
                    </form>
                </div>
            </div>

            <div class="col-md-2">
                <div class="box box-primary">
                    <div class="container-fluid">

                        <div class="row form-group">
                            <div class="col-md-12">
                                
                                <div class="avatar-upload-container">
                                    <div class="avatar-container">
                                        <div class="upload-icon-container">
                                            <div class="upload-icon">
                                                <i class="fa fa-cloud-upload"></i>
                                                <h6>Select New Image</h6>
                                            </div>
                                        </div>
                                        <img src="<?php echo $profile_picture; ?>" class="avatar">
                                    </div>

                                    <form id="uploadForm" enctype="multipart/form-data">
                                        <input type="file" name="file" accept="image/*" id="fileToUpload" class="uploadfield" style="display: none" required>
                                        <input type="hidden" value="<?php echo $_GET['id']; ?>" id="userid">
                                        <input type="submit" value="Upload Image" class="submitUpload">
                                    </form>

                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <div class="pull-right hidden-xs">
      <b>Version</b> 2.4.0
    </div>
    <strong>Copyright &copy; 2014-2016 <a href="https://adminlte.io">Almsaeed Studio</a>.</strong> All rights
    reserved.
  </footer>
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

</body>
</html>
