<?php
session_start();  
if(!isset($_SESSION['name']) || $_SESSION['user_type']!="admin") {
    header("Location: login.php");
}

// Include Functions File
include("../process/functions.php");

?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>DDxRx Admin Panel | List of Admins</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.7 -->
  <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="bower_components/font-awesome/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="bower_components/Ionicons/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <!-- Morris chart -->
  <link rel="stylesheet" href="bower_components/morris.js/morris.css">
  <!-- jvectormap -->
  <link rel="stylesheet" href="bower_components/jvectormap/jquery-jvectormap.css">
  <!-- Date Picker -->
  <link rel="stylesheet" href="bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="bower_components/bootstrap-daterangepicker/daterangepicker.css">
  <!-- bootstrap wysihtml5 - text editor -->
  <link rel="stylesheet" href="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->

  <!-- Google Font -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

  <style>
    .dataTables_filter {
        text-align: right;
    }
    
    /* Custom column widths for logs table */
    #example1 th:nth-child(1), /* Activity */
    #example1 td:nth-child(1) {
        width: 10%;
        min-width: 80px;
    }
    
    #example1 th:nth-child(2), /* Description */
    #example1 td:nth-child(2) {
        width: 25%;
        min-width: 200px;
        word-wrap: break-word;
        max-width: 300px;
    }
    
    #example1 th:nth-child(3), /* Page Visited */
    #example1 td:nth-child(3) {
        width: 25%;
        min-width: 200px;
        word-wrap: break-word;
        max-width: 300px;
    }
    
    #example1 th:nth-child(4), /* Time Entered */
    #example1 td:nth-child(4) {
        width: 15%;
        min-width: 120px;
    }
    
    #example1 th:nth-child(5), /* Time Spent */
    #example1 td:nth-child(5) {
        width: 10%;
        min-width: 80px;
    }
    
    #example1 th:nth-child(6), /* User */
    #example1 td:nth-child(6) {
        width: 8%;
        min-width: 60px;
    }
    
    #example1 th:nth-child(7), /* UserType */
    #example1 td:nth-child(7) {
        width: 7%;
        min-width: 70px;
    }
    
    /* Ensure table is responsive and content wraps properly */
    #example1 {
        table-layout: fixed;
        width: 100%;
    }
    
    #example1 td {
        white-space: normal;
        vertical-align: top;
    }
  </style>

</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <?php
    include('includes/header.php');
    include('includes/sidebar.php');
  ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>User Activity <small>Logs</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Nurses</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <!-- Small boxes (Stat box) -->
          <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Activity</th>
                        <th>Description</th>
                        <th>Page Visited</th>
                        <th>Time Entered</th>
                        <th>Time Spent</th>
                        <th>User</th>
                        <th>UserType</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                    $version = get_version();
                    $query = mysqli_query(ddxrxDBConnect(), "SELECT * FROM user_page_history ORDER by time_entered DESC LIMIT 500");
                    while($row=mysqli_fetch_array($query)) {
                ?>
                    <tr>
                        <td><?php echo $row['operation']; ?></td>
                        <td><?php echo $row['description'];?></td>
                        <td><?php echo $row['page_url']; ?></td>
                        <td><?php echo $row['time_entered']; ?></td>
                        <td><?php echo $row['time_spent']; ?></td>
                        <td><?php echo $row['user_id']; ?></td>
                        <td><?php 
                        if($row['user_type'] == 1) echo 'Admin';
                        else if($row['user_type'] == 2) echo 'Physician';
                        else if($row['user_type'] == 3) echo 'Patient';
                        else if($row['user_type'] == 4) echo 'Nurse';
                        ?></td>
                    </tr>
                <?php } ?>
                </tbody>
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <div class="pull-right hidden-xs">
      <b>Version</b> 2.4.0
    </div>
    <strong>Copyright &copy; 2014-2016 <a href="https://adminlte.io">Almsaeed Studio</a>.</strong> All rights
    reserved.
  </footer>
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 3 -->
<script src="bower_components/jquery/dist/jquery.min.js"></script>
<!-- jQuery UI 1.11.4 -->
<script src="bower_components/jquery-ui/jquery-ui.min.js"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
  $.widget.bridge('uibutton', $.ui.button);
</script>
<!-- Bootstrap 3.3.7 -->
<script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
<!-- DataTables -->
<script src="bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<!-- Morris.js charts -->
<script src="bower_components/raphael/raphael.min.js"></script>
<script src="bower_components/morris.js/morris.min.js"></script>
<!-- Sparkline -->
<script src="bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
<!-- jvectormap -->
<script src="plugins/jvectormap/jquery-jvectormap-1.2.2.min.js"></script>
<script src="plugins/jvectormap/jquery-jvectormap-world-mill-en.js"></script>
<!-- jQuery Knob Chart -->
<script src="bower_components/jquery-knob/dist/jquery.knob.min.js"></script>
<!-- daterangepicker -->
<script src="bower_components/moment/min/moment.min.js"></script>
<script src="bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<!-- datepicker -->
<script src="bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<!-- Bootstrap WYSIHTML5 -->
<script src="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
<!-- Slimscroll -->
<script src="bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="bower_components/fastclick/lib/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="dist/js/pages/dashboard.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<script src="main.js"></script>
<script>
  $(function () {
    $('#example1').DataTable();
  })
</script>
</body>
</html>
