/*<a href="deletelink" onclick="return confirm('Are you sure?')">Delete</a>
<a href="deletelink" onclick="return checkDelete()">Delete</a>*/

function adminDelete(uid) {
    var result = confirm("Are you want to delete?");
    if (result) {
		var uid = uid;
        $.ajax({
            url: 'deleteAdmin.php?uid='+uid,
            type: 'GET',
            success: function(response) {
				alert('Data deleted successfully');
				window.location='admins.php';
            },
            error: function(xhr) {
                alert('Deletion failed');
				window.location='admins.php';
            },
        });
    }
}

function physicianDelete(uid, pid) {
	// Use SweetAlert for better UX (if available, otherwise fallback to confirm)
	if (typeof Swal !== 'undefined') {
		Swal.fire({
			title: "Are you sure?",
			text: "You won't be able to revert this!",
			icon: "warning",
			showCancelButton: true,
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonText: "Yes, delete it!"
		}).then((result) => {
			if (result.isConfirmed) {
				performPhysicianDelete(uid, pid);
			}
		});
	} else {
		// Fallback to confirm dialog
		var result = confirm("Are you sure want to delete?");
		if (result) {
			performPhysicianDelete(uid, pid);
		}
	}
}

function performPhysicianDelete(uid, pid) {
	// Show loading if SweetAlert is available
	if (typeof Swal !== 'undefined') {
		Swal.fire({
			title: 'Deleting...',
			text: 'Please wait while we delete the provider.',
			allowOutsideClick: false,
			allowEscapeKey: false,
			showConfirmButton: false,
			didOpen: () => {
				Swal.showLoading();
			}
		});
	}

	$.ajax({
		url: 'deleteProvider.php?uid='+uid+'&pid='+pid,
		type: 'GET',
		success: function(response) {
			if (typeof Swal !== 'undefined') {
				Swal.fire({
					title: "Deleted!",
					text: "Provider has been deleted successfully.",
					icon: "success"
				}).then(() => {
					window.location='providers.php';
				});
			} else {
				alert('Data deleted successfully');
				window.location='providers.php';
			}
		},
		error: function(xhr) {
			if (typeof Swal !== 'undefined') {
				Swal.fire({
					title: "Error!",
					text: "Failed to delete provider. Please try again.",
					icon: "error"
				});
			} else {
				alert('Deletion failed');
				window.location='providers.php';
			}
		},
	});
}

function nurseDelete(uid, nid) {
	// Use SweetAlert for better UX (if available, otherwise fallback to confirm)
	if (typeof Swal !== 'undefined') {
		Swal.fire({
			title: "Are you sure?",
			text: "You won't be able to revert this!",
			icon: "warning",
			showCancelButton: true,
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonText: "Yes, delete it!"
		}).then((result) => {
			if (result.isConfirmed) {
				performNurseDelete(uid, nid);
			}
		});
	} else {
		// Fallback to confirm dialog
		var result = confirm("Are you sure want to delete?");
		if (result) {
			performNurseDelete(uid, nid);
		}
	}
}

function performNurseDelete(uid, nid) {
	// Show loading if SweetAlert is available
	if (typeof Swal !== 'undefined') {
		Swal.fire({
			title: 'Deleting...',
			text: 'Please wait while we delete the nurse.',
			allowOutsideClick: false,
			allowEscapeKey: false,
			showConfirmButton: false,
			didOpen: () => {
				Swal.showLoading();
			}
		});
	}

	$.ajax({
		url: 'deleteNurse.php?uid='+uid+'&nid='+nid,
		type: 'GET',
		success: function(response) {
			if (typeof Swal !== 'undefined') {
				Swal.fire({
					title: "Deleted!",
					text: "Nurse has been deleted successfully.",
					icon: "success"
				}).then(() => {
					window.location='nurses.php';
				});
			} else {
				alert('Data deleted successfully');
				window.location='nurses.php';
			}
		},
		error: function(xhr) {
			if (typeof Swal !== 'undefined') {
				Swal.fire({
					title: "Error!",
					text: "Failed to delete nurse. Please try again.",
					icon: "error"
				});
			} else {
				alert('Deletion failed');
				window.location='nurses.php';
			}
		},
	});
}

function fieldDelete(fid) {
	var result = confirm("Are you sure want to delete?");
	if (result) {
		var fid = fid;
		$.ajax({
			url: 'deleteField.php?fid='+fid,
			type: 'GET',
			success: function(response) {
				alert('Data deleted successfully');
				window.location='viewField.php';
			},
			error: function(xhr) {
				alert('Deletion failed');
				window.location='viewField.php';
			},
		});
	}
}

$(document).ready(function() {

	$('.deletePatientBtn').click(function() {

		var patientID = $(this).parent().parent().data('patient-id');

		// Show Sweet Alert
		Swal.fire({
			title: "Are you sure?",
			text: "You won't be able to revert this!",
			icon: "warning",
			showCancelButton: true,
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonText: "Yes, delete it!"
		}).then((result) => {
			if (result.isConfirmed) {

				$.ajax({
					url: 'process/deletePatient.php',
					type: 'POST',
					data: {
						patient_id: patientID
					},
					success: function(response) {
						
						if( response.status == true ) {
							// Delete Table Row
							$('#patient-' + patientID).remove();
						}

						Swal.fire({
							title: response.title,
							text: response.text,
							icon: response.icon
						});

					},
					error: function(xhr) {
						
						Swal.fire({
							title: "Error",
							text: "An error occurred while deleting the patient.",
							icon: "error"
						});

					},
				});

			}
		});

	});

});