<?php

// Set output to JSON
header('Content-Type: application/json');

// Include functions file
include('../../process/functions.php');

// Show errors for debugging (remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if( $_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST['email']) ) {

    // Get email from POST and trim whitespace
    $email = trim($_POST['email']);
    
    // If email is empty, return false (allow blank values)
    if(empty($email)) {
        echo json_encode(array('exists' => false));
        exit;
    }

    // Database connection
    $conn = ddxrxDBConnect();
    
    if (!$conn) {
        echo json_encode(array(
            'exists' => false,
            'error' => 'Database connection failed'
        ));
        exit;
    }

    // Escape email to prevent SQL injection
    $email = mysqli_real_escape_string($conn, $email);

    // SQL Query - check both email_id and billing_email in patients table
    $sql = "SELECT patient_id FROM `patients` WHERE `email_id` = '$email' OR `billing_email` = '$email' LIMIT 1";

    // Execute query
    $query = mysqli_query($conn, $sql);
    
    if (!$query) {
        mysqli_close($conn);
        echo json_encode(array(
            'exists' => false,
            'error' => 'Query failed: ' . mysqli_error($conn)
        ));
        exit;
    }

    // Check if email exists
    if(mysqli_num_rows($query) > 0) {
        $output = array('exists' => true);
    } else {
        $output = array('exists' => false);
    }
    
    // Close connection
    mysqli_close($conn);

} else {

    // Return error
    $output = array(
        'exists' => false,
        'error' => 'Invalid request'
    );

}

echo json_encode($output);

?>
