<?php

// Start session
session_start();

// Include functions
require_once('../../process/functions.php');

// Initialize response
$response = array(
    'result' => false,
    'icon' => 'error',
    'title' => 'Error',
    'message' => 'Something went wrong!'
);

// Check if user is logged in and is admin
if(!isset($_SESSION['name']) || $_SESSION['user_type'] != "admin") {
    $response['message'] = 'Unauthorized access!';
    echo json_encode($response);
    exit();
}

// Check if form was submitted
if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // Get version ID
    $version_id = get_version('version_id');
    
    if(!$version_id) {
        $response['message'] = 'Version ID not found. Please login again.';
        echo json_encode($response);
        exit();
    }
    
    // Validate required fields
    $required_fields = array('clinic_name', 'email', 'country', 'street_address', 'city', 'state', 'zip_code', 'physician_1', 'phone');
    
    foreach($required_fields as $field) {
        if(!isset($_POST[$field]) || empty(trim($_POST[$field]))) {
            $response['message'] = 'Please fill in all required fields!';
            echo json_encode($response);
            exit();
        }
    }
    
    // Get form data
    $clinic_name = mysqli_real_escape_string(ddxrxDBConnect(), $_POST['clinic_name']);
    $email = mysqli_real_escape_string(ddxrxDBConnect(), $_POST['email']);
    $country = mysqli_real_escape_string(ddxrxDBConnect(), $_POST['country']);
    $street_address = mysqli_real_escape_string(ddxrxDBConnect(), $_POST['street_address']);
    $city = mysqli_real_escape_string(ddxrxDBConnect(), $_POST['city']);
    $state = mysqli_real_escape_string(ddxrxDBConnect(), $_POST['state']);
    $zip_code = mysqli_real_escape_string(ddxrxDBConnect(), $_POST['zip_code']);
    $physician_1 = mysqli_real_escape_string(ddxrxDBConnect(), $_POST['physician_1']);
    $specialty = mysqli_real_escape_string(ddxrxDBConnect(), $_POST['specialty']);
    $open_hours = mysqli_real_escape_string(ddxrxDBConnect(), $_POST['open_hours']);
    $phone = mysqli_real_escape_string(ddxrxDBConnect(), $_POST['phone']);
    $fax = mysqli_real_escape_string(ddxrxDBConnect(), $_POST['fax']);
    
    // Validate email format
    if(!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response['message'] = 'Please enter a valid email address!';
        echo json_encode($response);
        exit();
    }
    
    // Update query
    $update_query = "UPDATE `version` SET 
        `clinic_name` = '$clinic_name',
        `email` = '$email',
        `country` = '$country',
        `street_address` = '$street_address',
        `city` = '$city',
        `state` = '$state',
        `zip_code` = '$zip_code',
        `physician_1` = '$physician_1',
        `specialty` = '$specialty',
        `open_hours` = '$open_hours',
        `phone` = '$phone',
        `fax` = '$fax'
        WHERE `version_id` = '$version_id'";
    
    if(ddxrxDBConnect()->query($update_query) === TRUE) {
        $response['result'] = true;
        $response['icon'] = 'success';
        $response['title'] = 'Success';
        $response['message'] = 'Settings updated successfully!';
    } else {
        $response['message'] = 'Error updating settings: ' . ddxrxDBConnect()->error;
    }
    
} else {
    $response['message'] = 'Invalid request method!';
}

// Return response
echo json_encode($response);
exit();

?>
