<?php

// Start session
session_start();

// Logged in user check
// If the user is not logged in or is not an admin, redirect to login page
if(!isset($_SESSION['name']) || $_SESSION['user_type'] != "admin") {
    header("Location: login.php");
}

// Include functions
require_once('../process/functions.php');

// Get version and fetch current settings
$version_id = get_version('version_id');
$settings_data = array();

if($version_id) {
    $sql = "SELECT * FROM `version` WHERE `version_id` = '$version_id'";
    $result = ddxrxDBConnect()->query($sql);
    
    if($result && $result->num_rows > 0) {
        $settings_data = $result->fetch_assoc();
    }
}

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Settings - DDxRx Admin Panel | Dashboard</title>

    <!-- JQuery CDN -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>

    <!-- Scripts -->
    <script type="text/javascript" src="dist/js/patient-script.js?v=1.0.2"></script>

    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
    folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <!-- Morris chart -->
    <link rel="stylesheet" href="bower_components/morris.js/morris.css">
    <!-- jvectormap -->
    <link rel="stylesheet" href="bower_components/jvectormap/jquery-jvectormap.css">
    <!-- Date Picker -->
    <link rel="stylesheet" href="bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <!-- Daterange picker -->
    <link rel="stylesheet" href="bower_components/bootstrap-daterangepicker/daterangepicker.css">
    <!-- bootstrap wysihtml5 - text editor -->
    <link rel="stylesheet" href="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

    <script type="text/javascript" src="../assets/js/jquery.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    
    <style>
        .is-invalid {
            border-color: #dc3545 !important;
        }
        .text-danger {
            color: #dc3545 !important;
            font-size: 12px;
            margin-top: 5px;
        }
        .form-section {
            margin-bottom: 30px;
            padding: 20px;
            background-color: #f9f9f9;
            border-radius: 5px;
        }
        .form-section h4 {
            margin-top: 0;
            margin-bottom: 20px;
            color: #3c8dbc;
            border-bottom: 2px solid #3c8dbc;
            padding-bottom: 10px;
        }
        .form-group label {
            font-weight: 600;
            color: #333;
        }
    </style>

</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <?php
    include('includes/header.php');
    include('includes/sidebar.php');
    ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                Settings
                <small>Manage application settings</small>
            </h1>
            
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">Settings</li>
            </ol>
        </section>
        
        <!-- Main content -->
        <section class="content">
            <?php if(!$version_id): ?>
            <div class="alert alert-warning">
                <h4><i class="icon fa fa-warning"></i> Warning!</h4>
                No version ID found in session. Please login again.
            </div>
            <?php else: ?>
            
            <!-- Settings Form -->
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-primary">
                        
                        <form method="POST" name="settings_form" id="settings_form">
                            <div class="box-body">
                                <!-- Basic Information Section -->
                                <div class="form-section">
                                    <h4><i class="fa fa-hospital-o"></i> Basic Information</h4>
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="clinic_name">Clinic Name <span class="text-danger">*</span></label>
                                                <input type="text" name="clinic_name" id="clinic_name" class="form-control" 
                                                       value="<?php echo isset($settings_data['clinic_name']) ? htmlspecialchars($settings_data['clinic_name'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
                                                       required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="prefix">Prefix</label>
                                                <input type="text" name="prefix" id="prefix" class="form-control" 
                                                       value="<?php echo isset($settings_data['prefix']) ? htmlspecialchars($settings_data['prefix'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
                                                       maxlength="10" disabled readonly>
                                                <small class="text-muted">Max 10 characters (Read-only)</small>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="physician_1">Physician Name <span class="text-danger">*</span></label>
                                                <input type="text" name="physician_1" id="physician_1" class="form-control" 
                                                       value="<?php echo isset($settings_data['physician_1']) ? htmlspecialchars($settings_data['physician_1'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
                                                       required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="specialty">Specialty</label>
                                                <textarea name="specialty" id="specialty" class="form-control" rows="3"><?php echo isset($settings_data['specialty']) ? htmlspecialchars($settings_data['specialty'], ENT_QUOTES, 'UTF-8') : ''; ?></textarea>
                                                <small class="text-muted">Separate multiple specialties with semicolons (;)</small>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="open_hours">Open Hours</label>
                                                <textarea name="open_hours" id="open_hours" class="form-control" rows="3"><?php echo isset($settings_data['open_hours']) ? htmlspecialchars($settings_data['open_hours'], ENT_QUOTES, 'UTF-8') : ''; ?></textarea>
                                                <small class="text-muted">Example: Monday to Friday; 8:00 AM to 5:00 PM</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Contact Information Section -->
                                <div class="form-section">
                                    <h4><i class="fa fa-phone"></i> Contact Information</h4>
                                    
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="email">Email <span class="text-danger">*</span></label>
                                                <input type="email" name="email" id="email" class="form-control" 
                                                       value="<?php echo isset($settings_data['email']) ? htmlspecialchars($settings_data['email'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
                                                       maxlength="100" required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="phone">Phone <span class="text-danger">*</span></label>
                                                <input type="text" name="phone" id="phone" class="form-control" 
                                                       value="<?php echo isset($settings_data['phone']) ? htmlspecialchars($settings_data['phone'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
                                                       maxlength="15" required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="fax">Fax</label>
                                                <input type="text" name="fax" id="fax" class="form-control" 
                                                       value="<?php echo isset($settings_data['fax']) ? htmlspecialchars($settings_data['fax'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
                                                       maxlength="15">
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="url">Website URL</label>
                                                <input type="text" name="url" id="url" class="form-control" 
                                                       value="<?php echo isset($settings_data['url']) ? htmlspecialchars($settings_data['url'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
                                                       disabled readonly>
                                                <small class="text-muted">Read-only</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Address Information Section -->
                                <div class="form-section">
                                    <h4><i class="fa fa-map-marker"></i> Address Information</h4>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="street_address">Street Address <span class="text-danger">*</span></label>
                                                <textarea name="street_address" id="street_address" class="form-control" rows="2" required><?php echo isset($settings_data['street_address']) ? htmlspecialchars($settings_data['street_address'], ENT_QUOTES, 'UTF-8') : ''; ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="city">City <span class="text-danger">*</span></label>
                                                <input type="text" name="city" id="city" class="form-control" 
                                                       value="<?php echo isset($settings_data['city']) ? htmlspecialchars($settings_data['city'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
                                                       required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="state">State <span class="text-danger">*</span></label>
                                                <input type="text" name="state" id="state" class="form-control" 
                                                       value="<?php echo isset($settings_data['state']) ? htmlspecialchars($settings_data['state'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
                                                       maxlength="50" required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="zip_code">ZIP Code <span class="text-danger">*</span></label>
                                                <input type="text" name="zip_code" id="zip_code" class="form-control" 
                                                       value="<?php echo isset($settings_data['zip_code']) ? htmlspecialchars($settings_data['zip_code'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
                                                       required>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="country">Country <span class="text-danger">*</span></label>
                                                <input type="text" name="country" id="country" class="form-control" 
                                                       value="<?php echo isset($settings_data['country']) ? htmlspecialchars($settings_data['country'], ENT_QUOTES, 'UTF-8') : ''; ?>" 
                                                       required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Submit Button -->
                                <div class="row">
                                    <div class="col-md-12">
                                        <button type="submit" class="btn btn-primary btn-lg pull-right">
                                            <i class="fa fa-save"></i> Update Settings
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <footer class="main-footer">
        <div class="pull-right hidden-xs">
            <b>Version</b> 2.4.0
        </div>
        <strong>Copyright &copy; 2014-2016 <a href="https://adminlte.io">Almsaeed Studio</a>.</strong> All rights
        reserved.
    </footer>
    <!-- Add the sidebar's background. This div must be placed
         immediately after the control sidebar -->
    <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 3 -->
<script src="bower_components/jquery/dist/jquery.min.js"></script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
<!--<script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/additional-methods.min.js"></script>-->


<!-- jQuery UI 1.11.4 -->
<script src="bower_components/jquery-ui/jquery-ui.min.js"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
    $.widget.bridge('uibutton', $.ui.button);
</script>
<!-- Bootstrap 3.3.7 -->
<script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
<!-- Morris.js charts -->
<script src="bower_components/raphael/raphael.min.js"></script>
<script src="bower_components/morris.js/morris.min.js"></script>
<!-- Sparkline -->
<script src="bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
<!-- jvectormap -->
<script src="plugins/jvectormap/jquery-jvectormap-1.2.2.min.js"></script>
<script src="plugins/jvectormap/jquery-jvectormap-world-mill-en.js"></script>
<!-- jQuery Knob Chart -->
<script src="bower_components/jquery-knob/dist/jquery.knob.min.js"></script>
<!-- daterangepicker -->
<script src="bower_components/moment/min/moment.min.js"></script>
<script src="bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<!-- datepicker -->
<script src="bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<!-- Bootstrap WYSIHTML5 -->
<script src="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
<!-- Slimscroll -->
<script src="bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="bower_components/fastclick/lib/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="dist/js/pages/dashboard.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>

<!-- Settings JS -->
<script src="dist/js/settings.js"></script>

</body>
</html>
