<?php

// Session start
session_start();

// Include necessary files
include('process/functions.php');

// Check if user is logged in and has the correct user type
if(!isset($_SESSION['userType'])) {
    header("Location: logout.php");
    die();
}

?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Ambulatory Care</title>

        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200">
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/ambulatory-care.css">

        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script src="assets/js/ambulatory-care.js"></script>

        <script type="text/javascript">
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({pageLanguage: 'en', 
                layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
                autoDisplay: false, 
                includedLanguages: ''}, 'google_translate_element');
            }
        </script>
        <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

    </head>
    <body>
        
        <!-- GOOGLE TRANSLATE -->
        <div id="google_translate_element"></div>
        <!-- GOOGLE TRANSLATE -->
        
        <?php
            if( $_SESSION['userType'] == 'nurse' || $_SESSION['userType'] == 'doctor' ){
                include('ambulatory-care-provider.php');
            }else{
                include('ambulatory-care-patient.php');
            }
        ?>

        <p class="footer-notice">This is the new beta version of ambulatory care, If you want to use the old version of the ambulatory care, please click <a href="search_dd.php<?php if( $_SESSION['userType'] == 'nurse' || $_SESSION['userType'] == 'doctor' ){ echo '?staff=true'; } ?>">here</a>.</p>

    </body>
</html>