<?php

// Enable error reporting for debugging (Remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set the content type to JSON
header('Content-Type: application/json');

// Add include
include('../../process/functions.php');

// Get the request URI
$requestUri = trim($_SERVER['REQUEST_URI'], '/');

// Expected endpoint without .php
$expectedEndpoint = 'ddxrx-main/api/cardiowell';

// Define your API Key Name and Value
$apiKeyName = 'X-Api-Key';
$apiKeyValue = 'f23c4d5e8a9b0c12d3e4f5g6h7i8j9k0l1m2n3o4p5q6r7s8t9u0v1w2x3y4z5a6'; // Replace this with your actual secure API Key

// Function to validate the API Key
function isApiKeyValid() {
    global $apiKeyName, $apiKeyValue;

    $headers = getallheaders();
    return isset($headers[$apiKeyName]) && $headers[$apiKeyName] === $apiKeyValue;
}

// Process Blood Pressure Data
function processBloodPressureData($patient_id, $history, $conn) {
    foreach ($history as $entry) {
        $systolic = isset($entry->sys) ? $entry->sys : null;
        $diastolic = isset($entry->dia) ? $entry->dia : null;
        $heartrate = isset($entry->pulse) ? $entry->pulse : null;
        $rhythm = isset($entry->irregular_pulse) && $entry->irregular_pulse ? 1 : 0;
        $timestamp = isset($entry->ts) ? $entry->ts : time();

        $sql = "INSERT INTO vitals_history (patient_id, systolic, diastolic, heartrate, rhythm, dataSource, deviceType, date_added)
                VALUES ('$patient_id', '$systolic', '$diastolic', '$heartrate', '$rhythm', 'FromDevice', 'BloodPressure', FROM_UNIXTIME('$timestamp'))";

        if (!mysqli_query($conn, $sql)) {
            throw new Exception('Error inserting blood pressure data: ' . mysqli_error($conn));
        }
    }
}

// Process Weight Data
function processWeightData($patient_id, $history, $conn) {
    foreach ($history as $entry) {
        $weight = isset($entry->wt) ? $entry->wt : null;
        $timestamp = isset($entry->ts) ? $entry->ts : time();

        $sql = "INSERT INTO vitals_history (patient_id, weight, dataSource, deviceType, date_added)
                VALUES ('$patient_id', '$weight', 'FromDevice', 'WeightMachine', FROM_UNIXTIME('$timestamp'))";

        if (!mysqli_query($conn, $sql)) {
            throw new Exception('Error inserting weight data: ' . mysqli_error($conn));
        }
    }
}

// Process Blood Glucose Data
function processGlucoseData($patient_id, $history, $conn) {
    foreach ($history as $entry) {
        $glucose = isset($entry->value) ? $entry->value : null;
        $meal = isset($entry->meal) ? $entry->meal : null;
        $type = isset($entry->type) ? $entry->type : null;
        $timestamp = isset($entry->ts) ? $entry->ts : time();

        $sql = "INSERT INTO vitals_history (patient_id, glucose, meal, type, dataSource, deviceType, date_added)
                VALUES ('$patient_id', '$glucose', '$meal', '$type', 'FromDevice', 'BloodGlucoseMeter', FROM_UNIXTIME('$timestamp'))";

        if (!mysqli_query($conn, $sql)) {
            throw new Exception('Error inserting glucose data: ' . mysqli_error($conn));
        }
    }
}

// Process Pulse Oximeter Data
function processPulseOximeterData($patient_id, $history, $conn) {
    foreach ($history as $entry) {
        $pi = isset($entry->PI) ? $entry->PI : null;
        $pulse_rate = isset($entry->pulse_rate) ? (int)$entry->pulse_rate : null;
        $spo2 = isset($entry->spo2) ? (int)$entry->spo2 : null;
        $battery = isset($entry->bat) ? (int)$entry->bat : null;
        $rssi = isset($entry->rssi) ? (int)$entry->rssi : null;
        $timestamp = isset($entry->ts) ? $entry->ts : time();

        $sql = "INSERT INTO vitals_history (patient_id, pulseox, heartrate, dataSource, deviceType, date_added)
                VALUES ('$patient_id', '$spo2', '$pulse_rate',  'FromDevice', 'PulseOximeter', FROM_UNIXTIME('$timestamp'))";

        if (!mysqli_query($conn, $sql)) {
            throw new Exception('Error inserting pulse oximeter data: ' . mysqli_error($conn));
        }
    }
}

// Match the request to the expected endpoint
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_SERVER['CONTENT_TYPE']) && $_SERVER['CONTENT_TYPE'] === 'application/json') {
    if (!isApiKeyValid()) {
        http_response_code(403);
        echo json_encode(['success' => false, 'message' => 'Unauthorized: Invalid API Key']);
        exit;
    }

    $inputData = file_get_contents('php://input');
    $data = json_decode($inputData);

    if ($data && isset($data->deviceId)) {
        $conn = ddxrxDBConnect();
        $device_id = mysqli_real_escape_string($conn, $data->deviceId);

        // Check if the device exists
        $sql = "SELECT * FROM cardiowell_users WHERE imei = '$device_id' LIMIT 1";
        $result = mysqli_query($conn, $sql);

        if ($result && $row = mysqli_fetch_assoc($result)) {
            $patient_id = $row['patient_id'];
            $deviceType = isset($data->data->model_number) ? $data->data->model_number : '';

            // Identify and process the data based on the device type
            if ($deviceType === 'YM402') { // Pulse Oximeter
                processPulseOximeterData($patient_id, $data->data->history, $conn);
            } elseif ($deviceType === 'TMB2084A') { // Blood Pressure Machine
                processBloodPressureData($patient_id, $data->data->history, $conn);
            } elseif ($deviceType === 'GBS2012B') { // Weight Machine
                processWeightData($patient_id, $data->data->history, $conn);
            } elseif ($deviceType === 'TELEBGM Gen1') { // Blood Glucose Meter
                processGlucoseData($patient_id, $data->data->history, $conn);
            } else {
                throw new Exception("Unknown device type: $deviceType");
            }

            echo json_encode(['status' => '200', 'message' => 'Data successfully inserted']);
        } else {
            echo json_encode(['status' => '204', 'message' => 'Device ID not found']);
        }

        $conn->close();
    } else {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Invalid JSON payload or missing deviceId']);
    }
    
} else {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Invalid request method or content type']);
}

?>
