<?php

/* 
 * This is a simple API for sending SMS notifications using an existing function in the system.
 *
 */

/* Sample JSON data to send SMS
{
    "user_id" : "+639150750898",
    "message" : "Patient has abnormal data"
}
*/

// Set header for JSON response
header('Content-type: application/json');

// Include functions
include('../process/functions.php');

// Get database connection
$conn = ddxrxDBConnect();

// Recieves data as a JSON
$reciever_data = json_decode(file_get_contents('php://input'), true);

// Get phone number from JSON data
$user_id = isset($reciever_data['user_id']) ? $reciever_data['user_id'] : null;

// Get message
$message = isset($reciever_data['message']) ? $reciever_data['message'] : null;

// Sanitize phone number and message
if (isset($user_id) && $user_id !== null) {
    $user_id = htmlspecialchars($user_id, ENT_QUOTES, 'UTF-8');
    $user_id = preg_replace('/[^\x20-\x7E]/', '', $user_id);
}

if (isset($message) && $message !== null) {
    $message = htmlspecialchars($message, ENT_QUOTES, 'UTF-8');
    $message = preg_replace('/[^\x20-\x7E]/', '', $message);
}

// Check if phone number and message are set
if( isset($user_id) && isset($message) ){
    
    // Get phone number from user ID
    $sql = "SELECT * FROM `all_users` INNER JOIN `patients` ON `all_users`.`userid` = `patients`.`user_id` WHERE `all_users`.`userid` = '$user_id';";

    // Execute query
    $result = $conn->query($sql);

    // Fetch result
    $row = $result->fetch_assoc();

    // Check if phone number exists
    if( $row !== null ){

        // $phoneNumber = $row['cell'];
        $data = array( 'patient_id' => $row['patient_id'] );
        $contactDetails = sendtoAPI( 'https://ddxrx.ai/user_profile_home_view', $data );

        // If nurse number is not provided, use physician number
        if( !empty($contactDetails->data->nurse_number) ){
            $phoneNumber = $contactDetails->data->nurse_number;
        }else{
            $phoneNumber = '+1 228 8068 004';
        }
        
        
        // Check if phone number is empty
        if( empty($phoneNumber) ){
            $output = array(
                'result' => false,
                'status_code' => '422',
                'response' => 'failed',
                'message' => 'Phone number is not provided.'
            );
            
            // Output JSON response
            echo json_encode($output);
            exit();
        }
    }else{
        $output = array(
            'result' => false,
            'status_code' => '404',
            'response' => 'failed',
            'message' => 'User not found.'
        );
        
        // Output JSON response
        echo json_encode($output);
        exit();
    }

    // Send SMS
    $response = send_sms($phoneNumber, $message);
    
    // Check if SMS was sent
    if( $response ){
        
        $output = array(
            'result' => true,
            'status_code' => '200',
            'response' => 'success',
            'message' => 'SMS sent successfully.',
            'contactDetails' => $contactDetails->data->nurse_number
        );
        
    }else{
        
        $output = array(
            'result' => false,
            'status_code' => '500',
            'response' => 'failed',
            'message' => 'Failed to send SMS.'
        );
        
    }

}else{
        
    $output = array(
            'result' => false,
            'status_code' => '422',
            'response' => 'failed',
            'message' => 'Missing required fields.'
        );
        
}

// Close database connection
$conn->close();

// Output JSON response
echo json_encode($output);