<?php

// Include functions
include_once('../process/functions.php');

// Output as JSON
header('Content-Type: application/json');

// Recieve JSON Input
$json = file_get_contents('php://input');

// Decode JSON
$data = json_decode($json, true);

// Check if JSON is valid
if (json_last_error() !== JSON_ERROR_NONE) {

    // JSON is invalid
    $output = array(
        'status_code' => '400',
        'status' => 'error',
        'message' => 'Invalid JSON'
    );

}else{

    // Check uniqueid in database
    $unique_id = $data['unique_id'];

    // SQL Query
    $sql = "SELECT * FROM `all_users` WHERE `unique_id` = '$unique_id' LIMIT 1";

    // Execute SQL Query
    $result = mysqli_query(ddxrxDBConnect(), $sql);

    // Fetch Result
    $row = $result->fetch_assoc();

    // check if there is a record returned
    if (mysqli_num_rows($result) > 0) {

        $output = array(
            'status_code' => '200',
            'status' => 'success',
            'message' => 'Unique ID is valid',
            'result' => array(
                'username' => $row['username'],
            )
        );

    } else {
        
        $output = array(
            'status_code' => '400',
            'status' => 'error',
            'message' => 'Invalid unique ID'
        );

    }

    // close database connection
    mysqli_close(ddxrxDBConnect());

}

// Output JSON
echo json_encode($output);

?>