$(document).ready(function () {

    /* --------------------------------------------------------------------------------------- */
    /* New Version below */
    /* --------------------------------------------------------------------------------------- */

    // Open Entry Item
    $('.adt-container .table-container .entryItem').click(function () {

        var entryItem = $(this).data('item');

        // Add class to entry item
        $('#entryItem-' + entryItem).toggleClass('opened');

        $('#item-detail-' + entryItem).toggleClass('show');

    });

    // Remove ADT diagnosis
    $('body').on('click', '.history-placeholder a', function () {
        $(this).remove();
    });

    // Diagnosis search
    $('.diagnosis-search-form').submit(function (e) {

        // Prevent the form from submitting
        e.preventDefault();

        // Register text box value into a variable
        var searchedText = $('.textbox', this).val();

        // Append text value to placeholder
        $('.history-placeholder').append('<a href="javascript:;">' + searchedText + '<ion-icon name="close-sharp"></ion-icon></a>');

        // Reset the form
        $('.textbox', this).val('');

    });

    // Show search result
    $('.diagnosis-search-form .textbox').on("input", function () {

        var parentID = $(this).parent().parent().parent().parent().parent().attr("id");

        // Check if the textbox value has changed
        if ($('#' + parentID + ' .diagnosis-search-form .textbox').val() !== $('#' + parentID + ' .diagnosis-search-form .textbox').previousValue) {

            var searchqry = $('#' + parentID + ' .diagnosis-search-form .textbox').val();

            $.ajax({
                type: "POST",
                url: 'process/adt-search-diagnosis.php',

                data: {
                    searchqry: searchqry,
                },
                beforeSend: function () {

                    $('#' + parentID + ' .diagnosis-search-form').append('<img src="assets/images/loading.svg" class="search-loading-icon">')

                },
                success: function (data) {

                    $('.search-loading-icon').remove();

                    if (data.result == true) {

                        $('#' + parentID + ' .search-result-list').html('');

                        var i;
                        for (i = 0; i < data.items.length; ++i) {
                            $('#' + parentID + ' .search-result-list').append('<li><a href="javascript:;">' + data.items[i].diagnosis + '</a></li>');
                        }

                        // Show search
                        $('#' + parentID + ' .search-result-list').show();

                    }

                }

            });

        }
    });

    // Search result click
    $('body').on('click', '.search-result-list li a', function () {

        var parentID = $(this).parent().parent().parent().parent().parent().parent().parent().attr('id');

        var item = $(this).html();

        // Append text value to placeholder
        $('#' + parentID + ' .history-placeholder').append('<a href="javascript:;"><span>' + item + '</span><ion-icon name="close-sharp"></ion-icon></a>');

        // Reset the form
        $('#' + parentID + ' .diagnosis-search-form .textbox').val('');

        // Hide search
        $('#' + parentID + ' .search-result-list').hide();

    });

    // Hide search result
    $('.diagnosis-search-form .textbox').on("keydown", function (event) {
        // Check if the escape key was pressed
        if (event.keyCode === 27) {

            // Hide search
            $('.search-result-list').hide();

        }
    });

    $(document).click(function (event) {
        // Check if the click was outside of the textbox
        if (!$('.diagnosis-search-form .textbox').is(event.target)) {

            // Hide search
            $('.search-result-list').hide();

        }
    });

    // Auto Generate ADT information
    $('.mrn-form form').submit(function (e) {

        // Prevent the form from submitting
        e.preventDefault();

        var searchqry = $('.mrn-input').val();

        // Check MRN number in database
        $.ajax({
            type: "POST",
            url: 'process/adt-check-mrn.php',
            data: {
                searchqry: searchqry,
            },
            beforeSend: function () {

                $('.adt-mrn-container .mrn-form .loading').show();

            },
            success: function (response) {

                var ajaxResult = response;

                if (response.result == false) {

                    // Hide MRN Form
                    $('.adt-mrn-container').hide();

                    // Show ADT Form
                    $('.adt-container').show();

                    // Insert MRN into textbox
                    $('.ddxrx-mrn').val(searchqry);

                } else {

                    Swal.fire({
                        title: 'MRN Number Found',
                        text: "Do you want to autofill existing patient information into the adt form?",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes',
                        cancelButtonText: 'Skip',
                        allowOutsideClick: false,
                    }).then((result) => {

                        if (result.isConfirmed) {

                            $('.patientid').val(ajaxResult.patient_id);
                            $('.ddxrx-mrn').val(ajaxResult.mrn);
                            $('.fname').val(ajaxResult.first_name);
                            $('.mname').val(ajaxResult.middle_name);
                            $('.lname').val(ajaxResult.last_name);
                            $('.mobile_no').val(ajaxResult.phone);
                            $('.dob').val(ajaxResult.dob);
                            $('.email').val(ajaxResult.email);
                            $('.address').val(ajaxResult.address);
                            $('.city').val(ajaxResult.city);
                            $('.state').val(ajaxResult.state);
                            $('.zip').val(ajaxResult.zip);

                            var i = 0;
                            for (i = 0; i < ajaxResult.diagnosed.length; i++) {
                                console.log(i);
                                console.log(i + ' ' + ajaxResult.diagnosed[i].diagnosis);
                                $('.history-placeholder').append('<a href="javascript:;"><span>' + ajaxResult.diagnosed[i].diagnosis + '</span> <ion-icon name="close-sharp"></ion-icon></a>');
                            }

                        } else {

                            $('.ddxrx-mrn').val(searchqry);

                        }

                        // Hide MRN Form
                        $('.adt-mrn-container').hide();

                        // Show ADT Form
                        $('.adt-container').show();

                    })

                }

            }
        });

    });

    // Add ADT
    $('.adt-patient-form .frm-btn.add').click(function () {

        var patientid = $('.patientid').val();
        var mrn = $('.ddxrx-mrn').val();
        var mrn_hospital = $('.hospital-mrn').val();
        var room_no = $('.room_no').val();
        var mobile_no = $('.mobile_no').val();
        var fname = $('.fname').val();
        var mname = $('.mname').val();
        var lname = $('.lname').val();
        var dob = $('.dob').val();
        var address = $('.address').val();
        var city = $('.city').val();
        var state = $('.state').val();
        var zip = $('.zip').val();
        var email = $('.email').val();

        if ($('.history-placeholder').html() != '') {

            var items = [];

            $('.history-placeholder a').each(function () {

                var item = $(this).children('span').html();
                items.push(item);

            });

            var diagnosis = JSON.stringify(items);


        } else {

            var diagnosis = JSON.stringify([]);

        }

        // var socketDataOBJ = {
        //     type: "ADT",
        //     patientId: patientid,
        //     roomNo: room_no,
        //     first_name: fname,
        //     middle_name: mname,
        //     last_name: lname,
        //     isValid: true,
        //     data: {
        //         mrn: mrn,
        //         mrn_hospital: mrn_hospital,
        //         dob: dob,
        //         address: address,
        //         city: city,
        //         state: state,
        //         zip: zip,
        //         email: email,
        //         mobile_no: mobile_no,
        //         diagnosis: items

        //     }
        // }

        // var socketData = JSON.stringify(socketDataOBJ);

        $.ajax({
            type: "POST",
            url: 'process/adt-add-patient.php',
            data: {
                patientid: patientid,
                mrn: mrn,
                mrn_hospital: mrn_hospital,
                room_no: room_no,
                mobile_no: mobile_no,
                fname: fname,
                mname: mname,
                lname: lname,
                dob: dob,
                address: address,
                city: city,
                state: state,
                zip: zip,
                email: email,
                diagnosis: diagnosis
            },
            beforeSend: function () { },
            success: function (response) {

                if (response.result == true) {

                    Swal.fire({
                        title: response.title,
                        text: response.desc,
                        icon: response.icon,
                        showCancelButton: false,
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'Done'
                    }).then((result) => {
                        if (result.isConfirmed) {

                            // Go to URL
                            window.location.replace("adt-dashboard.php");

                        }
                    })

                } else {

                    Swal.fire({
                        icon: response.icon,
                        title: response.title,
                        text: response.desc
                    });

                }

            }
        });

        // Send Socket data turned off temporarily
        // $.ajax({
        //     url: 'https://clinician.club/push_data',
        //     type: "POST",
        //     data: socketData,
        //     contentType: "application/json",
        //     beforeSend: function () { },
        //     success: function (response) { }
        // });

    });

    // Edit ADT
    $('.adt-patient-form .frm-btn.update').click(function () {

        var parentID = $(this).parent().parent().parent().parent().attr('id');
        var adtID = $(this).parent().parent().parent().parent().data('adt-id');
        var patient_id = $(this).parent().parent().parent().parent().data('patient-id');
        var mrn = $('#' + parentID + ' .ddxrx-mrn').val();
        var mrn_hospital = $('#' + parentID + ' .hospital-mrn').val();
        var room_no = $('#' + parentID + ' .room_no').val();
        var mobile_no = $('#' + parentID + ' .mobile_no').val();
        var fname = $('#' + parentID + ' .fname').val();
        var mname = $('#' + parentID + ' .mname').val();
        var lname = $('#' + parentID + ' .lname').val();
        var dob = $('#' + parentID + ' .dob').val();
        var address = $('#' + parentID + ' .address').val();
        var city = $('#' + parentID + ' .city').val();
        var state = $('#' + parentID + ' .state').val();
        var zip = $('#' + parentID + ' .zip').val();
        var email = $('#' + parentID + ' .email').val();

        if ($('#' + parentID + ' .history-placeholder').html() != '') {

            var items = [];

            $('#' + parentID + ' .history-placeholder a').each(function () {

                var item = $(this).children('span').html();
                items.push(item);

            });

            var diagnosis = JSON.stringify(items);


        } else {

            var diagnosis = JSON.stringify([]);

        }

        $.ajax({
            type: "POST",
            url: 'process/adt-edit-patient.php',
            data: {
                patient_id: patient_id,
                adtID: adtID,
                mrn: mrn,
                mrn_hospital: mrn_hospital,
                room_no: room_no,
                mobile_no: mobile_no,
                fname: fname,
                mname: mname,
                lname: lname,
                dob: dob,
                address: address,
                city: city,
                state: state,
                zip: zip,
                email: email,
                diagnosis: diagnosis
            },
            beforeSend: function () { },
            success: function (response) {

                const Toast = Swal.mixin({
                    toast: true,
                    position: 'bottom-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true
                })

                Toast.fire({
                    icon: response.icon,
                    title: response.desc
                })

            }
        });

    });

});