$(document).ready(function(){

    $(document).on('change','.hospitalUnit',function(){
        
        var selectedUnit = $('.hospitalUnit :selected').val();
        
        if( selectedUnit != '' ){
            
            // Remove disabled for label
            $('label.validation').removeClass('disabled');
            
            // Remove textbox disabled
            $('.textbox').prop("disabled", false);
            
            // Remove button disabled
            $('.submitbutton').removeClass('disabled');
            $('.submitbutton').addClass('enabled');
            
        }else{
            
            // Remove disabled for label
            $('label.validation').addClass('disabled');
            
            // Remove textbox disabled
            $('.textbox').prop("disabled", true);
            
            // Remove button disabled
            $('.submitbutton').addClass('disabled');
            $('.submitbutton').removeClass('enabled');
            
        }
        
    });
    
    // Submit Data
    $(document).on('click','.submitbutton.enabled',function(){
        
        var hospitalUnit = $('.hospitalUnit').val();
        var patientname = $('.patientname').val();
        var dob = $('.dob').val();
        var room_no = $('.room_no').val();
        var assigned_nurse = $('.assigned_nurse').val();
        
        $.ajax({
            type: "POST",
            url: 'process/assign-nurse.php',
            
            data:{
                hospitalUnit:hospitalUnit,
                patientname: patientname,
                dob: dob,
                room_no: room_no,
                assigned_nurse: assigned_nurse
            },
            
            success: function(data){
                
                Swal.fire({
                    icon: data.icon,
                    title: data.title,
                    text: data.text,
                });
                
                if( data.result == true ){
                    
                    //Reset selectbox value
                    $('.hospitalUnit option[value=""]').attr('selected','selected');
                    
                    
                    // Remove disabled for label
                    $('label.validation').addClass('disabled');
                    
                    // Remove textbox disabled
                    $('.textbox').prop("disabled", true);
                    $('.textbox').val('');
                    
                    // Remove button disabled
                    $('.submitbutton').addClass('disabled');
                    $('.submitbutton').removeClass('enabled');
                    
                }
                
            }
        
        });
        
    });

});