$(document).ready(function(){
    
    var session_id = Math.floor((Math.random() * 1000) * 100);
    
    // Step 1
    $('body').on('click', '.button.step-1', function() {
        
        var fname = $('.textbox.fname').val();
        var mname = $('.textbox.mname').val();
        var lname = $('.textbox.lname').val();
        
        $.ajax({
            type: "POST",
            url: 'process/check_account.php?step=one',
            data: {
				fname:fname,
				mname:mname,
				lname:lname
			},
                                
            beforeSend: function(){
                
                $('.form-container .status').fadeIn();
                
            },
            
            success: function(data){
                
                $('.form-container .status').fadeOut();
                
                if( data.rstatus == 'success' ){
                    
                    $('.form-placeholder').html(data.form);
                    
                }else if( data.rstatus == 'error' ){
                    
                    Swal.fire({
                        icon: data.rstatus,
                        title: data.title,
                        text: data.text,
                    });
                    
                }
                
            },
            
            failure: function(errMsg) {}
        
        });
        
    });
    
    // Step 2
    $('body').on('click', '.button.step-2', function() {
        
        var year = $('.form-placeholder .birth-year').val();
        var month = $('.form-placeholder .birth-month').val();
        var day = $('.form-placeholder .birth-day').val();
        var birthdate = year+'-'+month+'-'+day;
        var gender = $(".radio-group input[type='radio']:checked").val();
        
        if( year != '' && month != '' && day != '' ){
            
            $.ajax({
            type: "POST",
            url: 'process/check_account.php?step=two',
            data: {
				year:year,
				month:month,
				day:day,
				birthdate:birthdate,
				gender:gender
			},
                                
            beforeSend: function(){
                
                $('.form-container .status').fadeIn();
                
            },
            
            success: function(data){
                
                $('.form-container .status').fadeOut();
                
                if( data.rstatus == 'success' ){
                    
                    $('.form-placeholder').html(data.form);
                    
                }else if( data.rstatus == 'error' ){
                    
                    Swal.fire({
                        icon: data.rstatus,
                        title: data.title,
                        text: data.text,
                    });
                    
                }
                
            },
            
            failure: function(errMsg) {}
        
            });
            
        }else{
            
            Swal.fire({
                icon: 'error',
                title: 'Empty Fields',
                text: 'Please fill up your date of birth before proceeding.'
            })
            
        }
        
    });
    
    // Step 3
    $('body').on('click', '.button.step-3', function() {

        var mobileNumber = $('.mobileNumber').val();
        var emailAddress = $('.emailAddress').val();
        
        if( mobileNumber != '' ){
            
            $.ajax({
            type: "POST",
            url: 'process/check_account.php?step=three',
            data: {
				mobileNumber:mobileNumber,
				emailAddress:emailAddress
			},

            beforeSend: function(){
                
                $('.form-container .status').fadeIn();
                
            },
            
            success: function(data){
                
                $('.form-container .status').fadeOut();
                
                if( data.rstatus == 'success' ){
                    
                    $('.form-placeholder').html(data.form);
                    
                }else if( data.rstatus == 'error' ){
                    
                    Swal.fire({
                        icon: data.rstatus,
                        title: data.title,
                        text: data.text,
                    });
                    
                }
                
            },
            
            failure: function(errMsg) {}
        
            });
            
        }else{
            
            Swal.fire({
                icon: 'error',
                title: 'Required Phone Number',
                text: 'Phone number is required to proceed with next step'
            })
            
        }
        
    });
    
    // Step 4
    $('body').on('click', '.button.step-4', function() {

        var username = $('.username').val();
        var password = $('.password').val();
        var repassword = $('.repassword').val();
        
        if( $('.nda-agreement').prop('checked') === true){
            
            var nda_agreement = 'true';
            
        }else{
            
             var nda_agreement = 'false';
             
        }
        
        
        if( username != '' && password != '' && nda_agreement != '' ){
            
            $.ajax({
            type: "POST",
            url: 'process/check_account.php?step=four',
            data: {
				username:username,
				password:password,
				repassword:repassword,
				nda_agreement:nda_agreement
			},

            beforeSend: function(){
                
                $('.form-container .status').fadeIn();
                
            },
            
            success: function(data){
                
                $('.form-container .status').fadeOut();
                
                if( data.rstatus == 'success' ){
                    
                    //$('.form-placeholder').html(data.form);
                    
                    Swal.fire({
                        icon: data.rstatus,
                        title: data.title,
                        text: data.text,
                    });
                    
                }else if( data.rstatus == 'error' ){
                    
                    Swal.fire({
                        icon: data.rstatus,
                        title: data.title,
                        text: data.text,
                    });
                    
                }
                
            },
            
            failure: function(errMsg) {}
        
            });
            
        }else{
            
            Swal.fire({
                icon: 'error',
                title: 'Empty Fields',
                text: 'Please fill up thhe forms to proceed.'
            });
            
        }
        
    });
    
    // Custom Selectbox
    $('.selectbox-list ul li a').click(function(){
        $('.selectbox-list ul li a').removeClass('active');
        $(this).addClass('active');
        
        //var selectedValue = $('.selectbox-list .year .active').data('year');
        var selectedValue = $(this).data('select');
        var target = $(this).closest("ul").attr('class');
        $('.birth-'+target).val(selectedValue);
        
    });
    
    // Select Popup
    $('body').on('click touch', '.birth-year', function(e) {
        e.preventDefault();
        $('.selectbox-list ul').hide();
        $('.selectbox-list .year').show();
        $('.modal-popup').css("display", "flex");
    });
    
    $('body').on('click touch', '.birth-month', function(e) {
        e.preventDefault();
        $('.selectbox-list ul').hide();
        $('.selectbox-list .month').show();
        $('.modal-popup').css("display", "flex");
    });
    
    $('body').on('click touch', '.birth-day', function(e) {
        e.preventDefault();
        $('.selectbox-list ul').hide();
        $('.selectbox-list .day').show();
        $('.modal-popup').css("display", "flex");
    });
    
    // Close Button
    $('body').on('click touch', '.modal-popup .selectbox-list .close', function() {
        
        $('.modal-popup').hide();
         
    });
    
});