$(document).ready(function(){

    $('.note-form').on('submit', function (e) {
        e.preventDefault();

        var output = '';
        var changedValues = [];
        var changedValuesJSON = '';

        // Reset localStorage
        localStorage.setItem('savedInput', JSON.stringify([]));

        // NEW: group by decision-group
        $('.note-content .decision-group').each(function () {
            var group        = $(this);
            var groupTitle   = group.find('.dd-title').first().text();
            var groupOutput  = '';
            
            // Check if this group has items to process (skip static groups)
            var hasItems = group.find('.item label').length > 0;
            
            if (!hasItems) {
                // This is a static group, keep it as is
                output += group[0].outerHTML;
                return; // Skip to next group
            }
            
            // Get all form-section elements and organize content by section
            var formSections = group.find('.form-section');
            var sectionGroups = {};
            var hasFormSections = formSections.length > 0;
            
            // Initialize section groups
            formSections.each(function() {
                var sectionText = $(this).text().trim();
                sectionGroups[sectionText] = {
                    html: this.outerHTML,
                    items: ''
                };
            });

            group.find('.item label').each(function () {
                var spans     = $(this).children('span');
                var spanText1 = $(spans[0]).text();
                var spanText2 = $(spans[1]).text();
                var input     = $(this).children('input, textarea');
                var value     = input.val();
                var type      = input.attr('type') || input.prop('tagName').toLowerCase();
                var inputName = input.attr('name');

                // Remove anything within square brackets including the brackets themselves from all text
                var cleanSpanText1 = spanText1.replace(/\[[^\]]*\]/g, '').trim();
                var cleanSpanText2 = spanText2.replace(/\[[^\]]*\]/g, '').trim();
                var cleanValue = value.replace(/\[[^\]]*\]/g, '').trim();

                // Add space before cleanSpanText2 if it doesn't start with punctuation
                if (cleanSpanText2 && !cleanSpanText2.match(/^[.,;:!?]/)) {
                    cleanSpanText2 = ' ' + cleanSpanText2;
                }

                var itemOutput = '';
                if (type === 'checkbox' && input.is(':checked')) {
                    itemOutput = '<div class="preview-item"><span class="material-symbols-outlined check"> priority </span> ' + cleanSpanText1 + '</div>';
                }
                if ((type === 'text' || type === 'number') && value !== '') {
                    itemOutput = '<div class="preview-item"><span class="material-symbols-outlined note"> description </span> ' + cleanSpanText1 + ' <strong> ' + cleanValue + '</strong> ' + cleanSpanText2 + '</div>';
                }
                if (type === 'textarea' && value !== '') {
                    itemOutput = '<div class="preview-item"><span class="material-symbols-outlined note"> description </span> ' + cleanSpanText1 +' '+ cleanValue + '</div>';
                }

                if (hasFormSections) {
                    // Find which form section this item belongs to by checking previous siblings
                    var itemSection = $(this).closest('.item').prevAll('.form-section').first();
                    var sectionText = itemSection.length > 0 ? itemSection.text().trim() : '';
                    
                    // If no section found, use the first available section
                    if (!sectionText || !sectionGroups[sectionText]) {
                        var availableSections = Object.keys(sectionGroups);
                        if (availableSections.length > 0) {
                            sectionText = availableSections[0];
                        }
                    }
                    
                    if (itemOutput && sectionGroups[sectionText]) {
                        sectionGroups[sectionText].items += itemOutput;
                    }
                } else {
                    // No form sections, just add directly to groupOutput
                    if (itemOutput) {
                        groupOutput += itemOutput;
                    }
                }

                if (
                    (type === 'checkbox' && input.is(':checked')) ||
                    ((type === 'text' || type === 'number' || type === 'textarea') && value !== '')
                ) {
                    changedValues.push({
                        group: groupTitle,      // keep track of group
                        name:  inputName,
                        value: cleanValue,      // use cleaned value instead of original
                        type:  type
                    });
                }
            });

            // Build output with sections and their items (if form sections exist)
            if (hasFormSections) {
                for (var sectionText in sectionGroups) {
                    if (sectionGroups[sectionText].items) {
                        groupOutput += sectionGroups[sectionText].html + sectionGroups[sectionText].items;
                    }
                }
            }

            // add heading and organized sections only if the group has data
            if (groupOutput !== '') {
                output += '<div class="decision-group"><h1 class="dd-title">' + groupTitle + '</h1>' + groupOutput + '</div>';
            }
        });

        changedValuesJSON = JSON.stringify(changedValues);
        localStorage.setItem('savedInput', changedValuesJSON);

        $('.parsed-form').html(output);
        $('.btn-preview-group').hide();
        $('.btn-save-group').show();
    });


    // Save Notes
    $('.save-button').click(function(e) {
        // Prevent default form submission
        e.preventDefault();

        var savedInput = localStorage.getItem('savedInput');
        var waiting_room_id = $('.waiting_room_id').val();

        if (savedInput) {
            Swal.fire({
                title: 'Are you sure?',
                text: "Once you sign and save, you won't be able to edit this note.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, sign and save',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: 'process/save_encounter_notes.php', // Replace with your actual endpoint
                        type: 'POST',
                        data: {
                            waiting_room_id: waiting_room_id,
                            savedInput: savedInput
                        },
                        success: function(response) {
                            if (response.result === true) {
                                // Reload the page after saving
                                setTimeout(function() {
                                    location.reload();
                                }, 1000);
                            }
                            Swal.fire({
                                title: response.title,
                                text: response.message,
                                icon: response.icon
                            });
                        },
                        error: function(xhr, status, error) {
                            alert('Error saving notes: ' + error);
                        }
                    });
                }
            });
        }
    });

    // Refresh Page
    $('.refresh').click(function() {
        location.reload();
    });

    // Save Addendum
    $('.save-addendum').click(function(e) {
        e.preventDefault();

        var addendumText = $('.addendum_text').val();
        var waiting_room_id = $('.waiting_room_id').val();

        // Debug: log the values to see what we're getting
        console.log('Addendum text:', addendumText);
        console.log('Waiting room ID:', waiting_room_id);
        console.log('Addendum text length:', addendumText.length);

        if (addendumText === '' || addendumText.trim() === '') {
            Swal.fire({
                title: 'Error',
                text: 'Addendum cannot be empty.',
                icon: 'error'
            });
            return;
        }

        $.ajax({
            url: 'process/save_addendum.php', // Replace with your actual endpoint
            type: 'POST',
            data: {
                waiting_room_id: waiting_room_id,
                addendum_text: addendumText
            },
            success: function(response) {
                // Debug: log the response to see what we're getting
                console.log('Response received:', response);
                
                // Try to parse response if it's a string
                if (typeof response === 'string') {
                    try {
                        response = JSON.parse(response);
                    } catch (e) {
                        console.error('Failed to parse JSON response:', response);
                        alert('Server returned invalid response. Check console for details.');
                        return;
                    }
                }
                
                if (response.result === true) {
                    // Reload the page after saving
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                }
                Swal.fire({
                    title: response.title,
                    text: response.message,
                    icon: response.icon
                });
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', {
                    status: xhr.status,
                    statusText: xhr.statusText,
                    responseText: xhr.responseText,
                    error: error
                });
                alert('Error saving addendum: ' + error);
            }
        });

    });

});
