$(document).ready(function(){

    // Password Toggle
    $('body').on('click', '.password-toggle', function() {
        var passwordField = $(this).siblings('.textbox.password');
        var currentType = passwordField.attr('type');
        
        if (currentType === 'password') {
            passwordField.attr('type', 'text');
            $(this).attr('src', 'assets/images/password-hide.svg');
            $(this).attr('alt', 'Hide password');
        } else {
            passwordField.attr('type', 'password');
            $(this).attr('src', 'assets/images/password-show.svg');
            $(this).attr('alt', 'Show password');
        }
    });

    // Login
    $('body').on('submit', '.login-form', function(e) {
        
        // Prevent the form from submitting
        e.preventDefault();

        var username = $('.login-form .textbox.username').val();
        var password = $('.login-form .textbox.password').val();

        // Check if Username & Password is not empty
        if( username != '' && password != '' ){

            // Show Popup
            $('.disclaimer-popup-container').addClass('show');

        }else{

            Swal.fire({
                icon: "warning",
                title: "Empty Fields",
                text: "Empty username or password, please fill up the fields before attempting to login.",
            });

        }

    });
    
    $('.disclaimer-popup-container .disclaimer-container .button-container a.btn.agree').click(function(e){
        
        // Prevent the form from submitting
        e.preventDefault();

        var username = $('.login-form .textbox.username').val();
        var password = $('.login-form .textbox.password').val();
        var action = $('.login-form').attr('action');

        // Send Data to Server
        $.ajax({
            url: action,
            type: 'POST',
            data: {
                username: username,
                password: password
            },
            success: function(data){
                
                $('.disclaimer-popup-container').removeClass('show');

                if( data.result === true ){
                        
                    // Store GUID in Local Storage
                    var patientData = {};
                    patientData.waitingroom_id = data.login_details.waitingroom_id;
                    patientData.idKey = data.login_details.guid;
                    patientData.checkInTime = Date.now();
                    localStorage.setItem("patient", JSON.stringify(patientData));

                    // Redirect
                    window.location.href = data.redirect_url;
        
                }else{
        
                    Swal.fire({
                        icon: data.icon,
                        title: data.title,
                        text: data.text,
                    })
        
                }
        
            }

        });

    });

    // Disagree
    $('.disclaimer-popup-container .disclaimer-container .button-container a.btn.disagree').click(function(e){
        
        // Prevent the form from submitting
        e.preventDefault();

        $('.disclaimer-popup-container').removeClass('show');

    });

});


$(document).ready(function () {
    const urlParams = new URLSearchParams(window.location.search);
    const msg = urlParams.get('msg');

    if (msg) {
        let config = {
            unlocked: {
                icon: 'success',
                title: 'Account Unlocked',
                text: 'Your account has been unlocked. You may now log in.'
            },
            expired: {
                icon: 'warning',
                title: 'Link Expired',
                text: 'This unlock link is invalid or expired. Try logging in again to receive a new unlock email.'
            },
            invalid: {
                icon: 'error',
                title: 'Invalid Request',
                text: 'The unlock link is invalid. Please try again.'
            },
            error: {
                icon: 'error',
                title: 'Unlock Failed',
                text: 'Something went wrong while unlocking your account. Please contact support.'
            }
        };

        if (config[msg]) {
            Swal.fire({
                icon: config[msg].icon,
                title: config[msg].title,
                text: config[msg].text,
                confirmButtonText: 'OK'
            });
        }
    }
});
