<?php

// Turn off all error reporting
error_reporting(0);

/*

Status Codes

200 - Everything is OK
201 - Created Successfully
202 - Accepted
204 - No Content
301 - Moved Permanently
400 - Bad Request
401 - Unauthorized
404 - Not Found
500 - Internal Server Error



Sample Format

{
  "apikey":"q5e7buR33aEQug3nbcULGupBqmkNkvhnQamnj75pGR8hsrYTbd2UJatc699h",
  "imei": "865284043588031",
  "response": "success",
  "type": "bp",
  "values": {
    "diastolic": 840,
    "heartrate": 587,
    "regular": 50,
    "systolic": 1329
  }
}

*/


// Header Type
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

// Includes
include('../process/functions.php');

// Vvariables declaration
$reiteshAPIkey = 'q5e7buR33aEQug3nbcULGupBqmkNkvhnQamnj75pGR8hsrYTbd2UJatc699h';
$data = file_get_contents('php://input');
$data = json_decode($data);


if( $data->apikey == $reiteshAPIkey ){
    
    // Mysql Connection and get data from database
    $imei_id = $data->imei;
    $sql = "SELECT * FROM cardiowell_users WHERE imei = '$imei_id' LIMIT 1";
    $result = mysqli_query(ddxrxDBConnect(), $sql);
    $row = mysqli_fetch_assoc($result);
    
    
    //if( $data->imei = $row['imei'] ){
    if( $data->imei == $row['imei'] && $data->type == $row['type'] ){
        
        $patient_id = $row['patient_id'];
        $diastolic = $data->values->diastolic;
        $heartrate = $data->values->heartrate;
        $regular = $data->values->regular;
        $systolic = $data->values->systolic;
        $type = $data->type;
        
        $sql = "INSERT INTO vitals_history (patient_id, systolic, diastolic, heartrate, rhythm, dataSource, deviceType) VALUES ('$patient_id', '$systolic', '$diastolic', '$heartrate', '$regular', 'FromDevice', '$type')";
    
        if (mysqli_query(ddxrxDBConnect(), $sql)) {
            
            $result = array(
                'status' => '200',
                'status_desc' => 'Vitals successfully inserted'
            );
        
        } else {
            
            $result = array(
                'status' => '500',
                'status_desc' => 'Internal Server Error'
                //'error_desc' => "Error: " . $sql . "<br>" . mysqli_error(ddxrxDBConnect()),
            );
            
        }
    
    }else{
        
        // No imei code match
        $result = array(
            'status' => '204',
            'status_desc' => 'Does not match'
        );
        
    }
    
    mysqli_close(ddxrxDBConnect());
    
}else{
    
    $result = array(
        'status' => '401',
        'status_desc' => 'Unauthorized'
    );
    
}

echo json_encode($result);

?>