$(document).ready(function(){
    
    localStorage.setItem("entity", "");
    
    $('.common-symptoms a').click(function(){
        
        var symptom = $(this).attr('data-symptoms');
        
        $('.textbox.search_phrase').val(symptom);
        
    });
    
    $('body').on('click', '.form-container .button', function() {
        
        var user_id = '1';
        var userInput = $('.search_phrase').val();
        var entity = localStorage.getItem("entity");
        
        var sendData = {
            "user_id" : user_id,
            "question" : userInput,
            "entity" : entity
        };
        
        $.ajax({
            type: "POST",
            url: 'https://f343083f.ngrok.io',

            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            
            beforeSend: function() {
                $('.response-container h1').text('Thinking . . .');
                $('.response-container h1').addClass('thinking');
                $('.bot-reaction').removeClass('idle');
                $('.bot-reaction').addClass('thinking'); 
                $('.form-container .textbox').addClass('thinking');
                $('.common-symptoms h6').addClass('thinking');
            },

            success: function(data){

                setTimeout(function(){
                    
                    $('.response-container h1').text(data.response);
                    $('.bot-reaction').removeClass('thinking');
                    $('.bot-reaction').addClass('idle');
                    $('.response-container h1').removeClass('thinking');
                    $('.form-container .textbox').removeClass('thinking');
                    $('.common-symptoms h6').removeClass('thinking');
                    $('.textbox.search_phrase').val('');
                }, 1000);

                // Set The Entity Value
                localStorage.setItem("entity", data.intent);
                
                console.log(data.response);
                console.log(data.intent);

            },
            
            failure: function(errMsg) {
                
                $('.response-container h1').text('I seem to be malfunctioning');
                $('.bot-reaction').removeClass('thinking');
                $('.bot-reaction').addClass('angry');

            }
            
        });
    });
    
    
    
    /* ==================================================== */
    /* Navigation Menu */
    /* ==================================================== */
    $('body').on('click', '.nav-menu.open', function() {
        
        $('.wrapper').addClass('blur');
        $('#particles-js').addClass('blur');
        $('.nav-container').addClass('show');
        
        $('.nav-menu.open').addClass('close');
        $('.nav-menu.open').removeClass('open');
        
    });
    
    //$('.nav-menu.close').click(function(){
    $('body').on('click', '.nav-menu.close', function() {
        
        $('.wrapper').removeClass('blur');
        $('#particles-js').removeClass('blur');
        $('.nav-container').removeClass('show');
        
        $('.nav-menu.close').addClass('open');
        $('.nav-menu.close').removeClass('close');
        
    });
});