$(document).ready(function(){
            
    // Get monitor height
    var screenHeight = $(window).height();

    // Calculate Message List height for patients
    var formHeight = $('.form-container').outerHeight();
    var messageListHeight = screenHeight-formHeight;
    
    $('#messages').css('height', messageListHeight);

    // Calculate chat header height to be used for chat messages margin top
    var chatHeaderHeight = $('.chat-header').outerHeight();
    $('#messages').css('margin-top', chatHeaderHeight);

    // Calculate Message List height for providers
    var formHeightAlt = $('.form-container-alt').outerHeight();
    var messageListHeightAlt = screenHeight-formHeightAlt-chatHeaderHeight;

    $('.message-list.provider').css('height', messageListHeightAlt);
    $('.chat-wrapper').css('height', screenHeight);
    $('.sidebar').css('height', screenHeight);

    // Scroll down by default
    scrollToBottomChat();

    // Navigation Button
    $('.nav a').on('click', function(){
        $('.nav').find('.active').removeClass('active');
        $(this).addClass('active');

        if( $(this).html() == "Messages" ){
            $('.thread-list').removeClass('active');
            $('.thread-list.messages').addClass('active');
        }else if( $(this).html() == "Contacts" ){
            $('.thread-list').removeClass('active');
            $('.thread-list.contacts').addClass('active');
        }

    });

});

// Initialize Nice Scroll
$(document).ready(function(){

    // For sidebar
    $(".sidebar").niceScroll({
        autohidemode: "leave",
        cursorcolor: "#8ec1f5",
        cursorborder: "none"
    });

    // For chat messasges
    $(".message-list").niceScroll({
        autohidemode: "false",
        cursorcolor: "#027eff",
        cursorborder: "none"
    });

});

// Scroll to bottom of chat when page is loaded
function scrollToBottomChat(){
    var element = document.getElementById("messages");
    var chatHeight = element.scrollHeight;
    $('#messages').animate({ scrollTop: chatHeight }, 100);
}

// Play Chat Sound
function chat_sound( soundType = 'chat' ){

    if( soundType == 'chat' ){
        var audio = new Audio('assets/others/chat-sound.mp3');
    }else if( soundType == 'chat-2' ){
        var audio = new Audio('assets/others/chat-sound-2.mp3');
    }else if( soundType == 'notification' ){
        var audio = new Audio('assets/others/join.mp3');
    }

    audio.play();
}

// Epoch to elapsed time
function timeSince(date) {

    // Assign date
    var seconds = Math.floor((new Date() - date) / 1000);

    // Get time lapsed in years
    var interval = seconds / 31536000;
    if (interval > 1) {
        // if years is 1, show year
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " year ago";
        }else{
            return Math.floor(interval) + " years ago";
        }
    }
    
    // Get time lapsed in months
    interval = seconds / 2592000;
    if (interval > 1) {
        // if months is 1, show month
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " month ago";
        }else{
            return Math.floor(interval) + " months ago";
        }
    }
    
    // Get time lapsed in days
    interval = seconds / 86400;
    if (interval > 1) {
        // if days is 1, show day
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " day ago";
        }else{
            return Math.floor(interval) + " days ago";
        }
    }

    // Get time lapsed in hours
    interval = seconds / 3600;
    if (interval > 1) {
        // If hours is 1, show hour
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " hour ago";
        }else{
            return Math.floor(interval) + " hours ago";
        }
    }

    // Get time lapsed in minutes
    interval = seconds / 60;
    if (interval > 1) {
        // If minutes is 1, show minute
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " minute ago";
        }else{
            return Math.floor(interval) + " minutes ago";
        }
    }

    // Get time lapsed in seconds
    // if seconds is 1, show second
    if(Math.floor(seconds) == 1){
        return Math.floor(seconds) + " second ago";
    }else{
        return Math.floor(seconds) + " seconds ago";
    }

}

// Update time lapsed
function updateTimeLapsed() {
    var timeLapsed = document.querySelectorAll('.time-lapsed');
    timeLapsed.forEach(function(time) {
        var timeLapsed = timeSince(time.getAttribute('data-time'));
        time.innerHTML = timeLapsed;
    });
}

// Load more contact list for patients
$(document).ready(function(){

    var patientThreadList = $('.patient-contact-list').height();

    $('.load_patients').on('click', function(){

        var next_page = $(this).attr('data-page');
        var currentSidebarHeight = $('.sidebar').height();

        $.ajax({
        
            url: 'process/patient_pagination.php',
            type: 'POST',
            data: { page: next_page },
            success: function(data){

                if( data.result == true ){
                    
                    var items = data.items;

                    // Add +1 to next page
                    var plus_one = parseInt(next_page) + 1;
                    $('.load_patients').attr('data-page', plus_one);

                    // Loop through items
                    $.each(items, function(i, item){
                        // Append to contact list
                        $('ul.patient-contact-list').append('<li class="thread-item"><a href="javascript:;" data-user-id="'+items[i].user_id+'" data-name="'+items[i].patient_fname+' '+items[i].patient_lname+'"><ion-icon name="person-circle-outline"></ion-icon><span>'+items[i].patient_fname+' '+items[i].patient_lname+'</span></a><div class="clear"></div></li>');
                    
                        console.log( items[i].user_id );

                    });

                    // Update sidebar height
                    $('.sidebar').css('height', currentSidebarHeight+0.1);

                }else{

                    // Remove load more button
                    $('.load_patients').remove();

                }

            }

        });

    });
});

// Load Thread
$(document).ready(function(){

    $('body').on('click', '.thread-item a', function() {
        
        var user_id = $(this).attr('data-user-id');
        var name = $(this).attr('data-name');
        var room_id = user_id;

        $('#messages').attr('data-group', user_id);
        $('#messages').attr('data-name', name);

        // Change Chat Header Name
        $('.chat-header .desc .name').html(name);

        // Update chat list via ajax
        $.ajax({
            url: 'process/load_messages.php',
            type: 'POST',
            data: {
                room_id: room_id
            },
            success: function(data){
                
                // Clear messages
                $('#messages').html('');

                if( data.result == true ){

                    // Set has room indicator
                    $('#messages').attr('data-has-room', 'yes');

                    // Loop through items in backwards order
                    for (var i = data.messages.length - 1; i >= 0; i--) {
                        $('#messages').append('<li class="chatItem"><ion-icon name="person-circle-outline"></ion-icon><div class="content"><h6 class="username">'+data.messages[i].sender_name+'</h6><div class="messageContainer">'+data.messages[i].msg+'</div><div class="time-lapsed" data-time="'+data.messages[i].sent_date+'">...</div></div><div class="clear"></div></li>');
                    }

                    // Scroll to bottom of chat after loading messages
                    scrollToBottomChat();

                }else{

                    // Set has room indicator
                    $('#messages').attr('data-has-room', 'no');

                    // Send error message
                    $('#messages').append('<li class="chatItem"><div class="systemContent leftChat">No chat history with '+name+' yet. Write message and send to start a conversation.</div></li>');

                }

            }
        });

        // Create Chat Room
        $.ajax({
        
            url: 'process/create_room.php',
            type: 'POST',
            data: {
                room_id: room_id
            },
            success: function(data){
                console.log(data);
            }

        });

    });

});

// Update time lapsed every 60 seconds
setInterval(updateTimeLapsed, 10000);