$(document).ready(function(){
    
    // Email Validation
    function ValidateEmail(email) {
        
        var emailRegex = /^[-!#$%&'*+\/0-9=?A-Z^_a-z{|}~](\.?[-!#$%&'*+\/0-9=?A-Z^_a-z`{|}~])*@[a-zA-Z0-9](-*\.?[a-zA-Z0-9])*\.[a-zA-Z](-?[a-zA-Z0-9])+$/;
        
        if (!email)
            return false;
    
        if(email.length>254)
            return false;
    
        var valid = emailRegex.test(email);
        if(!valid)
            return false;
    
        // Further checking of some things regex can't handle
        var parts = email.split("@");
        if(parts[0].length>64)
            return false;
    
        var domainParts = parts[1].split(".");
        if(domainParts.some(function(part) { return part.length>63; }))
            return false;
    
        return true;
    }

    // Save keywords
    function save_keywords( post_id ){

        var temp_arr = [];

        $('.keyword-placeholder .keywordItem').each(function(e){

            var keywordItem = $(this).text();

            temp_arr.push(keywordItem);

        });

        // Register output variable and assign temporary array values
        var output = JSON.stringify(temp_arr);

        $.ajax({
            url: 'process/add-keywords.php',
            type: 'POST',
            data: {
                post_id: post_id,
                keywords: output
            },
            success: function(data){
                console.log('Keyword data saved');
            }

        });

    }

    // Check duplicate keywords
    function check_keywords( keywordItem, callback ){

        // Send Data to Server
        $.ajax({
            url: 'process/check_keyword.php',
            type: 'POST',
            data: {
                keywordItem: keywordItem
            },
            success: function(data){

                callback(
                    data.result
                )
        
            }

        });

    }

    // Save decision to database
    function save_decision( post_id ){

        var decision_item = {};
        var decision_result = [];
        var output = {};

        $('.decision-tree-container .item').each(function(e){
            
            var question = $(this).find('.title').text();
            var if_yes = $(this).find('.if_yes').val();
            var if_no = $(this).find('.if_no').val();

            decision_item = {
                question: question,
                if_yes: if_yes,
                if_no: if_no
            };

            decision_result.push(decision_item);
    
        });

        output = {
            post_id: post_id,
            decision_result: decision_result
        }

        $.ajax({
            url: 'process/save_decision.php',
            type: 'POST',
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(output),
        });

    }
    
    // Verify for for first step(User Information)
    $('.userInfo .textbox').on('input propertychange paste', function() {
        
        $(".form-group.userInfo .textbox").each(function(){
            
            var inputVal = $(this).val();
            
            if( inputVal !== '' ){
                $('.AccNext').removeClass('enabled');
            }else{
                $('.AccNext').addClass('enabled');
            }
            
        });
          
    });
    
    // Verify for for second step(Account Details)
    $('.accountDetails .textbox').on('input propertychange paste', function() {
        
        var password = $('.textbox.password').val();
        var repassword = $('.textbox.repassword').val();
        var email = $('.textbox.email').val();
        var validation = $('.validation').attr('data-validation');
        
        $(".form-group.accountDetails .textbox").each(function(){
            
            var inputVal = $(this).val();
            var emailField = $('.textbox.email').val();
            
            if( $(this).hasClass('email') === true  ){
                
                if( ValidateEmail(emailField) === true ){
                    
                    // Validation Notice Class
                    $('.validation.emailfield').addClass('valid');
                    $('.validation.emailfield').removeClass('invalid');
                    
                    // Enabled Class
                    $('.AccNext').addClass('enabled');
                    $('.AccNext').addClass('sendData');
                    
                }else{
                    
                    // Validation Notice Class
                    $('.validation.emailfield').addClass('invalid');
                    $('.validation.emailfield').removeClass('valid');
                    
                    // Disable Class
                    $('.AccNext').removeClass('enabled');
                    $('.AccNext').removeClass('sendData');
                }
                
            }else{
                
                if( inputVal !== '' ){
                    
                    $('.AccNext').removeClass('enabled');
                    
                }else{
                    
                    if( password === repassword ){
                        
                        // Enabled Class
                        $('.AccNext').addClass('enabled');
                        $('.AccNext').addClass('sendData');
                        
                        // Validation Notice Class
                        $('.validation.passwordfield').addClass('valid');
                        $('.validation.passwordfield').removeClass('invalid');
                        
                        if( ValidateEmail(emailField) !== true ){
                            // Disable Class
                            $('.AccNext').removeClass('enabled');
                            $('.AccNext').removeClass('sendData');
                        }
                        
                    }else{
                        
                        // Disable Class
                        $('.AccNext').removeClass('enabled');
                        $('.AccNext').removeClass('sendData');
                        
                        // Validation Notice Class
                        $('.validation.passwordfield').addClass('invalid');
                        $('.validation.passwordfield').removeClass('valid');
                        
                    }
                    
                }
            }
            
        });
        
        
          
    });
    
    // Go to next step
    $('body').on('click', '.AccNext.enabled', function() {
        
        $(".form-group.userInfo").hide();
        $(".form-group.accountDetails").show();
        
    });
    
    // Go to previous step
    $('body').on('click', '.AccPrev', function() {
        
        $(".form-group.userInfo").show();
        $(".form-group.accountDetails").hide();
        
    });
    
    // Create Account
    $('body').on('click', '.AccNext.enabled.sendData', function() {
        
        var fname = $('.textbox.fname').val();
        var lname = $('.textbox.lname').val();
        var phone = $('.textbox.phone').val();

        var password = $('.textbox.password').val();
        var repassword = $('.textbox.repassword').val();
        var email = $('.textbox.email').val();
        var validation = $('.validation.emailfield').attr('data-validation');
        
        if( password === repassword ){
            
            // Send Data to Server
            $.ajax({
                url: 'process/create-account.php',
                type: 'POST',
                data: {
                    fname: fname,
                    lname: lname,
                    phone: phone,
                    password: password,
                    repassword: repassword,
                    email: email
                },
                success: function(data){
                    
                    if( data.result === true ){
                        
                        Swal.fire({

                            icon: data.icon,
                            title: data.title,
                            text: data.text,
                            showCancelButton: false,
                            allowOutsideClick: false,
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                            confirmButtonText: 'Login Now'

                        }).then(function(result){

                            if (result.isConfirmed) {
                                // Redirect to Login Page
                                window.location.href = 'login.php';

                            }

                        });

                    }else{

                        Swal.fire({
                            icon: data.icon,
                            title: data.title,
                            text: data.text,
                        })

                    }

                }
            });
            
        }
        
    });

    // Login
    $('body').on('submit', '.login-form', function(e) {
        
        // Prevent the form from submitting
        e.preventDefault();

        var username = $('.login-form .textbox.username').val();
        var password = $('.login-form .textbox.password').val();
        var action = $(this).attr('action');

        // Send Data to Server
        $.ajax({
            url: action,
            type: 'POST',
            data: {
                username: username,
                password: password
            },
            success: function(data){
                    
                if( data.result === true ){
                    
                    var status_code = data.status_code;

                    Swal.fire({
    
                        icon: data.icon,
                        title: data.title,
                        text: data.text,
                        showCancelButton: false,
                        allowOutsideClick: false,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Go to Chat'
    
                    }).then(function(result){
    
                        if (result.isConfirmed) {
                            // Redirect to partner page
                            window.location.href = 'index.php';
                        }
    
                    });
    
                }else{
    
                    Swal.fire({
                        icon: data.icon,
                        title: data.title,
                        text: data.text,
                    })
    
                }
    
            }

        });

    });
    
    // Add Ideas
    $('body').on('submit', '.ideas-form', function(e) {
        
        // Prevent the form from submitting
        e.preventDefault();

        // Register Form Data
        var userID = $('body').data('id');
        var title = $('.title').val();
        var proposal = $('.ideas-form .textarea.proposal').val();
        var workflow = $('.ideas-form .textarea.workflow').val();
        var product_charges = $('.ideas-form .textbox.product_charges').val();
        //var product_keywords = $('.ideas-form .textbox.product_keywords').val();
        var product_keywords = $('.keyword-placeholder').html();

        var product_action = $('.ideas-form .textbox.product_action').val();
        var description = $('.ideas-form .textarea.description').val();
        var data_processing = $('.data_processing').find(":selected").val();

        if( title !== '' && proposal !== '' && workflow !== '' && product_charges !== '' && product_keywords !== '' && product_action !== '' && description !== '' && data_processing !== '' ){

        // Send Data to Server
        $.ajax({
            url: 'process/add-ideas.php',
            type: 'POST',
            data: {
                userID: userID,
                title: title,
                proposal: proposal,
                workflow: workflow,
                product_charges: product_charges,
                //product_keywords: product_keywords,
                product_action: product_action,
                description: description,
                data_processing: data_processing
            },
            success: function(data){
                        
                if( data.result === true ){
                    
                    // Save keywords to form
                    save_keywords(data.post_id);

                    // Save decision to form
                    save_decision(data.post_id);

                    Swal.fire({
                        title: data.title,
                        text: data.text,
                        icon: data.icon,
                        showCancelButton: false,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Done',
                        allowOutsideClick: false
                    }).then((result) => {
                        if (result.isConfirmed) {

                            // Reset Form
                            $('.ideas-form').trigger("reset");

                            // Redirect to dashboard
                            window.location.href = "index.php";

                        }
                    });
        
                }else{

                    Swal.fire({
                        icon: data.icon,
                        title: data.title,
                        text: data.text,
                    });

                }
        
            }

        });

        }else{

            //alert(product_keywords);

            Swal.fire({
                icon: 'error',
                title: 'Empty Fields',
                text: 'One or more fields are empty. Please fill all the fields and try again.',
            });

        }

    });

    // Edit Ideas
    $('body').on('submit', '.edit-ideas-form', function(e) {
        
        // Prevent the form from submitting
        e.preventDefault();

        // Register Form Data
        var post_id = $('body').data('id');
        var title = $('.title').val();
        var proposal = $('.edit-ideas-form .textarea.proposal').val();
        var workflow = $('.edit-ideas-form .textarea.workflow').val();
        var product_charges = $('.edit-ideas-form .textbox.product_charges').val();
        //var product_keywords = $('.edit-ideas-form .textbox.product_keywords').val();
        var product_action = $('.edit-ideas-form .textbox.product_action').val();
        var description = $('.edit-ideas-form .textarea.description').val();
        var data_processing = $('.edit-ideas-form .data_processing').find(":selected").val();

        // Send Data to Server
        $.ajax({
            url: 'process/edit-ideas.php',
            type: 'POST',
            data: {
                post_id: post_id,
                title: title,
                proposal: proposal,
                workflow: workflow,
                product_charges: product_charges,
                //product_keywords: product_keywords,
                product_action: product_action,
                description: description,
                data_processing: data_processing
            },
            success: function(data){
                        
                if( data.result === true ){
        
                    // Reload Page
                    location.reload();
        
                }

                Swal.fire({
                    icon: data.icon,
                    title: data.title,
                    text: data.text,
                });
        
            }

        });

    });

    // Add keywords
    $('.add-keyword').click(function(){

        // Get value from textbox
        var keywords = $('.product_keywords').val();

        // Check Keywords
        check_keywords(keywords, function(response){
            
            if( response == true ){

                Swal.fire({
                    icon: 'success',
                    title: 'Keyword Saved',
                    text: 'Keyword does not exist and has been saved.',
                });

                // Reset keywords
                $('.product_keywords').val('');

                // Add keywords to placeholder
                $('.keyword-placeholder').append('<span class="keywordItem">'+keywords+'</span>');

            }else{

                Swal.fire({
                    icon: 'error',
                    title: 'Keyword already exist',
                    text: 'Opps... The keyword already exist, please try a different one.',
                });

            }

        });

    });

    // Remove keywords
    $('body').on('click', '.keywordItem', function(e) {
        $(this).remove();
    });

    // Add decision tree item
    $('body').on('click', '.controls .add-item', function() {
        
        var itemCounter = 1;

        // Count how many items are in the decision tree
        $('.decision-tree-container .item').each(function() {
            itemCounter++;
        });

        $('.decision-tree-container').append('<div class="item" id="item_'+itemCounter+'" data-item="'+itemCounter+'"><div class="controls"><a href="javascript:;" class="add-item"><ion-icon name="add-circle-outline"></ion-icon></a><a href="javascript:;" class="remove-item"><ion-icon name="remove-circle-outline"></ion-icon></a></div><div class="desc"><h6 class="title" contenteditable="true">Double click to write question</h6></div><div class="desc-form"><div class="col-md-6"><textarea class="txtbx if_yes" placeholder="Enter action If anser is YES"></textarea></div><div class="col-md-6"><textarea class="txtbx if_no" placeholder="Enter action If anser is NO"></textarea></div><div class="clear"></div></div></div>');

    });

    // Remove decision tree item
    $('body').on('click', '.controls .remove-item', function() {
        $(this).parent().parent().remove();
    });

});