<?php
    
    // Start the session
    session_start();

    // Prevent direct access to the page if the user is not logged in or is not a nurse
    if (!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
        header("Location: logout.php");
        die();
    } elseif ($_SESSION['userType'] == 'doctor') {
        header("Location: physician_dashboard.php");
        die();
    } elseif ($_SESSION['userType'] != 'nurse') {
        header("Location: logout.php");
        die();
    }
    
    // Include the functions file
    include('process/functions.php');

    // Check if the session has expired
    checkSessionTimeout();
    
    $vitalFields = array();
    $vitalFields[] = array('fieldName' => 'systolicBP', 'fieldLable' => 'Systolic BP', 'min' => 50, 'max' => 250);
    $vitalFields[] = array('fieldName' => 'diastolicBP', 'fieldLable' => 'Diastolic BP', 'min' => 50, 'max' => 150);
    $vitalFields[] = array('fieldName' => 'heartRate', 'fieldLable' => 'Heart Rate', 'min' => 0, 'max' => 250);
    $vitalFields[] = array('fieldName' => 'respRate', 'fieldLable' => 'Respiratory Rate', 'min' => 0, 'max' => 50);
    $vitalFields[] = array('fieldName' => 'pulseOX', 'fieldLable' => 'Pulse Ox', 'min' => 0, 'max' => 100);
    $vitalFields[] = array('fieldName' => 'temp', 'fieldLable' => 'Temperature', 'min' => 70, 'max' => 110);
    
    $vitals = array();
    $vitals[] = array('fieldName' => 'systolic', 'fieldLable' => 'Systolic BP', 'min' => 90, 'max' => 200);
    $vitals[] = array('fieldName' => 'diastolic', 'fieldLable' => 'Diastolic BP', 'min' => 50, 'max' => 100);
    $vitals[] = array('fieldName' => 'heartrate', 'fieldLable' => 'Heart Rate', 'min' => 50, 'max' => 100);
    $vitals[] = array('fieldName' => 'respiratory', 'fieldLable' => 'Respiratory Rate', 'min' => 10, 'max' => 22);
    $vitals[] = array('fieldName' => 'pulseox', 'fieldLable' => 'Pulse Ox', 'min' => 88, 'max' => 100);
    $vitals[] = array('fieldName' => 'temp', 'fieldLable' => 'Temperature', 'min' => 95, 'max' => 99);
    $vitals[] = array('fieldName' => 'glucose', 'fieldLable' => 'Temperature', 'min' => 90, 'max' => 300);
    
    $labFields = array();
    $labFields[] = array('fieldName' => 'glucose', 'fieldLable' => 'Glucose');
    $labFields[] = array('fieldName' => 'weight', 'fieldLable' => 'Weight');
    
    global $callarray;
    $callarray = array();
    
    function get_user_id($patient_id){
        $sql = "SELECT `all_users`.`userid` FROM `all_users` INNER JOIN `patients` ON `all_users`.`userid` = `patients`.`user_id` WHERE `patients`.`patient_id` = '$patient_id'";
        $result = ddxrxDBConnect()->query($sql);
        $row = $result->fetch_assoc();
        // End connection
        ddxrxDBConnect()->close();

        return $row['userid'];
    }
    
?>
<html>
    <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        
        <meta name="viewport" content="width=device-width, initial-scale=1">
        
        <title>Nurse Dashboard</title>
        
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
	    <link rel="stylesheet" type="text/css" href="assets/css/confirmed-diagnosis.css">


        
        
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        
        <!-- <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({pageLanguage: 'en', 
            layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
            autoDisplay: false, 
            includedLanguages: ''}, 'google_translate_element');}
        </script>
        <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script> -->
        
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
        <script type="text/javascript" src="assets/js/confirmed-diagnosis.js"></script>
        <script type="text/javascript" src="assets/js/phone-call.js"></script>
        <script type="text/javascript" src="assets/js/faq.js"></script>
        <script type="text/javascript" src="assets/js/vitals_history.js"></script>
        
        <?php
        $version = get_version();
        $query = "SELECT * FROM waiting_room where checkin_time >= (NOW() - INTERVAL 7 DAY) AND groupid = '$version' ORDER BY checkin_time DESC";
        $run_query = mysqli_query(ddxrxDBConnect(), $query);
        $numberOfRows = mysqli_num_rows($run_query);
        ?>
        
    </head>
    <body class="patien-data-table dashboard-area" data-total-symptoms="<?php echo $numberOfRows; ?>">
        
        <audio id="new_patient" src="assets/audio/notification.ogg" autoplay="false" ></audio>
        
        <!-- <div id="google_translate_element"></div> -->
        
        <!-- Popup: Vitals -->
        <div class="popup-container">
            <div class="popup">
                <h6>Add Vital Information</h6>
                <div class="padded">
                    
                    <input type="hidden" id="hidden_patient_id" value="2">
                    
                    <div class="col-md-6">
                        <label>
                            <span>Systolic BP</span>
                            <input type="text" class="textbox" id="systolicBP" placeholder="">
                        </label>
                    </div>
                    
                    <div class="col-md-6">
                        <label>
                            <span>Diastolic BP</span>
                            <input type="text" class="textbox" id="diastolicBP" placeholder="">
                        </label>
                    </div>
                    
                    <div class="clear"></div>
                    <div class="spacer-30"></div>
                    
                    <div class="col-md-6">
                        <label>
                            <span>Heart Rate</span>
                            <input type="text" class="textbox" id="heartRate" placeholder="">
                        </label>
                    </div>
                    
                    <div class="col-md-6">
                        <label>
                            <span>Respiratory Rate</span>
                            <input type="text" class="textbox" id="respRate" placeholder="">
                        </label>
                    </div>
                    
                    <div class="clear"></div>
                    <div class="spacer-30"></div>
                    
                    <div class="col-md-6">
                        <label>
                            <span>Pulse OX</span>
                            <input type="text" class="textbox" id="pulseOX" placeholder="">
                        </label>
                    </div>
                    
                    <div class="col-md-6">
                        <label>
                            <span>Temperature</span>
                            <input type="text" class="textbox" id="temp" placeholder="">
                        </label>
                    </div>
                    
                    <div class="clear"></div>
                    <div class="spacer-30"></div>
                    
                    <div class="col-md-6">
                        <label>
                            <span>Glucose</span>
                            <input type="text" class="textbox" id="glucose" placeholder="">
                        </label>
                    </div>
                    
                    <div class="col-md-6">
                        <label>
                            <span>Weight</span>
                            <input type="text" class="textbox" id="weight" placeholder="">
                        </label>
                    </div>
                    
                    <div class="clear"></div>
                    <div class="spacer-50"></div>
                    
                    <div class="col-md-12">
                        <a href="javascript:;" class="button blue add_vitals">Add Vitals</a>
                        <a href="javascript:;" class="button red cancel">Cancel</a>
                        <div class="clear"></div>
                    </div>
                    
                    <div class="clear"></div>
                    <div class="spacer-30"></div>
                    
                </div>
            </div>
        </div>
        <!-- Popup: Vitals -->
        
        <!-- Header -->
        <div class="header">
            
            <div class="container">
                <div class="col-md-12">
                    <div class="patient-info">
                        <h3 class="tabtitle">Diagnosis Dashboard</h3>
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
            
            <div class="menu-container">
                <div class="container">
                    <div class="col-md-12">
                    <ul class="dashboard-nav fix">
                        <li><a href="nurse_default.php">Home</a></li>
                        <li class="current"><a href="dashboard.php">Diagnosis</a></li>
                        <li><a href="dictation-notes.php">Dictation Notes</a></li>
                        <li><a href="vitals_dashboard.php">RPM</a></li>
                        <li><a href="ccm_dashboard.php">CCM</a></li>
                        <div class="clear"></div>
                    </ul>
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
            
        </div>
        <!-- Header -->

        <div class="container">
            <div class="col-md-12">
                <div class="row">
                
                <!-- Button Group -->
                <div class="button-group">
                    <h6>Diagnosis Filter</h6>
                    <div class="button-wrapper">
                        <a href="javascript:;" class="filterBtn active" data-filter="confirmed">Confirmed</a>
                        <a href="javascript:;" class="filterBtn" data-filter="waiting">Awaiting</a>
                        <a href="javascript:;" class="filterBtn" data-filter="all">All</a>
                    </div>
                    
                    <div class="clear"></div>
                </div>
                <!-- Button Group -->
                
                <div id="patientContainer" class="dashboard-data">
                    <div class="thead">
                        <div class="tr">
                            <div class="td patient_info">Patient Name</div>
                            <div class="td patient_symptoms">Diagnosis</div>
                            <div class="td patient_assign">Assign To</div>
                            <div class="td patient_status">Status</div>
                            <div class="td patient_acuity">Acuity</div>
                            <div class="td patient_vitals">Vitals</div>
                            <div class="td patient_waitTime">Wait time</div>
                            <div class="td patient_action">Action</div>
                            <div class="clear"></div>
                        </div>
                    </div>

                    <div class="tbody" id="patientContainer-body">
                        <!-- Patient data will be loaded via AJAX -->
                    </div>
                        </div>

            </div>
            </div>
        </div>

        <div class="spacer-80"></div>

        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
        <script type="text/javascript">
        $(function () {
            $("#patientContainer-body .patient").each(function(){
                // console.log(Date.now());
                // console.log(new Date($(this).find("#checkInTime").val()));
                // console.log(new Date($(this).find("#checkInTime").val()).getTime());
                var totalSeconds = (Date.now() - new Date($(this).find("#checkInTime").val()).getTime())/1000;
                var hours = Math.floor(totalSeconds / 3600);
                totalSeconds = totalSeconds - hours * 3600;
                var minutes = Math.floor(totalSeconds / 60);
                $(this).find("#hrs").val(hours);
                $(this).find("#mins").val(minutes);
                $(this).find(".wait_time h3 b").html(hours+":"+minutes);
            });
            setInterval(function() {
                $("#patientContainer-body .patient").each(function(){
                    var mins = parseInt($(this).find("#mins").val());
                    var hours = parseInt($(this).find("#hrs").val());
                    if(mins < 59) {
                        mins += 1;
                        $(this).find("#mins").val(mins);
                        $(this).find(".wait_time h3 b").html(hours+":"+mins);
                    } else {
                        hours += 1;
                        mins = 0;
                        $(this).find("#hrs").val(hours);
                        $(this).find("#mins").val(mins);
                        $(this).find(".wait_time h3 b").html(hours+":"+mins);
                    }
                });
            }, 60000);
            
            
            
            $('body').on('change', '.physician-dropdown', function() {
            //$(".physician-dropdown").change(function(){
                var physician_id = $(this).val();
                var waitingroom_id = $(this).attr("for");
                console.log(waitingroom_id);
                $.ajax({
                    url: 'save_search_entry.php',
                    data: {'physicianUpdate': true, 'waitingroom_id': waitingroom_id, 'physician_id': physician_id},
                    type: 'POST',
                    dataType: 'json',
                    success: function success(msg) {
                        alert('Physician assigned');
                    },
                    error: function error(msg) {
                        console.log('error');
                    },
                });
            });
            
            
            $('body').on('click', '.addVitals', function() {
            //$(".addVitals").click(function(){
				var text = $.trim($(this).html());
                var guid = $(this).attr("represents");
                $("#guidInVitalForm").val(guid);
				var waitingroom_id = $("#"+guid).find("#waitingEntryID").val();
				if(text=="View") {
					$.ajax({
						url:"save_search_entry.php",
						type: 'POST',
						dataType: 'json',
						data: {wID: waitingroom_id, vitalFetch: true},
						success:function(data) {
							var vitalParse = JSON.parse(data.data);
                            var vitalFields = <?php echo json_encode($vitalFields); ?>;
							$.each(vitalParse, function(i, val) {
								$("#"+i).val(val);
								
							});
							
                            var currentAcuity = $("#"+guid).find("#acuityValue").val();
                            var isSEPSIS = $("#"+guid).find("#isSEPSIS").val();
                            var totalScore = 0;
                            if(isSEPSIS == 1) {
                                totalScore = 3;
                            }
                            var value;
                            var intValue;
                            var waitingroom_id = $("#"+guid).find("#waitingEntryID").val();
                            var vitalScore = 0;
                            vitalFields.forEach(function(item, index){
                                value = $("#"+item.fieldName).val();
                                if(value != "") {
                                    intValue = parseInt(value);
                                    if((item.min != 0 && intValue < item.min) || (item.max != 0 && intValue > item.max)) {
                                        vitalScore++;
                                    }
                                }
                            });
                            totalScore += vitalScore;
				            sepsisSirsLogic(guid, totalScore, isSEPSIS, vitalScore);
						}, 
						error: function error(msg) {
							console.log('error');
						},
					});
				} else {
					$('#vitals').find('input[type=text]').val('');
				}
            });
            
            
            $('body').on('click', '#calculateAcuity', function() {
                var guid = $("#guidInVitalForm").val();
                var currentAcuity = $("#"+guid).find("#acuityValue").val();
                var isSEPSIS = $("#"+guid).find("#isSEPSIS").val();
                var totalScore = 0;
                if(isSEPSIS == 1) {
                    totalScore = 3;
                }
                var vitalFields = <?php echo json_encode($vitalFields); ?>;
                var value;
                var intValue;
                var waitingroom_id = $("#"+guid).find("#waitingEntryID").val();
				var jsonVital = new Object();
                var vitalScore = 0;
                vitalFields.forEach(function(item, index){
                    value = $("#"+item.fieldName).val();
					jsonVital[item.fieldName] = value;
                    if(value != "") {
                        intValue = parseInt(value);
                        if((item.min != 0 && intValue < item.min) || (item.max != 0 && intValue > item.max)) {
                            vitalScore++;
                        }
                    }
                });
                totalScore += vitalScore;
				$.ajax({
					url:"save_search_entry.php",
					type: 'POST',
					dataType: 'json',
					data: {
					    'vitalUpdate': true,
					    'data': jsonVital,
					    'waitingroom_id': waitingroom_id,
					    'acuity': totalScore,
					    'vitalScore': vitalScore
					},
					success:function(data) {
						//$("#"+guid).find(".patient_vitals .addVitals").html("View");
					}, 
					error: function error(msg) {
						console.log('error');
					},
				});
				sepsisSirsLogic(guid, totalScore, isSEPSIS, vitalScore);
            });

        });

        function sepsisSirsLogic(guid, totalScore, isSEPSIS, vitalScore) {
                
            $("#"+guid).find(".acuityText").html(totalScore+"/10");
            var content = $("#"+guid).find("#chiefComplaint").html();
            if(totalScore >= 4) {
                $("#"+guid).find(".inOutText").html("Inpatient");
                $("#"+guid).find(".inOutText").parent().removeClass("text-success");
                $("#"+guid).find(".inOutText").parent().addClass("text-danger");
                $("#"+guid).find(".acuityText").parent().removeClass("text-success");
                $("#"+guid).find(".acuityText").parent().addClass("text-danger");
                if(isSEPSIS == 1 && totalScore > 4) {
                    if(content.indexOf(" (SEPSIS)") < 0) {
                        content += " (SEPSIS)";
                        $("#"+guid).find("#chiefComplaint").html(content);
                    }
                } else {
                    if(content.indexOf(" (SEPSIS)") > 0) {
                        content = content.replace(" (SEPSIS)","");
                        $("#"+guid).find("#chiefComplaint").html(content);
                    }
                    if(vitalScore >= 2 && content.indexOf(" (SIRS)") < 0) {
                        content += " (SIRS)";
                        $("#"+guid).find("#chiefComplaint").html(content);
                    } else if (vitalScore < 2) {
                        content = content.replace(" (SIRS)","");
                        $("#"+guid).find("#chiefComplaint").html(content);
                    }
                }
            } else {
                if(content.indexOf(" (SEPSIS)") > 0) {
                    content = content.replace(" (SEPSIS)","");
                    $("#"+guid).find("#chiefComplaint").html(content);
                }
                if(vitalScore >= 2 && content.indexOf(" (SIRS)") < 0) {
                    content += " (SIRS)";
                    $("#"+guid).find("#chiefComplaint").html(content);
                } else if (vitalScore < 2) {
                    content = content.replace(" (SIRS)","");
                    $("#"+guid).find("#chiefComplaint").html(content);
                }
                if(totalScore < 3) {
                    $("#"+guid).find(".inOutText").html("Outpatient");
                } else {
                    $("#"+guid).find(".inOutText").html("Undecided");
                }
                $("#"+guid).find(".inOutText").parent().addClass("text-success");
                $("#"+guid).find(".inOutText").parent().removeClass("text-danger");
                $("#"+guid).find(".acuityText").parent().addClass("text-success");
                $("#"+guid).find(".acuityText").parent().removeClass("text-danger");
            }
        }
        </script>
        <script type="text/javascript" src="assets/js/jquery.fancybox.min.js"></script>
        
        <!-- Send Vitals to history table -->
        <script type="text/javascript">
            
            $('body').on('click', '.addVitals', function() {
                var patient_id = $(this).data('patient-id');
                $('#hidden_patient_id').val( patient_id );
            });
            
        
            $('body').on('click', '#calculateAcuity', function() {
                
                var patient_id = $('#hidden_patient_id').val();
                var systolicBP = $('#systolicBP').val();
                var diastolicBP = $('#diastolicBP').val();
                var heartRate = $('#heartRate').val();
                var respRate = $('#respRate').val();
                var pulseOX = $('#pulseOX').val();
                var temp = $('#temp').val();
                var glucose = $('#glucose').val();
                var weight = $('#weight').val();
                
                $.ajax({
        			type: 'POST',
        			url: 'process/save_vital_history.php',
        
        			data: {
        				patient_id:patient_id,
        				systolicBP:systolicBP,
        				diastolicBP:diastolicBP,
        				heartRate:heartRate,
        				respRate:respRate,
        				pulseOX:pulseOX,
        				temp:temp,
        				glucose:glucose,
        				weight:weight
        			},
        
        			beforeSend: function() {
        					
        			},
        			success: function(response) {
                            
                        Swal.fire({
                            icon: 'success',
                            //title: 'Data Saved',
                            text: "The vitals data have been saved",
                        });
                            
                            
        			},	
        			fail: function(response){
        				// Do Something
        			}
        
        		});
                 
            });
        </script>
        <!-- Send Vitals to history table -->
        
        <?php provider_bottom_nav(); ?>
        
    </body>
</html>