<?php

    // Include the functions file
    require_once('process/functions.php');

    // Set connection variable
    $con = ddxrxDBConnect();

    // Detect if the user is logged in
    if (!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
        header("Location: logout.php");
        die();
    }

    // Template for error handling
    $no_symptioms_error = '
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="results-error-container">
                        
                        <div class="results-error">
                            <div class="inner">
                                <span class="material-symbols-outlined icon"> error </span>
                                <h3>No Symptoms Provided</h3>
                                <p class="error">No symptoms were provided. Please go back and enter at least two symptoms.</p>
                                <p><a href="javascript:history.back()" class="back-button">Back</a></p>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    ';

    $minimum_symptoms_error = '
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="results-error-container">

                        <div class="results-error">
                            <div class="inner">
                                <span class="material-symbols-outlined icon"> error </span>
                                <h3>Minimum Symptoms Required</h3>
                                <p class="error">You must enter at least two symptoms to get a diagnosis. Please go back and enter more symptoms.</p>
                                <p><a href="javascript:history.back()" class="back-button">Back</a></p>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    ';

    // Check if symptoms are set and are an array
    $symptomList = array();
    if (isset($_POST['symptoms']) && is_array($_POST['symptoms'])) {
        // Filter out empty symptoms (trim for safety)
        foreach ($_POST['symptoms'] as $symptom) {
            if (trim($symptom) !== '') {
                $symptomList[] = $symptom;
            }
        }
    }

    // Get differential diagnoses based on symptoms
    $differential_diagnoses = array();
    if (count($symptomList) >= 2) {
        // Get symptom IDs from database
        $escaped_symptoms = array();
        foreach ($symptomList as $symptom) {
            $escaped_symptoms[] = "'" . mysqli_real_escape_string($con, $symptom) . "'";
        }
        $symptom_names = implode(", ", $escaped_symptoms);
        
        $symptom_query = "SELECT id, name FROM symptoms WHERE name IN ($symptom_names) AND deleted != '1'";
        $symptom_result = mysqli_query($con, $symptom_query);
        
        $symptom_ids = array();
        while ($row = mysqli_fetch_assoc($symptom_result)) {
            $symptom_ids[] = $row['id'];
        }
        
        if (count($symptom_ids) > 0) {
            // Get differential diagnoses with JOIN
            $ids_string = implode(', ', $symptom_ids);
            $diagnosis_query = "SELECT COUNT(`sdd`.`differential_diagnose_id`) as `match_count`, 
                                       `sdd`.`differential_diagnose_id`, 
                                       `sdd`.`sequence_id`, 
                                       `dd`.`name`, 
                                       `dd`.`details` 
                                FROM `symptoms_differential_diagnoses` `sdd` 
                                JOIN `differential_diagnoses` `dd` ON `sdd`.`differential_diagnose_id` = `dd`.`id` 
                                WHERE `sdd`.`symptom_id` IN ($ids_string) 
                                AND `sdd`.`deleted` != '1' 
                                AND `dd`.`deleted` != '1' 
                                GROUP BY `sdd`.`differential_diagnose_id` 
                                ORDER BY COUNT(`sdd`.`differential_diagnose_id`) DESC, `sdd`.`sequence_id` LIMIT 20";
            
            $diagnosis_result = mysqli_query($con, $diagnosis_query);
            while ($row = mysqli_fetch_assoc($diagnosis_result)) {
                $differential_diagnoses[] = $row;
            }
        }
    }

    

?>

<!DOCTYPE html>
<html>
<head>
    <title>Differential Diagnosis Results</title>
    
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200">
    <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link rel="stylesheet" type="text/css" href="assets/css/diagnosis-results.css">
    
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    
    <!-- Pass session data to JavaScript -->
    <script type="text/javascript">
        // User session data for JavaScript access
        window.userSession = {
            userType: '<?php echo isset($_SESSION['userType']) ? $_SESSION['userType'] : ''; ?>',
            userId: '<?php echo isset($_SESSION['userid']) ? $_SESSION['userid'] : ''; ?>',
            waitingRoomId: null // Will be set from localStorage
        };
        
        // Function to get waiting room ID from localStorage
        function getWaitingRoomId() {
            var patientData = localStorage.getItem('patient');
            if (patientData) {
                var patient = JSON.parse(patientData);
                return patient.waitingroom_id || 0;
            }
            return 0;
        }
        
        // Function to get the correct redirect URL based on user type
        function getResultsUrl() {
            const waitingRoomId = getWaitingRoomId();
            const userId = window.userSession.userId;
            const userType = window.userSession.userType;
            
            if (!waitingRoomId || waitingRoomId == 0) {
                console.error('No waiting room ID found');
                return 'dashboard.php'; // Fallback
            }
            
            // Check if user is provider (nurse or physician/doctor)
            if (userType === 'nurse' || userType === 'physician' || userType === 'doctor') {
                return `encounter-notes.php?waiting_room_id=${waitingRoomId}`;
            } else if (userType === 'patient') {
                return `preview-new-note-changes.php?waiting_room_id=${waitingRoomId}&uid=${userId}`;
            } else {
                // Fallback for unknown user types
                console.warn('Unknown user type:', userType);
                return 'dashboard.php';
            }
        }
    </script>
    
    <script type="text/javascript" src="assets/js/diagnosis-results.js"></script>
        
</head>
<body>

    <div class="loading-screen">
        <div class="loading-content">
            <div class="loading-spinner"></div>
            <h3>Processing Diagnosis...</h3>
            <p>Please wait while we evaluate your answers.</p>
        </div>
    </div>

    <?php

        if (count($symptomList) < 1) {
            // No data at all, show no symptoms error
            echo $no_symptioms_error;
        } elseif (count($symptomList) < 2) {
            // Less than 2 symptoms, show less than 2 symptoms error
            echo $minimum_symptoms_error;
        } else {

    ?>

    <div class="container">
        <div class="row">

            <div class="col-12">
                <div class="result-header">
                    <h1>Differential Diagnosis Results</h1>
                </div>
            </div>

        </div>
    </div>

    <div class="search-container">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    
                    <div class="search-bar-container">
                        <form id="search-form" action="diagnosis-results.php" method="POST">
                            <input type="text" id="search-input" name="search" placeholder="Search for a symptom..." autocomplete="off">
                            <ul class="search-result-placeholder"></ul>
                            <?php
                            // Iterate through this variable to display the symptoms
                            foreach ($symptomList as $i => $symptom) {
                                echo '<input type="hidden" name="symptoms[' . $i . ']" value="' . htmlspecialchars($symptom) . '">';
                            }
                            ?>
                            <input type="submit" class="search-button" value="Re-do Search">
                        </form>
                        <div class="symptom-list">
                            <h6>Selected Symptoms</h6>
                            <div>
                                <?php
                                // Display the symptoms in a list
                                foreach ($symptomList as $symptom) {
                                    echo '<a href="#" data-item="' . htmlspecialchars($symptom) . '"><span>' . htmlspecialchars($symptom) . '</span><span class="material-symbols-outlined icon"> cancel </span></a>';
                                }
                                ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    
    <div class="container">
        <div class="row">

            <div class="col-12">
                <div class="result-content">

                    <?php 
                    // Check if any symptoms contain "follow-up" or "follow up"
                    $is_followup_visit = false;
                    $followup_symptoms = array();
                    
                    foreach ($symptomList as $symptom) {
                        if (stripos($symptom, 'follow-up') !== false || stripos($symptom, 'follow up') !== false) {
                            $is_followup_visit = true;
                            $followup_symptoms[] = $symptom;
                        }
                    }
                    
                    // If this is a follow-up visit, only show follow-up related diagnoses
                    if ($is_followup_visit) {
                        echo '<div class="follow-up-notice">';
                        echo '<h3>Follow-up Visit Detected</h3>';
                        echo '<p>Based on your symptoms (' . implode(', ', $followup_symptoms) . '), showing follow-up related diagnoses only.</p>';
                        echo '</div>';
                        
                        // Filter diagnoses to only show follow-up related ones
                        $filtered_diagnoses = array();
                        foreach ($differential_diagnoses as $diagnosis) {
                            if (stripos($diagnosis['name'], 'follow-up') !== false || 
                                stripos($diagnosis['name'], 'follow up') !== false) {
                                $filtered_diagnoses[] = $diagnosis;
                            }
                        }
                        $differential_diagnoses = $filtered_diagnoses;
                    }
                    
                    if (count($differential_diagnoses) > 0) {
                        foreach ($differential_diagnoses as $index => $diagnosis) {
                            // Get questions for this diagnosis from dd_questions table
                            $questions_query = "SELECT `id`, `questions`, `yes`, `no`, `serial` 
                                               FROM `dd_questions` 
                                               WHERE `differential_diagnose_id` = " . intval($diagnosis['differential_diagnose_id']) . " 
                                               ORDER BY `serial` LIMIT 10";
                            
                            $questions_result = mysqli_query($con, $questions_query);
                            $questions = array();
                            while ($q_row = mysqli_fetch_assoc($questions_result)) {
                                $questions[] = $q_row;
                            }
                            
                            // Check if this diagnosis has questions
                            $has_questions = count($questions) > 0;
                            
                            // Hide all diagnoses except the first one
                            $hidden_class = ($index > 0) ? ' hidden-diagnosis' : '';
                    ?>

                    <div class="diagnosed-item<?php echo $hidden_class; ?>" data-has-questions="<?php echo $has_questions ? 'true' : 'false'; ?>">
                        <form method="post" action="process/diagnosis-question-result.php">
                            <h2 class="title"><?php echo htmlspecialchars($diagnosis['name']); ?></h2>
                            <p class="text"><?php echo htmlspecialchars($diagnosis['details']); ?></p>

                            <div class="questions">
                                <?php 
                                if (count($questions) == 0) {
                                ?>
                                    <div class="no-questions-notice">
                                        <div class="notice-box">
                                            <span class="material-symbols-outlined">info</span>
                                            <p>This diagnosis does not have questions available at the moment.</p>
                                        </div>
                                    </div>
                                <?php 
                                } else {
                                    foreach ($questions as $question) {
                                    // Extract question title and description from the questions field
                                    $question_text = $question['questions'];
                                    $question_parts = explode(' (', $question_text, 2);
                                    $question_title = html_entity_decode($question_parts[0], ENT_QUOTES, 'UTF-8');
                                    $question_desc = isset($question_parts[1]) ? html_entity_decode('(' . $question_parts[1], ENT_QUOTES, 'UTF-8') : '';
                                    
                                    // Check if this symptom/question is already selected by user
                                    $is_selected = false;
                                    foreach ($symptomList as $symptom) {
                                        if (stripos($question_title, $symptom) !== false || stripos($symptom, $question_title) !== false) {
                                            $is_selected = true;
                                            break;
                                        }
                                    }
                                    
                                    $data_yes = $question['yes'] . "_y";
                                    $data_no = $question['no'] . "_n";
                                    $form_id = $question['id']; // Use the actual question ID from dd_questions
                                ?>
                                <div class="item" data-yes="<?php echo $data_yes; ?>" data-no="<?php echo $data_no; ?>">
                                    <div class="checkbox-container">
                                        <span class="checkbox-toggle">
                                            <span class="material-symbols-outlined icon <?php echo $is_selected ? 'added' : 'add'; ?>"><?php echo $is_selected ? 'check_box' : 'check_box_outline_blank'; ?></span>
                                        </span>
                                        <div class="checkbox-label">
                                            <h6><?php echo htmlspecialchars($question_title, ENT_QUOTES, 'UTF-8'); ?></h6>
                                            <p><?php echo htmlspecialchars($question_desc, ENT_QUOTES, 'UTF-8'); ?></p>
                                            <?php if (!$is_selected) { ?>
                                                <a href="#" class="add_symptom"><span class="material-symbols-outlined">add_circle</span> Add Symptom</a>
                                            <?php }else{ ?>
                                                <a href="#" class="add_symptom already-added"><span class="material-symbols-outlined">check_circle</span> Already Added</a>
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <input type="hidden" id="form_<?php echo $form_id; ?>" name="<?php echo $form_id; ?>" value="<?php echo $is_selected ? $data_yes : $data_no; ?>">
                                </div>
                                <?php 
                                } 
                                }
                                ?>

                            </div>
                            <input type="hidden" name="diagnosis_id" value="<?php echo $diagnosis['differential_diagnose_id']; ?>">
                            
                            <div class="form-actions">
                                <?php if ($has_questions): ?>
                                    <input type="submit" value="Submit Answers" class="submit-button">
                                    <button type="button" id="reset-questions" class="reset-button">Reset Questions</button>
                                <?php else: ?>
                                    <button type="button" id="skip-diagnosis" class="skip-button">Skip to Next Diagnosis</button>
                                <?php endif; ?>
                            </div>
                        </form>
                    </div>
                    
                    <?php 
                        }
                    } else {
                    ?>
                    <div class="diagnosed-item">
                        <h2 class="title">No Matching Diagnoses</h2>
                        <p class="text">No differential diagnoses were found matching the provided symptoms. Please try different symptoms or consult with a healthcare professional.</p>
                    </div>
                    <?php } ?>
                    
                </div>
            </div>

        </div>
    </div>

    <?php } ?>

    <?php

        if( $_SESSION['userType'] == 'doctor' ) {
            physician_bottom_nav();
        }elseif( $_SESSION['userType'] == 'nurse' ) {
            provider_bottom_nav();
        }elseif( $_SESSION['userType'] == 'patient' ) {
            bottom_nav();
        }

    ?>

</body>
</html>