<?php

// Start the session
session_start();

// Check if the user is logged in
if (!isset($_SESSION['userid'])) {
    // Redirect to the login page if not logged in
    include('chat-bot-landing.php');
    exit();
}

// User is logged in as nurse then redirect to nurse_default.php
if ($_SESSION['user_type'] == 'nurse') {
    header('Location: nurse_default.php');
    exit();
}

// User is logged in as doctor then redirect to physician_default.php
if ($_SESSION['user_type'] == 'doctor') {
    header('Location: physician_default.php');
    exit();
}

// User is logged in as a patient then redirect to default.php
if ($_SESSION['user_type'] == 'patient') {
    header('Location: default.php');
    exit();
}