<?php

    session_start();

    if ( !isset( $_SESSION['userType'] ) ) {
        header("Location: login.php");
        die();
    }

    if( $_SESSION['userType'] != 'doctor' && $_SESSION['userType'] != 'nurse' ) {
        header("Location: login.php");
        die();
    }
    
    // Include the functions file
    include('process/functions.php');

    // Check if the session has expired
    checkSessionTimeout();

?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>Manage Device</title>
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
    <link rel="stylesheet" type="text/css" href="assets/css/manage-devices.css">
	
	<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script type="text/javascript" src="assets/js/manage-devices.js"></script>
	
</head>
<body class="rpm-dashboard" style="padding-bottom: 70px;" data-patient-id="<?php echo isset($_GET['patient_id']) ? $_GET['patient_id'] : ''; ?>">
    
    <!-- Header -->
    <div class="header">
        
        <div class="container">
            <div class="padded">
                <div class="patient-info">
                    <?php
                        $patient_id = isset($_GET['patient_id']) ? $_GET['patient_id'] : '';
                        $current_version = get_version();
                        $access_denied = false;
                        
                        if($patient_id) {
                            // Security: Verify patient belongs to current version/subdomain using JOIN
                            $sql = "SELECT p.patient_id, p.patient_fname, p.patient_lname, p.groupid, v.version_id 
                                    FROM patients p 
                                    INNER JOIN version v ON p.groupid = v.version_id 
                                    WHERE p.patient_id = '$patient_id' AND p.groupid = '$current_version' 
                                    LIMIT 1";
                            $result = mysqli_query(ddxrxDBConnect(), $sql);
                            $patient = mysqli_fetch_assoc($result);
                            
                            // Check if patient exists and belongs to this version
                            if($patient && $patient['groupid'] == $current_version) {
                                $patient_name = $patient['patient_fname'] . ' ' . $patient['patient_lname'];
                                $patient_display_id = $patient['patient_id'];
                            } else {
                                // Patient doesn't belong to this version - ACCESS DENIED
                                $access_denied = true;
                                $patient_name = 'Access Denied';
                                $patient_display_id = '';
                            }
                        } else {
                            $patient_name = 'Unknown Patient';
                            $patient_display_id = '';
                        }
                    ?>
                    <div>
                        <h3 class="tabtitle">Manage Devices</h3>
                        <h6><?php echo htmlspecialchars($patient_name, ENT_QUOTES, 'UTF-8'); ?><?php if($patient_display_id) echo ' - ' . $patient_display_id; ?></h6>
                    </div>

                    <div>
                        <a href="rpm-device-management.php" class="back-button">← Back to Patient List</a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="menu-container">
            <div class="container">
                <?php
                    if( $_SESSION['user_type'] == 'nurse' ){
                        include('nurse_dashboard_nav.php');
                    }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
                        include('physician_dashboard_nav.php');
                    }
                ?>
            </div>
        </div>
        
    </div>
    <!-- Header -->
    
    <!-- Body -->
    <div class="container">
        <div class="device-management-container">
            
            <?php
                $patient_id = isset($_GET['patient_id']) ? $_GET['patient_id'] : '';
                
                if(!$patient_id) {
                    echo '<div class="error-message">No patient selected. Please select a patient from the device management page.</div>';
                } elseif($access_denied) {
                    echo '<div class="error-message" style="background-color: #f8d7da; border-color: #f5c6cb; color: #721c24;">
                            <strong>Access Denied!</strong><br>
                            This patient does not belong to your clinic/organization. You can only manage devices for patients in your own system.
                          </div>';
                } else {
                    
                    // Get all devices for this patient
                    $devices = array(
                        array('type' => 'anyhub', 'label' => 'AnyHub (Cellular Hub)', 'id_field' => 'Serial Number', 'device_type' => 'anyhub'),
                        array('type' => 'bp', 'label' => 'Blood Pressure Cuff', 'id_field' => 'IMEI Number', 'device_type' => null),
                        array('type' => 'weight', 'label' => 'Weighing Scale', 'id_field' => 'IMEI Number', 'device_type' => null)
                    );
                    
                    foreach($devices as $device) {
                        
                        $type = $device['type'];
                        $label = $device['label'];
                        $id_field = $device['id_field'];
                        
                        // Query for device using JOIN to get device and patient info together
                        if($type == 'anyhub') {
                            $sql = "SELECT c.cardiowellid, c.patient_id, c.imei, c.device_id, c.type, c.status, c.device_type 
                                    FROM cardiowell_users c 
                                    WHERE c.patient_id = '$patient_id' AND c.device_type = 'anyhub' 
                                    LIMIT 1";
                        } else {
                            $sql = "SELECT c.cardiowellid, c.patient_id, c.imei, c.device_id, c.type, c.status, c.device_type 
                                    FROM cardiowell_users c 
                                    WHERE c.patient_id = '$patient_id' AND c.type = '$type' 
                                    LIMIT 1";
                        }
                        
                        $result = mysqli_query(ddxrxDBConnect(), $sql);
                        $row = mysqli_fetch_assoc($result);
                        
                        $has_device = !empty($row['imei']);
                        $imei = $has_device ? $row['imei'] : 'Not Connected';
                        $status = $has_device ? 'Connected' : 'Not Connected';
                        $status_class = $has_device ? 'connected' : 'disconnected';
                        
                        // Check for pending status
                        if($has_device && isset($row['status']) && $row['status'] == 'pending') {
                            $status = 'Pending Removal';
                            $status_class = 'pending';
                        }
                        
                        echo '
                        <div class="device-item" data-device-type="'.$type.'">
                            <div class="device-info">
                                <div class="device-header">
                                    <h4 class="device-name">'.$label.'</h4>
                                    <span class="device-status '.$status_class.'">'.$status.'</span>
                                </div>
                                <div class="device-details">
                                    <p><strong>'.$id_field.':</strong> <span class="device-imei">'.$imei.'</span></p>
                                </div>
                            </div>
                            <div class="device-actions">';
                        
                        if($has_device) {
                            if($status_class == 'pending') {
                                echo '<button class="btn-action btn-disabled" disabled>Pending Removal</button>';
                            } else {
                                echo '<button class="btn-action btn-remove" data-imei="'.$row['imei'].'" data-device-type="'.$type.'">Remove Device</button>';
                            }
                        } else {
                            echo '<button class="btn-action btn-add" data-device-type="'.$type.'">Add Device</button>';
                        }
                        
                        echo '
                            </div>
                        </div>';
                    }
                    
                    mysqli_close(ddxrxDBConnect());
                }
            ?>
            
        </div>
    </div>
    <!-- Body -->
    
    <?php
                
    	if( $_SESSION['userType'] == 'nurse' ){
                        
    		provider_bottom_nav();
                        
    	}elseif( $_SESSION['userType'] == 'doctor' ){
                        
    		physician_bottom_nav();
                        
    	}else{
                        
    		bottom_nav();
                        
    	}

    ?>
    
</body>
</html>