<?php 
session_start();
if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    header("Location: index.php");
    die();
}
if($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor') {
    header("Location: view_record.php");
    die();
}

// Include the necessary files
include('process/functions.php');

// Check if the session has expired
checkSessionTimeout();

?>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>Add New Patient - DDxRx</title>

        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/emr_list.css">
        <link rel="stylesheet" type="text/css" href="assets/css/new-patient.css">
	
        <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript" src="assets/js/new-patient.js"></script>
        
    </head>
    <body>
        
    <div class="header">
        <div class="container">
            <div class="col-md-12">
                <div class="patient-info aligned-both-sides">
                    <div class="item">
                        <h3 class="tabtitle">Add New Patient</h3>
                    </div>
                    <div class="item">
                        <a href="new_records.php" class="button">Back to List</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

        <div class="container">
            <div class="col-md-12">
                
                <div class="new-patient-container">
                    
                    <form id="new_patient_form" method="POST">
                        
                        <!-- Login Details Section -->
                        <div class="form-section">
                            <h4>Login Details</h4>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="username">Username <span class="required">*</span></label>
                                    <input type="text" name="username" id="username" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="password">Password <span class="required">*</span></label>
                                    <input type="password" name="password" id="password" required>
                                    <span class="help-text">Minimum 6 characters</span>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Patient Details Section -->
                        <div class="form-section">
                            <h4>Patient Details</h4>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="patient_fname">First Name <span class="required">*</span></label>
                                    <input type="text" name="patient_fname" id="patient_fname" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="patient_lname">Last Name <span class="required">*</span></label>
                                    <input type="text" name="patient_lname" id="patient_lname" required>
                                </div>
                            </div>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="patient_email">Email (Optional)</label>
                                    <p>If email is not provided, it will use clinic email by default.</p>
                                    <input type="email" name="patient_email" id="patient_email" placeholder="Ex: patient@email.com">
                                </div>
                                
                                <div class="form-group">
                                    <label for="mobile_phone">Mobile Number (Optional)</label>
                                    <p>If phone number is not provided, it will use clinic phone number by default.</p>
                                    <div class="phone-input-group">
                                        <select name="country_code" id="country_code" class="country-code-select">
                                            <option value="+1">+1 (US/CA)</option>
                                            <option value="+44">+44 (UK)</option>
                                            <option value="+61">+61 (AU)</option>
                                            <option value="+81">+81 (JP)</option>
                                            <option value="+86">+86 (CN)</option>
                                            <option value="+91">+91 (IN)</option>
                                            <option value="+63">+63 (PH)</option>
                                            <option value="+82">+82 (KR)</option>
                                            <option value="+49">+49 (DE)</option>
                                            <option value="+33">+33 (FR)</option>
                                            <option value="+39">+39 (IT)</option>
                                            <option value="+34">+34 (ES)</option>
                                            <option value="+7">+7 (RU)</option>
                                            <option value="+55">+55 (BR)</option>
                                            <option value="+52">+52 (MX)</option>
                                            <option value="+27">+27 (ZA)</option>
                                            <option value="+20">+20 (EG)</option>
                                            <option value="+971">+971 (AE)</option>
                                            <option value="+65">+65 (SG)</option>
                                            <option value="+60">+60 (MY)</option>
                                        </select>
                                        <input type="tel" name="mobile_phone" id="mobile_phone" placeholder="Ex: 5551234567" class="phone-number-input">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="patient_dob">Date of Birth <span class="required">*</span></label>
                                    <input type="date" name="patient_dob" id="patient_dob" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="patient_gender">Gender <span class="required">*</span></label>
                                    <select name="patient_gender" id="patient_gender" required>
                                        <option value="">--Select--</option>
                                        <option value="m">Male</option>
                                        <option value="f">Female</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="patient_location">Patient Location <span class="required">*</span></label>
                                    <select name="patient_location" id="patient_location" required>
                                        <option value="1" selected>Hospital & Clinic</option>
                                        <option value="0">Home</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Button Group -->
                        <div class="button-group">
                            <a href="new_records.php" class="btn-cancel">Cancel</a>
                            <button type="submit" class="btn-submit">Add Patient</button>
                        </div>
                        
                    </form>
                    
                </div>
                
            </div>
        </div>

        <?php
                
            if( $_SESSION['userType'] == 'nurse' ){
                    
                provider_bottom_nav();
                    
            }elseif( $_SESSION['userType'] == 'doctor' ){
                    
                physician_bottom_nav();
                    
            }else{
                    
                bottom_nav();
                    
            }
        ?>
        
    </body>
</html>
