<?php
ob_start();
error_reporting(0);
session_start();

// Mobile Detect
require_once("mobile_detect.php");
$detect = new Mobile_Detect;

if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    header("Location: ios-launch.php");
    die();
}

include('includes/database_include.php');
include('process/functions.php');

?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

	<title>Patient Messenger</title>

	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
	<link rel="stylesheet" type="text/css" href="assets/css/grid.css">
	<link rel="stylesheet" type="text/css" href="assets/css/chat-icon/flaticon.css">
	<link rel="stylesheet" type="text/css" href="assets/css/patient-chat.css">
	<link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
	<link rel="stylesheet" type="text/css" href="assets/css/faq.css">
	
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script type="text/javascript" src="assets/js/jquery.tap.js"></script>
	<script type="text/javascript" src="assets/js/faq.js"></script>
	<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
	<script type="text/javascript" src="assets/js/phone-call.js"></script>
    
    <?php if ( $detect->isMobile() ) { ?>
	    <script type="text/javascript" src="assets/js/patient_chat_mobile.js"></script>
	<?php }else{ ?>
	    <script type="text/javascript" src="assets/js/patient_chat.js"></script>
	<?php } ?>
    
    <script type="text/javascript">
    function googleTranslateElementInit() {
        new google.translate.TranslateElement({pageLanguage: 'en', 
        layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
        autoDisplay: false, 
        includedLanguages: ''}, 'google_translate_element');}
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    
</head>
<body class="patient-chat">
    
	<div class="patient-chat-container">
	    
	    <div id="google_translate_element"></div>
	    
	    <?php top_nav(); ?>
	    
	    <div class="message-list-container" data-patient-id="<?php echo $_SESSION['userid']; ?>" >
    	    <ul class="message-list">
    	        <!--
    	        <li>
    	            <div class="avatar"><i class="flaticon-user"></i></div>
    	            <div class="desc">
    	                <strong>Jonathan</strong>
    	                <p>returns the height of element excludes padding, border and margin.</p>
    	            </div>
    	            <span class="datetime">Dec 28, 2019</span>
    	        </li>
    	        -->
    	    </ul>
	    </div>
	    
	    <!-- Controls -->
	    <div class="chat-controls">
	        <!--
	        <div class="chat-options">
	            <a href="javascript:;"><i class="flaticon-camera-1"></i></a>
	            <a href="javascript:;"><i class="flaticon-video-camera"></i></a>
	            <a href="javascript:;"><i class="flaticon-paper-clip"></i></a>
	        </div>
	        -->
	        <textarea id="input_message" name="input_message"></textarea>
	        <a href="javascript:;" id="send-message" class="send-message">Send</a>
	        <a href="javascript:;" class="msg-close-button" onclick="history.back();">Close</a>
	        <!--<a href="javascript:;" class="close-message">Close</a>-->
	    </div>
	    <!-- Controls -->
	    
	    <script>
	    
            var input_message = document.getElementById("input_message");
            input_message.addEventListener("keyup", function(event) {
                
                // Update by THS:: April 14,2021
                if (event.keyCode === 13 && (event.shiftKey == false && event.ctrlKey==false && event.altKey==false)) {
                    event.preventDefault();
                    document.getElementById("send-message").click();
                }
                
            });
        </script>
	    
	</div>

</body>
</html>