<?php
/**
 * PointClickCare Integration Index
 * 
 * This page provides easy access to all PCC integration features
 */

// Load configuration
require_once(dirname(__FILE__) . '/pcc-config.php');
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PCC Integration - DDxRx</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            max-width: 800px;
            width: 100%;
            overflow: hidden;
        }
        .header {
            background: #2c3e50;
            color: white;
            padding: 40px;
            text-align: center;
        }
        .header h1 {
            font-size: 32px;
            margin-bottom: 10px;
        }
        .header p {
            font-size: 16px;
            opacity: 0.9;
        }
        .content {
            padding: 40px;
        }
        .section {
            margin-bottom: 30px;
        }
        .section h2 {
            font-size: 20px;
            color: #2c3e50;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #ecf0f1;
        }
        .links {
            display: grid;
            gap: 15px;
        }
        .link-card {
            display: flex;
            align-items: center;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 8px;
            text-decoration: none;
            color: #2c3e50;
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }
        .link-card:hover {
            background: #e9ecef;
            border-color: #667eea;
            transform: translateX(5px);
        }
        .link-card .icon {
            font-size: 32px;
            margin-right: 20px;
            width: 50px;
            text-align: center;
        }
        .link-card .info h3 {
            font-size: 18px;
            margin-bottom: 5px;
        }
        .link-card .info p {
            font-size: 14px;
            color: #7f8c8d;
        }
        .status {
            display: flex;
            gap: 15px;
            margin-top: 20px;
            flex-wrap: wrap;
        }
        .status-item {
            flex: 1;
            min-width: 200px;
            padding: 15px;
            background: #ecf0f1;
            border-radius: 5px;
            text-align: center;
        }
        .status-item .label {
            font-size: 12px;
            color: #7f8c8d;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 5px;
        }
        .status-item .value {
            font-size: 18px;
            font-weight: bold;
            color: #2c3e50;
        }
        .status-item.success .value {
            color: #27ae60;
        }
        .status-item.warning .value {
            color: #f39c12;
        }
        .footer {
            background: #ecf0f1;
            padding: 20px 40px;
            text-align: center;
            color: #7f8c8d;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔗 PointClickCare Integration</h1>
            <p>DDxRx OAuth SSO Integration</p>
        </div>

        <div class="content">
            <!-- Quick Start -->
            <div class="section">
                <h2>Quick Start</h2>
                <div class="links">
                    <a href="oauth-initiate.php" class="link-card">
                        <div class="icon">🚀</div>
                        <div class="info">
                            <h3>Start OAuth Flow</h3>
                            <p>Initiate the OAuth authentication process</p>
                        </div>
                    </a>
                    
                    <a href="test.php" class="link-card">
                        <div class="icon">🧪</div>
                        <div class="info">
                            <h3>Test Suite</h3>
                            <p>Run integration tests and diagnostics</p>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Documentation -->
            <div class="section">
                <h2>Documentation</h2>
                <div class="links">
                    <a href="README.md" class="link-card" target="_blank">
                        <div class="icon">📖</div>
                        <div class="info">
                            <h3>Integration Guide</h3>
                            <p>Complete setup and usage documentation</p>
                        </div>
                    </a>
                    
                    <a href="../documentation/pcc/getting-started/index.html" class="link-card" target="_blank">
                        <div class="icon">📚</div>
                        <div class="info">
                            <h3>PCC Getting Started</h3>
                            <p>PointClickCare platform documentation</p>
                        </div>
                    </a>
                    
                    <a href="../documentation/pcc/api-reference/index.html" class="link-card" target="_blank">
                        <div class="icon">🔧</div>
                        <div class="info">
                            <h3>PCC API Reference</h3>
                            <p>API endpoints and integration details</p>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Configuration Status -->
            <div class="section">
                <h2>Configuration Status</h2>
                <div class="status">
                    <div class="status-item success">
                        <div class="label">Environment</div>
                        <div class="value"><?php echo strtoupper(PCC_ENVIRONMENT); ?></div>
                    </div>
                    
                    <div class="status-item <?php echo PCC_ENABLE_LOGGING ? 'success' : 'warning'; ?>">
                        <div class="label">Logging</div>
                        <div class="value"><?php echo PCC_ENABLE_LOGGING ? 'ENABLED' : 'DISABLED'; ?></div>
                    </div>
                    
                    <div class="status-item <?php echo PCC_ENABLE_CSRF ? 'success' : 'warning'; ?>">
                        <div class="label">CSRF Protection</div>
                        <div class="value"><?php echo PCC_ENABLE_CSRF ? 'ENABLED' : 'DISABLED'; ?></div>
                    </div>
                    
                    <div class="status-item success">
                        <div class="label">Database</div>
                        <div class="value"><?php echo PCC_DB_NAME; ?></div>
                    </div>
                </div>
            </div>

            <!-- Sandbox Credentials -->
            <div class="section">
                <h2>Sandbox Testing</h2>
                <div class="link-card" style="cursor: default;">
                    <div class="icon">🔑</div>
                    <div class="info">
                        <h3>Test Credentials</h3>
                        <p><strong>Username:</strong> <?php echo PCC_SANDBOX_USERNAME; ?></p>
                        <p><strong>Password:</strong> <?php echo PCC_SANDBOX_PASSWORD; ?></p>
                        <p><strong>Org Code:</strong> <?php echo PCC_SANDBOX_ORG_CODE; ?></p>
                        <p style="margin-top: 10px;">
                            <a href="<?php echo PCC_LOGIN_URL; ?>" target="_blank" style="color: #667eea;">
                                Open PCC Login →
                            </a>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Development Tools -->
            <div class="section">
                <h2>Development Tools</h2>
                <div class="links">
                    <?php if (file_exists(PCC_LOG_FILE)): ?>
                    <a href="logs/pcc-integration.log" class="link-card" target="_blank">
                        <div class="icon">📝</div>
                        <div class="info">
                            <h3>View Logs</h3>
                            <p>Check integration logs for debugging</p>
                        </div>
                    </a>
                    <?php endif; ?>
                    
                    <a href="database-migration.sql" class="link-card" target="_blank">
                        <div class="icon">💾</div>
                        <div class="info">
                            <h3>Database Migration</h3>
                            <p>SQL script to add PCC support to database</p>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <div class="footer">
            <p>PointClickCare Integration v1.0.0 | DDxRx Platform</p>
            <p style="margin-top: 5px;">Last Updated: November 1, 2025</p>
        </div>
    </div>
</body>
</html>
