<?php
/**
 * PointClickCare OAuth Initiation
 * 
 * This file initiates the OAuth flow by redirecting users to PCC's
 * authorization endpoint.
 * 
 * Usage: Link users to this page from PCC marketplace or as an entry point
 * 
 * PHP 5.6/8.1 Compatible
 */

// Load configuration
require_once(dirname(__FILE__) . '/pcc-config.php');
require_once(dirname(__FILE__) . '/includes/pcc-helper.php');

pcc_log('=== PCC OAuth Initiation Started ===', 'INFO');

// ========================================
// Generate State Parameter (CSRF Protection)
// ========================================

$state = pcc_generate_state();

pcc_log('Generated OAuth state: ' . $state, 'DEBUG');

// ========================================
// Build Authorization URL
// ========================================

$auth_params = array(
    'response_type' => 'code',
    'client_id' => PCC_CUSTOMER_KEY,
    'redirect_uri' => PCC_OAUTH_CALLBACK_URL,
    'state' => $state,
    'scope' => 'openid', // OpenID Connect scope for getting user identity
);

$authorization_url = PCC_AUTHORIZE_URL . '?' . http_build_query($auth_params);

pcc_log('Redirecting to PCC authorization URL', 'INFO');
pcc_log('Authorization URL: ' . $authorization_url, 'DEBUG');

// ========================================
// Redirect to PCC Authorization
// ========================================

header('Location: ' . $authorization_url);
exit;

?>
