<?php

// Set output to JSON
header('Content-Type: application/json');

// Start session
session_start();

// Check if user is logged in and is a provider (nurse or doctor)
if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    echo json_encode(array(
        'success' => false,
        'message' => 'Unauthorized access. Please login.'
    ));
    exit();
}

if($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor') {
    echo json_encode(array(
        'success' => false,
        'message' => 'Access denied. Only providers can add patients.'
    ));
    exit();
}

// Include functions file
include('../process/functions.php');

// Show errors for debugging (remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Function to check if username exists
function username_exists( $username ){

    // Database connection
    $conn = ddxrxDBConnect();

    // Escape username to prevent SQL injection
    $username = mysqli_real_escape_string($conn, $username);

    // SQL Query
    $sql = "SELECT * FROM `all_users` WHERE `username` = '$username'";

    // Check if username exists
    $query = mysqli_query($conn, $sql);

    // Close connection
    mysqli_close($conn);

    // If username exists
    if(mysqli_num_rows($query) > 0) {
        return true;
    } else {
        return false;
    }

}

// Function to check if email exists in patients table
function email_exists( $email ){

    // Database connection
    $conn = ddxrxDBConnect();

    // Escape the email to prevent SQL injection
    $email = mysqli_real_escape_string($conn, $email);

    // SQL Query - check both email_id and billing_email
    $sql = "SELECT * FROM `patients` WHERE `email_id` = '$email' OR `billing_email` = '$email'";

    // Check if email exists
    $query = mysqli_query($conn, $sql);

    // Close connection
    mysqli_close($conn);

    // If email exists
    if(mysqli_num_rows($query) > 0) {
        return true;
    } else {
        return false;
    }

}

// Function to check if phone exists in patients table
function phone_exists( $phone ){

    // Database connection
    $conn = ddxrxDBConnect();

    // Escape the phone to prevent SQL injection
    $phone = mysqli_real_escape_string($conn, $phone);

    // SQL Query
    $sql = "SELECT * FROM `patients` WHERE `cell` = '$phone'";

    // Check if phone exists
    $query = mysqli_query($conn, $sql);

    // Close connection
    mysqli_close($conn);

    // If phone exists
    if(mysqli_num_rows($query) > 0) {
        return true;
    } else {
        return false;
    }

}

if( $_SERVER['REQUEST_METHOD'] == "POST" || isset($_POST) ) {

    // Database connection
    $conn = ddxrxDBConnect();

    $version = get_version();
    $username = isset($_POST['username']) ? mysqli_real_escape_string($conn, $_POST['username']) : '';
    $password_raw = isset($_POST['password']) ? $_POST['password'] : '';
    $password = mysqli_real_escape_string($conn, $password_raw);
    $password_hash = password_hash($password, PASSWORD_BCRYPT);

    $user_type = '3'; // 3 = Patient
    $location_id = '1';
    $is_active = '1';
    $created_at = date('Y-m-d H:i:s');
    $forget_key = 'none';
    $exp_date = date('Y-m-d H:i:s', strtotime('+1 day'));
    $oauth_provider = 'none';
    $oauth_uid = 'none';

    $patient_fname = isset($_POST['patient_fname']) ? mysqli_real_escape_string($conn, $_POST['patient_fname']) : '';
    $patient_lname = isset($_POST['patient_lname']) ? mysqli_real_escape_string($conn, $_POST['patient_lname']) : '';
    
    // Handle email - if not provided, use default email from version settings
    $patient_email_input = isset($_POST['patient_email']) ? trim($_POST['patient_email']) : '';
    if(empty($patient_email_input)) {
        $patient_email = get_version('email');
    } else {
        $patient_email = mysqli_real_escape_string($conn, $patient_email_input);
    }
    
    $patient_dob = isset($_POST['patient_dob']) ? mysqli_real_escape_string($conn, $_POST['patient_dob']) : '';
    $patient_gender = isset($_POST['patient_gender']) ? mysqli_real_escape_string($conn, $_POST['patient_gender']) : '';
    
    // Handle mobile phone with country code (already combined in frontend)
    // If not provided, use default phone from version settings
    $mobile_phone_input = isset($_POST['mobile_phone']) ? trim($_POST['mobile_phone']) : '';
    if(empty($mobile_phone_input)) {
        $mobile_phone = get_version('phone');
    } else {
        $mobile_phone = mysqli_real_escape_string($conn, $mobile_phone_input);
    }
    
    $patient_location = isset($_POST['patient_location']) ? mysqli_real_escape_string($conn, $_POST['patient_location']) : '';
    $patient_active = '1';
    
    // Generate epic_id
    $epic_id = md5(uniqid(mt_rand(), true));
    
    // Default values for required fields
    $occupation = 'Not Specified';
    $billing_company = '';
    $billing_name = $patient_fname . ' ' . $patient_lname;
    $billing_country = 'USA';
    $mrn_hospital = 'Not Specified';
    $encounter_id = 'Not Specified';

    // Validate required fields - check the raw password before hashing
    if(empty($username) || empty($password_raw) || empty($patient_fname) || empty($patient_lname) || 
       empty($patient_dob) || empty($patient_gender) || $patient_location === '') {
        
        $output = array(
            'success' => false,
            'message' => 'Please fill in all required fields'
        );
        echo json_encode($output);
        exit;
    }

    // Check if username already exists
    if( username_exists( $username ) == true ){
        
        $output = array(
            'success' => false,
            'message' => 'Username already exists'
        );
        echo json_encode($output);
        exit;
    }
    
    // Check if email exists (only if user provided a custom email, not default)
    // Skip check if using default clinic email since multiple patients can share it
    $default_email = get_version('email');
    if( !empty($patient_email_input) && email_exists( $patient_email ) == true ){
        
        $output = array(
            'success' => false,
            'message' => 'Email address already exists'
        );
        echo json_encode($output);
        exit;
    }
    
    // Check if phone exists (only if user provided a custom phone, not default)
    // Skip check if using default clinic phone since multiple patients can share it
    $default_phone = get_version('phone');
    if( !empty($mobile_phone_input) && phone_exists( $mobile_phone ) == true ){
        
        $output = array(
            'success' => false,
            'message' => 'Phone number already exists'
        );
        echo json_encode($output);
        exit;
    }

    // All validations passed - proceed with insertion
    
    // Generate unique id for user
    $unique_id = provider_unique();
    
    // Use patient email if provided, otherwise use empty string for email_address
    $user_email = !empty($patient_email) ? $patient_email : '';

    // Insert into all_users table - include email_address which is required
    $sql_all_users = "INSERT INTO `all_users` (`groupid`, `username`, `password_new`, `email_address`, `user_type`, `location_id`, `is_active`, `created_at`, `forgot_key`, `forgot_exp_date`, `oauth_provider`, `oauth_uid`, `unique_id`) VALUES ('$version', '$username', '$password_hash', '$user_email', '$user_type', '$location_id', '$is_active', '$created_at', '$forget_key', '$exp_date', '$oauth_provider', '$oauth_uid', '$unique_id')";

    // Insert into all_users table
    $insert_users = mysqli_query($conn, $sql_all_users);

    // Get last inserted id
    $last_id = mysqli_insert_id($conn);

    // Check if insert was successful
    if( $insert_users ){

        // Insert into patients table
        // Note: email_id and cell are optional, use empty string if not provided
        // billing_email is required, so use patient_email or empty string
        $billing_email_value = !empty($patient_email) ? $patient_email : '';
        
        $sql_patient = "INSERT INTO `patients` (`user_id`, `groupid`, `location_id`, `patient_fname`, `patient_lname`, `patient_dob`, `patient_gender`, `epic_id`, `active`, `cell`, `email_id`, `occupation`, `billing_company`, `billing_name`, `billing_country`, `billing_email`, `mrn_hospital`, `encounter_id`, `location`) VALUES ('$last_id', '$version', '$location_id', '$patient_fname', '$patient_lname', '$patient_dob', '$patient_gender', '$epic_id', '$patient_active', '$mobile_phone', '$patient_email', '$occupation', '$billing_company', '$billing_name', '$billing_country', '$billing_email_value', '$mrn_hospital', '$encounter_id', '$patient_location')";

        // Insert into patients table
        $insert_patient = mysqli_query($conn, $sql_patient);

        // Check if insert was successful
        if( $insert_patient ){

            // Close connection
            mysqli_close($conn);

            // Return success
            $output = array(
                'success' => true,
                'message' => 'Patient added successfully!'
            );

        } else {

            // Log the error for debugging
            $error_message = mysqli_error($conn);
            error_log('Patient insertion failed: ' . $error_message);
            error_log('SQL Query: ' . $sql_patient);

            // Close connection
            mysqli_close($conn);

            // Return error with details
            $output = array(
                'success' => false,
                'message' => 'Failed to add patient: ' . $error_message
            );

        }

    } else {

        // Log the error for debugging
        $error_message = mysqli_error($conn);
        error_log('User insertion failed: ' . $error_message);
        error_log('SQL Query: ' . $sql_all_users);

        // Close connection
        mysqli_close($conn);

        // Return error with details
        $output = array(
            'success' => false,
            'message' => 'Failed to create user account: ' . $error_message
        );

    }

}else{

    // Return error
    $output = array(
        'success' => false,
        'message' => 'Invalid request method'
    );

}

echo json_encode($output);

?>
