<?php

// Start session
session_start();

// Set content type to JSON
header('Content-Type: application/json');

// Include necessary files
include('../process/functions.php');

// Create database connection
$con = ddxrxDBConnect();

// Check if user is logged in and has the correct user type
if(!isset($_SESSION['userType'])) {
    $output = array(
        'status' => false,
        'title' => 'error',
        'message' => 'User not logged in or invalid user type.'
    );
    echo json_encode($output);
    exit();
}

// Get the patientID, userID, and symptomName from the request
if(isset($_POST['patient_id']) && isset($_POST['user_id']) && isset($_POST['symptom_name'])) {
    $patient_id = $_POST['patient_id'];
    $user_id = $_POST['user_id'];
    $symptom_name = $_POST['symptom_name'];
} else {
    $output = array(
        'status' => false,
        'title' => 'error',
        'message' => 'Required parameters not provided.'
    );
    echo json_encode($output);
    exit();
}

// Check for duplicate diagnosis for this patient
$check_query = "SELECT COUNT(*) FROM `medical` WHERE `patient_id` = ? AND `diagnosis` = ?";
$check_stmt = $con->prepare($check_query);
$check_stmt->bind_param("is", $patient_id, $symptom_name);
$check_stmt->execute();
$check_stmt->bind_result($count);
$check_stmt->fetch();
$check_stmt->close();

if($count > 0) {
    $output = array(
        'status' => false,
        'title' => 'error',
        'message' => 'This diagnosis already exists for this patient.'
    );
} else {
    // Prepare and execute the SQL statement to insert patient history
    $query = "INSERT INTO `medical` (`patient_id`, `diagnosis`, `status`) VALUES (?, ?, 'approved')";
    $stmt = $con->prepare($query);
    $stmt->bind_param("is", $patient_id, $symptom_name);
    if($stmt->execute()) {

        // Get the last inserted ID
        $inserted_id = $stmt->insert_id;

        $output = array(
            'status' => true,
            'title' => 'success',
            'message' => 'Patient history added successfully.',
            'history_id' => $inserted_id,
        );

    } else {
        $output = array(
            'status' => false,
            'title' => 'error',
            'message' => 'Failed to add patient history: ' . $stmt->error
        );
    }
    
    // Close the insert statement
    $stmt->close();
}

// Close the database connection
$con->close();

// Return the output as JSON
echo json_encode($output);
exit();
