<?php

// Set output to JSON
header('Content-Type: application/json');

// Include functions file
include('../process/functions.php');

// Check if email parameter is provided
if(isset($_POST['email'])) {
    
    $email = trim($_POST['email']);
    
    // If email is empty, return false (allow blank values)
    if(empty($email)) {
        echo json_encode(array('exists' => false));
        exit;
    }
    
    // Database connection
    $conn = ddxrxDBConnect();
    
    // Escape email to prevent SQL injection
    $email = mysqli_real_escape_string($conn, $email);
    
    // SQL Query - check both email_id and billing_email
    $sql = "SELECT * FROM `patients` WHERE `email_id` = '$email' OR `billing_email` = '$email'";
    
    // Execute query
    $query = mysqli_query($conn, $sql);
    
    // Close connection
    mysqli_close($conn);
    
    // Check if email exists
    if(mysqli_num_rows($query) > 0) {
        echo json_encode(array('exists' => true));
    } else {
        echo json_encode(array('exists' => false));
    }
    
} else {
    echo json_encode(array('error' => 'Email parameter is missing'));
}

?>
