<?php

// Set output to JSON
header('Content-Type: application/json');

// Include functions file
include('../process/functions.php');

// Check if phone parameter is provided
if(isset($_POST['phone'])) {
    
    $phone = trim($_POST['phone']);
    
    // If phone is empty, return false (allow blank values)
    if(empty($phone)) {
        echo json_encode(array('exists' => false));
        exit;
    }
    
    // Database connection
    $conn = ddxrxDBConnect();
    
    // Escape phone to prevent SQL injection
    $phone = mysqli_real_escape_string($conn, $phone);
    
    // SQL Query
    $sql = "SELECT * FROM `patients` WHERE `cell` = '$phone'";
    
    // Execute query
    $query = mysqli_query($conn, $sql);
    
    // Close connection
    mysqli_close($conn);
    
    // Check if phone exists
    if(mysqli_num_rows($query) > 0) {
        echo json_encode(array('exists' => true));
    } else {
        echo json_encode(array('exists' => false));
    }
    
} else {
    echo json_encode(array('error' => 'Phone parameter is missing'));
}

?>
