<?php
    
    header('Content-type: application/json');
    
    include('functions.php');
    
    function sendOTPRequest( $phoneNumber = null ){
    
        if( isset($phoneNumber) ){
            
            // API URL
            $url = 'https://waitingroom.ai/api/verification';
            
            // Create a new cURL resource
            $ch = curl_init($url);
            
            // Setup request to send json via POST
            $data = array(
                'number' => $phoneNumber
            );
            $payload = json_encode($data);
            
            // Attach encoded JSON string to the POST fields
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            
            // Set the content type to application/json
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            
            // Return response instead of outputting
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            
            // Execute the POST request
            $result = curl_exec($ch);
            
            // Close cURL resource
            curl_close($ch);
            
            //$result = json_decode($result);
            
            return $result;
            
        }
        
    }
    
    if( isset($_POST['mobile_number']) ){
        
        $mobile_number = $_POST['mobile_number'];
        
            
        // this code is used for check if enter email is exist or not
        // $sel_query = "select * from all_users WHERE userid = (SELECT user_id FROM `patients` WHERE cell = '$mobile_number')";
        // $results = mysqli_query(ddxrxDBConnect(), $sel_query );
        // $row = mysqli_fetch_assoc($results);
        
        $sql_sel = "select * from all_users WHERE userid = (SELECT user_id FROM patients WHERE cell = '$mobile_number')";
        $result = mysqli_query(ddxrxDBConnect(), $sql_sel);
        $row = mysqli_fetch_assoc($result);
         
        if ( !isset($row['userid']) ){
            
            $result_arr = array(
                'result' => false,
                'error_desc' => 'Phone number is not registered in our database'
            );
            
        }else{
            
            $otp = json_decode( sendOTPRequest( $mobile_number ) );
            $expFormat = mktime(date("H"), date("i"), date("s"), date("m") ,date("d")+1, date("Y"));
            $expDate = date("Y-m-d H:i:s",$expFormat);
            $key = md5($otp->otp_number.$mobile_number);
            $redirect_link = 'https://'.$_SERVER['SERVER_NAME'].'/reset_password.php?key='.$key.'&email='.$row['email_address'].'&action=reset';
                
            //update forgot key
            $user_email = $row['email_address'];
            $sql = "UPDATE all_users SET forgot_key='$key', forgot_exp_date='$expDate' WHERE email_address='$user_email'";
            
            mysqli_query(ddxrxDBConnect(), $sql);
            
            
            $result_arr = array(
                'result' => true,
                'redirect_url' => $redirect_link,
                'otp_number' => $otp->otp_number,
            );
            
        }

    }
    
    mysqli_free_result($result);
    mysqli_close(ddxrxDBConnect());
    
    echo json_encode($result_arr);
    
?>