<?php

// Start the session
session_start();

// Set the content type to JSON
header('Content-Type: application/json');

// Include necessary files
include('../process/functions.php');

// Create database connection
$con = ddxrxDBConnect();

// Check if user is logged in and has the correct user type
if(!isset($_SESSION['userType'])) {
    $output = array(
        'status' => false,
        'title' => 'error',
        'message' => 'User not logged in or invalid user type.'
    );
    echo json_encode($output);
    exit();
}

// Get the patient ID from the request
if(isset($_POST['patient_id'])) {
    $patient_id = $_POST['patient_id'];
} else {
    $output = array(
        'status' => false,
        'title' => 'error',
        'message' => 'Patient ID not provided.'
    );
    echo json_encode($output);
    exit();
}

// Fetch patient history from the database
$query = "SELECT * FROM `medical` WHERE patient_id = ? AND `status` = 'approved' ORDER BY `id` DESC";
$stmt = $con->prepare($query);
$stmt->bind_param("i", $patient_id);
$stmt->execute();
$result = $stmt->get_result();

// Check if any records were found
if($result->num_rows > 0) {
    $history = array();
    while($row = $result->fetch_assoc()) {
        $history[] = array(
            'id' => $row['id'],
            'patient_id' => $row['patient_id'],
            'diagnosis' => $row['diagnosis'],
            'status' => $row['status']
        );
    }
    $output = array(
        'status' => true,
        'title' => 'success',
        'history' => $history
    );
} else {
    $output = array(
        'status' => false,
        'title' => 'error',
        'message' => 'No history found for this patient.'
    );
}

// Close the database connection
$stmt->close();
$con->close();

// Return the output as JSON
echo json_encode($output);
exit();
