<?php

/*
HTTP Status Codes:
200 - Everything is OK
201 - Created Successfully
202 - Accepted
204 - No Content
301 - Moved Permanently
400 - Bad Request
401 - Unauthorized
403 - Duplicate Entry
404 - Not Found
500 - Internal Server Error
*/

// Set Content to json
header('Content-Type: application/json');

// Start session
session_start();

// Include functions
include('functions.php');

// Check if user is authorized (doctor or nurse only)
if (!isset($_SESSION['userType']) || ($_SESSION['userType'] != 'doctor' && $_SESSION['userType'] != 'nurse')) {
    $result = array(
        'status_code' => '401',
        'status_description' => 'Unauthorized - Insufficient permissions'
    );
    echo json_encode($result);
    exit();
}

// Validate required parameters
if( isset($_POST['patient_id']) && isset($_POST['device_type']) && isset($_POST['imei_number']) ){
    
    $patient_id = $_POST['patient_id'];
    $device_type = $_POST['device_type'];
    $imei_number = $_POST['imei_number'];
    $currentUrl = $_SERVER['HTTP_HOST'];
    
    // Validate IMEI number is not empty
    if(empty($imei_number)) {
        $result = array(
            'status_code' => '400',
            'status_description' => 'Bad Request - IMEI number cannot be empty'
        );
        echo json_encode($result);
        exit();
    }
    
    // Check if IMEI is already registered to another patient
    if( imei_duplicate($imei_number) == true ){
        
        // Determine if this is an anyhub device
        if( $device_type == 'anyhub' ){
            $sql = "INSERT INTO `cardiowell_users` (`patient_id`, `imei`, `type`, `device_type`, `status`) VALUES ('$patient_id', '$imei_number', '$device_type', 'anyhub', 'running')";
        } else {
            $sql = "INSERT INTO `cardiowell_users` (`patient_id`, `imei`, `type`, `status`) VALUES ('$patient_id', '$imei_number', '$device_type', 'running')";
        }
        
        if (ddxrxDBConnect()->query($sql) === TRUE) {
            
            $result = array(
                'status_code' => '200',
                'status_description' => 'Device added successfully'
            );
            
            // Call Python API to inform what URL is being sent
            $url = 'https://ddxrx.ai/domain';
            $data = array(
                'imei' => $imei_number,
                "domain" => $currentUrl,
            );
            
            $postdata = json_encode($data);
            
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
            $results = curl_exec($ch);
            curl_close($ch);
            
        } else {
            
            $result = array(
                'status_code' => '400',
                'status_description' => 'Bad Request - Failed to insert device record',
                'error' => mysqli_error(ddxrxDBConnect())
            );
            
        }
        
        ddxrxDBConnect()->close();
        
    } else {
        
        // IMEI is already registered to another patient - use JOIN to get patient name
        $sql = "SELECT c.patient_id, p.patient_fname, p.patient_lname 
                FROM cardiowell_users c 
                INNER JOIN patients p ON c.patient_id = p.patient_id 
                WHERE c.imei = '$imei_number' 
                LIMIT 1";
        $result_check = mysqli_query(ddxrxDBConnect(), $sql);
        $row_check = mysqli_fetch_assoc($result_check);
        
        $patient_name = $row_check['patient_fname'] . ' ' . $row_check['patient_lname'];
        
        $result = array(
            'status_code' => '403',
            'status_description' => 'Duplicate entry - IMEI number already exists in the database',
            'patient_fullname' => $patient_name
        );
        
        ddxrxDBConnect()->close();
        
    }
    
} else {
    
    $result = array(
        'status_code' => '204',
        'status_description' => 'No content - Missing required parameters'
    );
    
}

echo json_encode($result);

?>
