<?php

/*
HTTP Status Codes:
200 - Everything is OK
201 - Created Successfully
202 - Accepted
204 - No Content
301 - Moved Permanently
400 - Bad Request
401 - Unauthorized
404 - Not Found
500 - Internal Server Error
*/

// Set Content to json
header('Content-Type: application/json');

// Start session
session_start();

// Include functions
include('functions.php');

// Check if user is authorized (doctor or nurse only)
if (!isset($_SESSION['userType']) || ($_SESSION['userType'] != 'doctor' && $_SESSION['userType'] != 'nurse')) {
    $result = array(
        'status_code' => '401',
        'status_description' => 'Unauthorized - Insufficient permissions'
    );
    echo json_encode($result);
    exit();
}

// Validate required parameters
if( isset($_POST['patient_id']) && isset($_POST['device_type']) && isset($_POST['imei_number']) ){
    
    $patient_id = $_POST['patient_id'];
    $device_type = $_POST['device_type'];
    $imei_number = $_POST['imei_number'];
    
    // Build the SQL query based on device type
    if( $device_type == 'anyhub' ){
        $sql = "DELETE FROM cardiowell_users WHERE patient_id = '$patient_id' AND imei = '$imei_number' AND device_type = 'anyhub'";
    } else {
        $sql = "DELETE FROM cardiowell_users WHERE patient_id = '$patient_id' AND imei = '$imei_number' AND type = '$device_type'";
    }
    
    if (ddxrxDBConnect()->query($sql) === TRUE) {
        
        $result = array(
            'status_code' => '200',
            'status_description' => 'Device removed successfully'
        );
        
    } else {
        
        $result = array(
            'status_code' => '400',
            'status_description' => 'Bad Request - Failed to remove device',
            'error' => mysqli_error(ddxrxDBConnect())
        );
        
    }

    ddxrxDBConnect()->close();
    
} else {
    
    $result = array(
        'status_code' => '400',
        'status_description' => 'Bad Request - Missing required parameters'
    );
    
}

echo json_encode($result);

?>
