<?php

    session_start();

    if ( !isset( $_SESSION['userType'] ) ) {
        header("Location: login.php");
        die();
    }

    if( $_SESSION['userType'] != 'doctor' && $_SESSION['userType'] != 'nurse' ) {
        header("Location: login.php");
        die();
    }
    
    // Include the functions file
    include('process/functions.php');

    // Check if the session has expired
    checkSessionTimeout();

?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>Patient RPM Device Management</title>
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
    <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
	
	<style>
	    /* Device Status Badge Styling */
	    .device-status-badge {
	        display: inline-block;
	        padding: 6px 12px;
	        border-radius: 4px;
	        font-weight: 600;
	        font-size: 13px;
	        transition: all 0.3s ease;
	    }
	    
	    .device-status-badge.linked {
	        background-color: #d4edda;
	        color: #155724;
	        border: 1px solid #c3e6cb;
	    }
	    
	    .device-status-badge.not-linked {
	        background-color: #f8d7da;
	        color: #721c24;
	        border: 1px solid #f5c6cb;
	    }
	    
	    /* Row coloring based on device status */
	    tr.all-devices-linked {
	        background-color: #f1f9f1 !important;
	    }
	    
	    tr.all-devices-linked:hover {
	        background-color: #e2f4e2 !important;
	    }
	    
	    tr.partial-devices-linked {
	        background-color: #fff9e6 !important;
	    }
	    
	    tr.partial-devices-linked:hover {
	        background-color: #fff3cc !important;
	    }
	    
	    tr.no-devices-linked {
	        background-color: #fff5f5 !important;
	    }
	    
	    tr.no-devices-linked:hover {
	        background-color: #ffe6e6 !important;
	    }
	    
	    /* Table cell styling */
	    .device-cell {
	        text-align: center !important;
	        vertical-align: middle !important;
	    }
	    
	    .patient-name {
	        font-weight: 600;
	        color: #333;
	    }
	    
	    /* Action cell styling */
	    .action-cell {
	        text-align: center !important;
	        vertical-align: middle !important;
	        white-space: nowrap !important;
	        width: 200px !important;
	    }
	    
	    .action-cell .button {
	        width: auto !important;
	        max-width: none !important;
	    }
	    
	    .manage-button {
	        background-color: #007bff !important;
	        color: white !important;
	        padding: 8px 12px !important;
	        border-radius: 4px !important;
	        text-decoration: none !important;
	        display: inline-block !important;
	        transition: background-color 0.3s ease !important;
	        font-weight: 600 !important;
	        font-size: 13px !important;
	        white-space: nowrap !important;
	        width: auto !important;
	        max-width: none !important;
	    }
	    
	    .manage-button:hover {
	        background-color: #0056b3 !important;
	    }
	    
	    .device-count-badge {
	        display: inline-block !important;
	        margin-left: 8px !important;
	        background-color: #28a745;
	        color: white;
	        padding: 5px 10px;
	        border-radius: 12px;
	        font-size: 11px;
	        font-weight: 700;
	        vertical-align: middle;
	        white-space: nowrap !important;
            position: absolute;
	    }
	    
	    /* Table header styling */
	    #myTable thead td {
	        background-color: #343a40;
	        color: white;
	        font-weight: 700;
	        text-align: center;
	        padding: 12px 8px;
	    }
	    
	    /* DataTables pagination styling */
	    .dataTables_wrapper .dataTables_paginate .paginate_button.current {
	        background: #007bff !important;
	        color: white !important;
	        border: 1px solid #007bff !important;
	    }
	    
	    /* Responsive adjustments */
	    @media screen and (max-width: 768px) {
	        .device-status-badge {
	            padding: 4px 8px;
	            font-size: 11px;
	        }
	        
	        .device-count-badge {
	            display: block;
	            margin-top: 5px;
	            margin-left: 0;
	        }
	    }
	</style>
	
	<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/js-cookie@3.0.0/dist/js.cookie.min.js"></script>
	<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script type="text/javascript" src="//cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
	<script type="text/javascript" src="assets/js/vitals_history.js"></script>
	
	<script type="text/javascript">
	    $(document).ready(function(){
	        
	        // Load DataTable JS
            $('#myTable').DataTable({
                "pageLength": 50,
                //"bSort": false,
                "order": []
            });

        });
	</script>
	
</head>
<body class="rpm-dashboard" style="padding-bottom: 70px;">
    
    <!-- Header -->
    <div class="header">
        
        <div class="container">
            <div class="padded">
                <div class="patient-info">
                    <h3 class="tabtitle">RPM Device Management</h3>
                    <div class="clear"></div>
                </div>
            </div>
        </div>
        
        <div class="menu-container">
            <div class="container">
                <?php
                    if( $_SESSION['user_type'] == 'nurse' ){
                        include('nurse_dashboard_nav.php');
                    }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
                        include('physician_dashboard_nav.php');
                    }
                ?>
            </div>
        </div>
        
    </div>
    <!-- Header -->
    
    <div class="container">
        <div class="TableContainer">
            <table id="myTable">
            	<thead>
                    <tr>
                        <td>Patient Name</td>
                        <td>AnyHub</td>
                        <td>BP Cuff</td>
                        <td>Weighing Scale</td>
                        <td>Action</td>
                    </tr>
                </thead>
    
                <tbody>
                    
                    <?php

                        if (isset($_GET['patient_id'])) {
                            $patient_id = $_GET['patient_id'];
                        } else {
                            $patient_id = '0';
                        }
                        
                        $version = get_version();
                        
                        $sql = "SELECT pat.assigned_nurse, pat.patient_id, pat.patient_fname, pat.patient_lname, pat.patient_dob, pat.cell, pat.patient_gender FROM patients as pat WHERE pat.groupid = '$version' GROUP BY pat.patient_id ORDER BY pat.patient_id DESC";
                        
                        $result = ddxrxDBConnect()->query($sql);
                        
                        if ($result->num_rows > 0) {
                            // output data of each row
                            while($row = $result->fetch_assoc()) {
                                
                                $patient_id = $row["patient_id"];
                                
                                // Get all device information for this patient using a single JOIN query
                                $sql_devices = "SELECT 
                                    MAX(CASE WHEN c.device_type = 'anyhub' THEN c.imei END) as anyhub_imei,
                                    MAX(CASE WHEN c.type = 'bp' THEN c.imei END) as bp_imei,
                                    MAX(CASE WHEN c.type = 'weight' THEN c.imei END) as weight_imei
                                FROM patients p
                                LEFT JOIN cardiowell_users c ON p.patient_id = c.patient_id
                                WHERE p.patient_id = '$patient_id'
                                GROUP BY p.patient_id";
                                
                                $result_devices = ddxrxDBConnect()->query($sql_devices);
                                $devices_row = mysqli_fetch_assoc($result_devices);
                                
                                // Check device status and prepare display
                                $anyhub_linked = !empty($devices_row['anyhub_imei']);
                                $bp_linked = !empty($devices_row['bp_imei']);
                                $weight_linked = !empty($devices_row['weight_imei']);
                                
                                $anyhub_imei = $anyhub_linked ? $devices_row['anyhub_imei'] : 'Not Linked';
                                $bp_imei = $bp_linked ? $devices_row['bp_imei'] : 'Not Linked';
                                $weight_imei = $weight_linked ? $devices_row['weight_imei'] : 'Not Linked';
                                
                                // Count total devices linked
                                $total_devices = ($anyhub_linked ? 1 : 0) + ($bp_linked ? 1 : 0) + ($weight_linked ? 1 : 0);
                                
                                // Add row class based on device count
                                $row_class = '';
                                if($total_devices == 3) {
                                    $row_class = 'all-devices-linked';
                                } elseif($total_devices > 0) {
                                    $row_class = 'partial-devices-linked';
                                } else {
                                    $row_class = 'no-devices-linked';
                                }
                                
                                echo '<tr class="patient_id patient_'.$patient_id.' '.$row_class.'" id="patient_'.$patient_id.'" data-patient-id="'.$patient_id.'">';
                                
                                echo '<td class="enabled patient-name">' . $row["patient_lname"] . ' ' . $row["patient_fname"] . '</td>';
                                
                                // AnyHub column
                                $anyhub_class = $anyhub_linked ? 'device-linked' : 'device-not-linked';
                                echo '<td class="enabled device-cell '.$anyhub_class.'">';
                                echo '<span class="device-status-badge '.($anyhub_linked ? 'linked' : 'not-linked').'">';
                                echo htmlspecialchars($anyhub_imei, ENT_QUOTES, 'UTF-8');
                                echo '</span></td>';
                                
                                // BP Cuff column
                                $bp_class = $bp_linked ? 'device-linked' : 'device-not-linked';
                                echo '<td class="enabled device-cell '.$bp_class.'">';
                                echo '<span class="device-status-badge '.($bp_linked ? 'linked' : 'not-linked').'">';
                                echo htmlspecialchars($bp_imei, ENT_QUOTES, 'UTF-8');
                                echo '</span></td>';
                                
                                // Weight Scale column
                                $weight_class = $weight_linked ? 'device-linked' : 'device-not-linked';
                                echo '<td class="enabled device-cell '.$weight_class.'">';
                                echo '<span class="device-status-badge '.($weight_linked ? 'linked' : 'not-linked').'">';
                                echo htmlspecialchars($weight_imei, ENT_QUOTES, 'UTF-8');
                                echo '</span></td>';
                                
                                echo '<td class="enabled action-cell">';
                                echo '<a href="manage-devices.php?patient_id='.$patient_id.'" class="button manage-button">Manage Devices</a>';
                                if($total_devices > 0) {
                                    echo '<span class="device-count-badge">'.$total_devices.'/3</span>';
                                }
                                echo '</td>';
                                echo '</tr>';
                                
                                
                            }
                        } else {
                            //echo "0 results";
                        }
                        
                        ddxrxDBConnect()->close();
                        
                    ?>
                    
                </tbody>
            </table>
        </div>
    </div>
    
    <?php
                
    	if( $_SESSION['userType'] == 'nurse' ){
                        
    		provider_bottom_nav();
                        
    	}elseif( $_SESSION['userType'] == 'doctor' ){
                        
    		physician_bottom_nav();
                        
    	}else{
                        
    		bottom_nav();
                        
    	}

    ?>
    
</body>
</html>