<?php

error_reporting(1);
ob_start();
session_start();

// Mobile Detect
require_once("mobile_detect.php");
$detect = new Mobile_Detect;

// print_r($_SESSION);
if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    header("Location: ios-launch.php");
    die();
}

// Inlcudes
include ('process/functions.php');

// Check if the session has expired
checkSessionTimeout();

?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>DDXRX Choose Actions</title>
	
	<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script type="text/javascript" src="assets/js/base64converter.js"></script>
	<script type="text/javascript" src="assets/js/autocomplete/jquery.autocomplete.min.js"></script>
	<script type="text/javascript" src="assets/js/mobile.js"></script>
	<script type="text/javascript" src="assets/js/faq.js"></script>
	<script type="text/javascript" src="assets/js/phone-call.js"></script>
	
	<?php if ( $detect->isMobile() ) { ?>
	<script type="text/javascript" src="assets/js/vitals_mobile.js"></script>
	<?php }else{ ?>
	<script type="text/javascript" src="assets/js/vitals.js"></script>
	<?php } ?>
	
	
	<script type="text/javascript">
        var vitalFields = <?php echo json_encode($vitalFields); ?>;
    </script>
    
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
	<link rel="stylesheet" type="text/css" href="assets/css/grid.css">
	<link rel="stylesheet" type="text/css" href="assets/css/autocomplete/jquery.autocomplete.css"/>
	<link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
	<link rel="stylesheet" type="text/css" href="assets/css/vitals.css">
	<link rel="stylesheet" type="text/css" href="assets/css/faq.css">
	
	<!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-148409281-5"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'UA-148409281-5');
    </script>
	
</head>
<body data-patient-id="<?php echo get_patient_id(); ?>">
    
    <div class="loading-screen"></div>
    
    <?php bottom_nav(); ?>
    
    <div class="container">
        <div class="rpm-container">
            
            <div class="col-md-12">
                <h4 class="cardiowell-header-title">Your Connected Devices</h4>
            </div>
            
            <div class="col-md-3">
                <div class="item">
                    <?php
                        $patient_id = get_patient_id();
                        $sql = "SELECT * FROM cardiowell_users WHERE patient_id = '$patient_id' AND `device_type` = 'anyhub'  LIMIT 1";
                        $result = mysqli_query(ddxrxDBConnect(), $sql);
                        $row = mysqli_fetch_assoc($result);
                            
                        if( $row['imei'] != '' && $row['status'] == 'running' ){
                            
                            $status = 'Connected';
                            $class = 'connected';
                            $buttonClass = 'red connected';
                            $buttonLabel = 'Disconnect Device';
                            
                        }elseif( $row['imei'] != '' && $row['status'] == 'pending' ){
                            
                            $status = 'Pending Removal';
                            $class = 'pending';
                            $buttonClass = 'gray pending';
                            $buttonLabel = 'Pending Removal';
                            
                        }else{
                            
                            $status = 'Not Connected';
                            $class = 'disconnected';
                            $buttonClass = 'blue disconnected';
                            $buttonLabel = 'Connect and sync data';
                            
                        }
                        
                        echo '
                            <div class="ihealth-connect cardiowell anyhub">
                                <h6>Cellular Connected: AnyHub</h6>
                                <p>Connection Status: <span class="status '.$class.'">'.$status.'</span></p>
                                <p>Serial Number: <span class="status '.$class.'">'.$row['imei'].'</span></p>
                                <a href="javascript:;" class="button '.$buttonClass.'" data-machine="anyhub" data-imei="'.$row['imei'].'">'.$buttonLabel.'</a>
                            </div>
                        ';
                        
                    ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="item">
                    <?php
                        $patient_id = get_patient_id();
                        $sql = "SELECT * FROM cardiowell_users WHERE patient_id = '$patient_id' AND type = 'bp' LIMIT 1";
                        $result = mysqli_query(ddxrxDBConnect(), $sql);
                        $row = mysqli_fetch_assoc($result);
                            
                        if( $row['imei'] != '' && $row['status'] == 'running' ){
                            
                            $status = 'Connected';
                            $class = 'connected';
                            $buttonClass = 'red connected';
                            $buttonLabel = 'Disconnect Device';
                            
                        }elseif( $row['imei'] != '' && $row['status'] == 'pending' ){
                            
                            $status = 'Pending Removal';
                            $class = 'pending';
                            $buttonClass = 'gray pending';
                            $buttonLabel = 'Pending Removal';
                            
                        }else{
                            
                            $status = 'Not Connected';
                            $class = 'disconnected';
                            $buttonClass = 'blue disconnected';
                            $buttonLabel = 'Connect and sync data';
                            
                        }
                        
                        echo '
                            <div class="ihealth-connect cardiowell bloodpressure">
                                <h6>Cellular Connected: Blood Pressure Cuff</h6>
                                <p>Connection Status: <span class="status '.$class.'">'.$status.'</span></p>
                                <p>IMEI Number: <span class="status '.$class.'">'.$row['imei'].'</span></p>
                                <a href="javascript:;" class="button '.$buttonClass.'" data-machine="bp" data-imei="'.$row['imei'].'">'.$buttonLabel.'</a>
                            </div>
                        ';
                        
                    ?>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="item">
                    <?php
                        $patient_id = get_patient_id();
                        $sql = "SELECT * FROM cardiowell_users WHERE patient_id = '$patient_id' AND type = 'weight' LIMIT 1";
                        $result = mysqli_query(ddxrxDBConnect(), $sql);
                        $row = mysqli_fetch_assoc($result);
                            
                        if( $row['imei'] != '' ){
                            $status = 'Connected';
                            $imei = $row['imei'];
                            $class = 'connected';
                            $buttonClass = 'red connected';
                            $buttonLabel = 'Disconnect Device';
                        }else{
                            $status = 'Not Connected';
                            $imei = 'Not Connected';
                            $class = 'disconnected';
                            $buttonClass = 'blue disconnected';
                            $buttonLabel = 'Connect and sync data';
                        }
                        
                        echo '
                            <div class="ihealth-connect cardiowell weighingscale">
                                <h6>Cellular Connected: Weighing Scale</h6>
                                <p>Connection Status: <span class="status '.$class.'">'.$status.'</span></p>
                                <p>IMEI Number: <span class="status '.$class.'">'.$imei.'</span></p>
                                <a href="javascript:;" class="button '.$buttonClass.'" data-machine="weight" data-imei="'.$row['imei'].'">'.$buttonLabel.'</a>
                            </div>
                        ';
                        
                    ?>
                </div>
            </div>
            
        
    	    <div class="col-md-3">
                <div class="item">
                    <?php
                        $user_id = $_SESSION["userid"];
                        $query = "SELECT * FROM ihealth_users WHERE user_id = '$user_id' LIMIT 1";
                        $result = mysqli_query(ddxrxDBConnect(), $query) or die(mysqli_error(ddxrxDBConnect()));
                        $data = mysqli_fetch_assoc($result);
                        
                        if( !empty($data['patient_id']) ){
                            
                            $status = 'Connected';
                            $status_class = 'connected';
                            $button_class = 'button red';
                            $label = 'Disconnect Device';
                            
                        }else{
                            
                            $status = 'Not Connected';
                            $status_class = 'disconnected';
                            $button_class = 'button blue';
                            $label = 'Connect and sync data';
                            
                        }
                        
                        echo '
                        <div class="ihealth-connect">
                            <h6>Ihealth Monitoring</h6>
                            <p>Connection Status: <span class="'.$status_class.'">'.$status.'</span></p>
                            <a href="ihealth-api-patient/disconnect.php" class="'.$button_class.'">'.$label.'</a>
                        </div>
                        ';
                    ?>
                </div>
            </div>
                
            <?php mysqli_close(ddxrxDBConnect()); ?>
            
        </div>
    </div>
    
</body>
</html>