<!DOCTYPE html>
<html>
<head>
    <title>Sign Up to Access DDxRx Results</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link rel="stylesheet" type="text/css" href="assets/css/forms.css">
    
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <script type="text/javascript" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
    <script type="text/javascript" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    
    <style>
        .landing-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 20px;
            text-align: center;
        }
        
        .content-box {
            background: white;
            border-radius: 10px;
            padding: 40px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            margin: 0 auto;
        }
        
        .feature-icon {
            font-size: 4rem;
            color: #027eff;
            margin-bottom: 20px;
        }
        
        .main-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 20px;
            line-height: 1.2;
        }
        
        .subtitle {
            font-size: 1.2rem;
            color: #555555;
            margin-bottom: 30px;
            line-height: 1.5;
        }
        
        .features-list {
            text-align: left;
            margin: 30px 0;
            padding: 0;
            list-style: none;
        }
        
        .features-list li {
            display: flex;
            align-items: center;
            padding: 10px 0;
            font-size: 1.1rem;
            color: #2c3e50;
        }
        
        .features-list li ion-icon {
            color: #27ae60;
            margin-right: 15px;
            font-size: 1.5rem;
        }
        
        .cta-buttons {
            margin-top: 40px;
        }
        
        .btn-primary {
            background-color: #027eff;
            color: #FFFFFF;
            display: inline-block;
            padding: 15px 30px;
            font-size: 18px;
            font-weight: 600;
            border: none;
            border-radius: 50px;
            cursor: pointer;
            text-decoration: none;
            margin: 10px;
            transition: background-color 0.3s ease;
        }
        
        .btn-primary:hover {
            background-color: #0159cc;
        }
        
        .btn-secondary {
            background-color: #34495e;
            color: #FFFFFF;
            display: inline-block;
            padding: 15px 30px;
            font-size: 18px;
            font-weight: 600;
            border: none;
            border-radius: 50px;
            cursor: pointer;
            text-decoration: none;
            margin: 10px;
            transition: background-color 0.3s ease;
        }
        
        .btn-secondary:hover {
            background-color: #2c3e50;
        }
        
        .login-link {
            margin-top: 20px;
            font-size: 14px;
            color: #555555;
        }
        
        .login-link a {
            color: #027eff;
            text-decoration: none;
            font-weight: 500;
        }
        
        .login-link a:hover {
            text-decoration: underline;
        }
        
        .medical-disclaimer {
            background-color: #f8f9fa;
            border-left: 4px solid #027eff;
            padding: 15px;
            margin-top: 30px;
            font-size: 12px;
            color: #666666;
            text-align: left;
            line-height: 1.5em;
        }
        
        @media (max-width: 768px) {
            .content-box {
                padding: 30px 20px;
                margin: 10px;
            }
            
            .main-title {
                font-size: 2rem;
            }
            
            .subtitle {
                font-size: 1.1rem;
            }
            
            .btn-primary,
            .btn-secondary {
                display: block;
                width: 100%;
                margin: 10px 0;
            }
        }
    </style>
</head>
<body>
    <div class="landing-container">
        <div class="content-box">
            <div class="feature-icon">
                <ion-icon name="medical-outline"></ion-icon>
            </div>
            
            <h1 class="main-title">
                Access Advanced Diagnostic Results
            </h1>
            
            <p class="subtitle">
                Sign up for a DDxRx account to unlock comprehensive diagnostic insights, AI-powered differential diagnoses, and advanced healthcare analytics.
            </p>
            
            <ul class="features-list">
                <li>
                    <ion-icon name="checkmark-circle"></ion-icon>
                    AI-powered diagnostic decision support
                </li>
                <li>
                    <ion-icon name="checkmark-circle"></ion-icon>
                    Comprehensive differential diagnosis reports
                </li>
                <li>
                    <ion-icon name="checkmark-circle"></ion-icon>
                    Patient management tools
                </li>
                <li>
                    <ion-icon name="checkmark-circle"></ion-icon>
                    Clinical documentation assistance
                </li>
                <li>
                    <ion-icon name="checkmark-circle"></ion-icon>
                    Secure, HIPAA-compliant platform
                </li>
            </ul>
            
            <div class="cta-buttons">
                <a href="signUpPatient.php?plan=1" class="btn-primary">
                    <ion-icon name="person-add-outline" style="margin-right: 8px;"></ion-icon>
                    Create Free Account
                </a>
            </div>
            
            <div class="login-link">
                Already have an account? <a href="login.php">Sign in here</a>
            </div>
            
            <div class="medical-disclaimer">
                <strong>Medical Disclaimer:</strong> This software is designed for educational purposes and clinical decision support. It is not intended to replace professional medical judgment or patient care. Always consult with qualified healthcare providers for medical decisions.
            </div>
        </div>
    </div>
    
    <script>
        // Add smooth scrolling and interactive effects
        document.addEventListener('DOMContentLoaded', function() {
            // Add hover effects to buttons
            const buttons = document.querySelectorAll('.btn-primary, .btn-secondary');
            buttons.forEach(button => {
                button.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-2px)';
                    this.style.boxShadow = '0 6px 20px rgba(0, 0, 0, 0.15)';
                });
                
                button.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                    this.style.boxShadow = 'none';
                });
            });
            
            // Add fade-in animation to content box
            const contentBox = document.querySelector('.content-box');
            contentBox.style.opacity = '0';
            contentBox.style.transform = 'translateY(30px)';
            
            setTimeout(() => {
                contentBox.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
                contentBox.style.opacity = '1';
                contentBox.style.transform = 'translateY(0)';
            }, 100);
        });
    </script>
</body>
</html>
