<?php

session_start();

// Include the functions file
include('process/functions.php');

// Check if the session has expired
checkSessionTimeout();

if( isset($_SESSION['userType']) ){

    if( $_SESSION['userType'] == "patient" ) {
        header("Location: view_record.php");
        die();
    }

}else{

    header("Location: logout.php");
    die();

}

if( isset($_GET['patient_id']) && isset($_GET['uid']) ){

    $name = "";
    $patient_id = $_GET['patient_id'];
    $uid = $_GET['uid'];

    $sql = "SELECT * FROM patients WHERE patient_id = '$patient_id' LIMIT 1";
    $result = mysqli_query(ddxrxDBConnect(), $sql) or die('SQL Error :: '.mysqli_error());
    $user = mysqli_fetch_assoc($result);
        
    $providerSQL = "SELECT all_users.user_type, all_users.userid, physician.physician_fname, physician.physician_lname, nurse.nurse_fname, nurse.nurse_lname from all_users left join physician on all_users.userid = physician.user_id left join nurse on all_users.userid = nurse.user_id where all_users.userid = ".$_SESSION['userid'];
    $providerResult = mysqli_query(ddxrxDBConnect(), $providerSQL) or die('SQL Error :: '.mysqli_error());
    $provider = mysqli_fetch_assoc($providerResult);
    $provider_user_id = $provider['userid'];

    // Close the connection
    mysqli_close(ddxrxDBConnect());

    if($provider['user_type'] == "2") {
        $name = $provider['physician_fname']." ".$provider['physician_lname'];
    } else {
        $name = $provider['nurse_fname']." ".$provider['nurse_lname'];
    }

}else{

    header("Location: new_records.php");
    die();

}

?>
    
    <!DOCTYPE html>
    <html  class="ui-mobile">
        <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <title>DDXRX - Type Order</title>
            
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            
            <script type="text/javascript" src="assets/js/jquery-3.3.1.min.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            <script type="text/javascript" src="assets/js/jquery.jqscribble.js"></script>
            <script type="text/javascript" src="assets/js/pencil.js"></script>
            <script type="text/javascript" src="assets/js/mobile.js"></script>
            <script type="text/javascript" src="assets/js/jquery.jqscribble.js"></script>
            <script type="text/javascript" src="assets/js/jquery-liveedit.js"></script>
    
            <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
            <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
            <link rel="stylesheet" type="text/css" href="assets/css/style.css">
            <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
            <link rel="stylesheet" type="text/css" href="assets/css/patient-records.css">
            <link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
            <link rel="stylesheet" type="text/css" href="assets/css/faq.css">
            <link rel="stylesheet" type="text/css" href="assets/css/jquery-liveedit.css">
            
            <style>
                body{
                    top: 0px!important;
                }
                .goog-te-banner-frame.skiptranslate {
                    display: none !important;
                }
                #goog-gt-tt{
                    display:none!important;
                }
                #google_translate_element{
                    position: fixed; left:20px; top: 20px; z-index: 9999999;
                }
            </style>
            
            <script type="text/javascript">
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({pageLanguage: 'en', 
                layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
                autoDisplay: false, 
                includedLanguages: ''}, 'google_translate_element');}
            </script>
            <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
            
        </head>
        <body data-user-id="<?php echo $patient_id; ?>">
            
            <div class="loading-screen"></div>
            
            <div id="google_translate_element"></div>
            
            <?php include('dashboard_menu.php'); ?>
    
            <div class="container pb-100 optimized-container"<?php if( isset($_GET['patient_id']) ){ echo ' data-user="'.$_GET['patient_id'].'"'; } ?>>
                <div class="col-md-12">
                    <div id="toPrint">
                        <div class="form-container">
    
                            <div class="record-navigation-menu">
                                <?php include('emr_navigation.php'); ?>
                            </div>
                            
                            <div class="tab-content-container no-border" style="margin-top: 30px;">
                                
                                <div class="order-header">
                                    <h6>Type Order</h6>
                                    <ul class="nav-menu">
                                        <li><a href="write-order.php?uid=<?php echo $uid; ?>&patient_id=<?php echo $patient_id; ?>">Hand Order</a></li>
                                        <li><a href="type-order.php?uid=<?php echo $uid; ?>&patient_id=<?php echo $patient_id; ?>" class="current">Type Order</a></li>
                                    </ul>
                                </div>

                                <div class="canvas-main-container" style="display: none;">
                                    <div id="canvas-container"></div>
                                </div>

                                <article class="live-edit" data-model="article" data-id="1" data-url="/articles">
                                    <div class="editable-section" data-editable="true" data-name="content" data-text-options="true" placeholder="Start typing order here..."></div>
                                </article>
                                
                                <div class="provider-signature">
                                    <div class="signatureCanvas"></div>
                                    <h6><span>Signed By:</span> <?php echo $name; ?></h6>
                                </div>

                                <div class="controls">
                                    <p class="agreement">By submitting your digital signature, you confirm that all information provided is accurate and final. Once signed, this agreement is legally binding and will be securely recorded in our database. It cannot be modified, edited, or revoked. You acknowledge that your digital signature holds the same legal weight as a physical signature and agree to comply with all applicable laws and regulations.</p>
                                    <label class="checkbox-container">
                                        <input type="checkbox" name="signature" value="true" class="signature"><span>I Agree with the terms.</span>
                                    </label>
                                    <input type="hidden" id="order_date" value="<?php echo date('Y/m/d - H:i:s'); ?>">
                                    <input type="hidden" id="provider_id" value="<?php echo $provider_user_id; ?>">
                                    <input type="hidden" id="provider_name" value="<?php echo $name; ?>">

                                    <input type="hidden" id="uid" value="<?php echo $uid; ?>">
                                    <input type="hidden" id="patient_id" value="<?php echo $patient_id; ?>">
                                    <input type="hidden" id="patient_name" value="<?php echo $user['patient_fname'].' '.$user['patient_lname']; ?>">
                                    <input type="hidden" id="patient_dob" value="<?php echo $user['patient_dob']; ?>">
                                    <input type="hidden" id="patient_gender" value="<?php echo $user['patient_gender']; ?>">
                                    <input type="hidden" id="patient_mobile" value="<?php echo $user['cell']; ?>">
                                    
                                    <a href="javascript:;" class="button large rounded solid gray save_canvas type-order">Submit Order</a>
                                    <a href="javascript:;" class="button large rounded solid blue clear_canvas">Reset</a>
                                </div>
                                    
                            </div>
    
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
            </div>
    
            <?php
            	if( $_SESSION['userType'] == 'nurse' ){
            		provider_bottom_nav();
            	}elseif( $_SESSION['userType'] == 'doctor' ){
            		physician_bottom_nav();
            	}else{
            		bottom_nav();
            	}
            ?>
    
        </body>
    </html>