<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

include ('includes/database_include.php');
// require_once(__DIR__.'/payment/stripe/init.php');
// require_once(__DIR__.'/payment/stripe-php-7.80.0/init.php');
require_once(__DIR__.'/payment/CustomStripe.php');

$customStripe = new CustomStripe();

require_once(__DIR__.'/payment/stripe_config.php'); // New file added by THS on April 12, 2021


if(defined('STRIPE_MODE') && STRIPE_MODE == 'live'){
    $plans = STRIPE_LIVE_PLAN;
    $coupons = COUPONS;
}else{
    $plans = STRIPE_TEST_PLAN;
    $coupons = COUPONS;
}

if(!isset($_SESSION['payment_userid']) || !isset($_SESSION['payment_userType']) || $_SESSION['payment_userType'] != "patient") {
    header("Location: ios-launch.php");
    die();
}

$payment_userid = $_SESSION['payment_userid'];

if(!isset($_POST['stripeEmail']) || !isset($_POST['stripeToken']) || !isset($_POST['pricing'])) {
    header('Location: payment_failed.html');
    die();
}

if(!isset($_POST['pricing'])) {
    header("Location: search_dd.php?invalid");
    die();
}

if(isset($_POST['coupon']) && !empty($_POST['coupon'])){
    $coupon = trim($_POST['coupon']);
}else{
    $coupon = '';
}


// Initialize Stripe
if(!defined('STRIPE_MODE') || (STRIPE_MODE != 'live')) {
    // \Stripe\Stripe::setApiKey(STRIPE_TEST_SECRET_KEY);
    
    $stripe = new \Stripe\StripeClient(STRIPE_TEST_SECRET_KEY);

}else{
    // \Stripe\Stripe::setApiKey(STRIPE_LIVE_SECRET_KEY);
    $stripe = new \Stripe\StripeClient(STRIPE_LIVE_SECRET_KEY);
}

// Select Patient by patient user id 
$searchPatientQuery = "SELECT * FROM patients WHERE user_id = '$payment_userid'";
$searchPatientResult = mysqli_query($con, $searchPatientQuery);

if (mysqli_num_rows($searchPatientResult) > 0) {
            
    $patient = mysqli_fetch_array($searchPatientResult);
    $customer_id = $patient['stripe_customer_id'];
    $customerObj = $patient['stripe_customer_body'];
}

if(isset($patient) && !empty($patient) && !empty($customer_id)){
    // Retrieve Stripe Customer Info by Stripe Customer ID
    $stripeCustomerInfoResponse = $customStripe->retrieve_customer($customer_id);
    
    if($stripeCustomerInfoResponse['status'] != 200){
        // Create New Stripe Customer Using POST data
        $stripeCreateCustomerInfo = $customStripe->create_customer(['email' => $_POST['stripeEmail'], 'source'  => $_POST['stripeToken']]);
        
        echo '<pre>'; 
        print_r($stripeCreateCustomerInfo);
        exit();
        
        $stripeCustomerInfo = $stripeCreateCustomerInfo['data'];
        
        $customer_id = $stripeCreateCustomerInfo['data']->id;
        $customerObj = json_encode($stripeCreateCustomerInfo['data']);
        
        mysqli_query("UPDATE patients set customer_id = '$customer_id',  stripe_customer_body = '$customerObj' WHERE user_id = '$payment_userid'");
    }else{
        $stripeCustomerInfo = $stripeCustomerInfoResponse['data'];
        
        // Create Credit Card or Update Credit Card
        $cardObject = array();
        
        $cardObject['address_line1'] = array_key_exists('street_address', $_POST) ? $_POST['street_address'] : '';
        $cardObject['address_city'] = array_key_exists('billing_city', $_POST) ? $_POST['billing_city'] : '';
        $cardObject['address_state'] = array_key_exists('billing_state', $_POST) ? $_POST['billing_state'] : '';
        $cardObject['address_zip'] = array_key_exists('billing_zip', $_POST) ? $_POST['billing_zip'] : '';
        $cardObject['name'] = array_key_exists('name', $_POST) ? $_POST['name'] : '';
        $cardObject['token'] = array_key_exists('stripeToken', $_POST) ? $_POST['stripeToken'] : '';

        
        $createCardResponse = $customStripe->create_card($customer_id, $cardObject);
        
        if($createCardResponse['status']==200){
            
            $createCardObject = $createCardResponse['data'];
            $new_card_id = $createCardObject->id;
            
            $updateCustomerResponse = $customStripe->update_customer_default_source($customer_id, $new_card_id);
        }
    }
    
    echo '<pre>'; 
    print_r($updateCustomerResponse);
    exit();
}

try
{
    
    // set expired date values
    if(isset($_POST['pricing']) && array_key_exists($_POST['pricing'], SUBSCRIPTION_EXPIRED_DAYS)){
        $subscription_expired_days = SUBSCRIPTION_EXPIRED_DAYS;
        
        $expired_days = $subscription_expired_days[$_POST['pricing']];
        
        $expired_date = date('Y-m-d', strtotime("+ $expired_days days"));
    }else{
        $expired_date = null;
    }

    // Check Coupon Code 
    if(isset($coupon) && !empty($coupon) && array_key_exists($coupon, $coupons) && $coupon == 'Genie2021'){
        
        $customer = \Stripe\Customer::create([
            'email' => $_POST['stripeEmail'],
            'source'  => $_POST['stripeToken'],
        ]);
            
        $customer_id = $customer->id;
        $customerObj = json_encode($customer);
        
        $random_charge_amount = rand(50, 99);
        
        // code for one time payment of $40
        $charge = \Stripe\Charge::create([
            'amount' => $random_charge_amount,
            'currency' => 'usd',
            'description' => 'DDxRx One Month Subscription',
            'customer' => $customer_id
        ]);
        
        // $capture = \Stripe\Charge::capture($charge->id, []); 
        $refund = \Stripe\Refund::create([
          'charge' => $charge->id,
        ]);
        
        if($charge->id && $refund->id){
            // $update_query = "UPDATE patients SET stripe_plan_type =  '".$_POST['pricing']."', stripe_subscription_isactive = true WHERE user_id=".$_SESSION['payment_userid'];
            $update_query = "UPDATE patients SET stripe_plan_type =  '".$_POST['pricing']."', subscription_expired_date =  '".$expired_date."', stripe_subscription_isactive = true, stripe_customer_id = '".$customer_id."', stripe_customer_body = '".$customerObj."' WHERE user_id=".$_SESSION['payment_userid'];
    
            $run = mysqli_query($con, $update_query);
        }
    	
    	if(isset($run) && $run) {
            header('Location: thank-you.php');
    	} else {
            header('Location: payment_failed.html');
    	}
    }else if(isset($coupon) && !empty($coupon) && array_key_exists($coupon, $coupons)){
        $trial_period_days = (int) $coupons[$coupon];
    }

    
    
    // code for recurring monthly subscriptions
    if($_POST['pricing'] != "plan_4") {
        
        $customer_id = "";
        
        
        if($customer_id == "") {
            
            $customer = \Stripe\Customer::create([
                'email' => $_POST['stripeEmail'],
                'source'  => $_POST['stripeToken'],
            ]);
            
            $customer_id = $customer->id;
            $customerObj = json_encode($customer);
        }
        
        echo '<pre>';
        // print_r(\Stripe\Customer::retrieve($customer_id.'3'));
        print_r($stripe->customers->retrieve($customer_id, []));
        echo '<hr>';
        print_r($patient);
        exit();
        
        $subscription_data = [];
        
        $subscription_data['customer'] = $customer_id;
        $subscription_data['items'] = [['plan' => $plans[$_POST['pricing']]]];
        
        // $subscription_data['trial_from_plan'] = true;
            
        if(isset($trial_period_days) && $trial_period_days > 0){
            $subscription_data['trial_period_days'] = $trial_period_days;
        }
		
		if($_POST['pricing'] == "plan_3" && !empty($coupon)){  // if plan is $20 then need to apply coupon
		
		  //  $subscription_data['coupon'] = $coupon;
			
        }
        
        $subscription = \Stripe\Subscription::create($subscription_data);
        
        if ($subscription->status != 'incomplete') {
            
        	$update_query = "UPDATE patients SET stripe_plan_type =  '".$_POST['pricing']."', subscription_expired_date =  '".$expired_date."', stripe_customer_id = '".$customer_id."', stripe_customer_body = '".$customerObj."', stripe_subscription_id = '".$subscription->id."', stripe_subscription_body = '".json_encode($subscription)."', stripe_subscription_isactive = true WHERE user_id=".$_SESSION['payment_userid'];
        	$run = mysqli_query($con, $update_query);
        	
        	if($run) {
                header('Location: thank-you.php');
        	} else {
                header('Location: payment_failed.html');
        	}
        	
        } else {
            
            header('Location: payment_failed.html');
            error_log("failed to collect initial payment for subscription");
        }
        
        exit;
    } else if($_POST['pricing'] == "plan_4") {

        $customer = \Stripe\Customer::create([
            'email' => $_POST['stripeEmail'],
            'source'  => $_POST['stripeToken'],
        ]);
            
        $customer_id = $customer->id;
        
        // code for one time payment of $40
        $charge = \Stripe\Charge::create([
            'amount' => 4000,
            'currency' => 'usd',
            'description' => 'DDxRx One Month Subscription',
            'customer' => $customer_id
        ]);
        
        // print_r($charge);
        if ($charge->status == 'succeeded') {
        	$update_query = "UPDATE patients SET stripe_plan_type =  '".$_POST['pricing']."', subscription_expired_date =  '".$expired_date."', stripe_subscription_isactive = true WHERE user_id=".$_SESSION['payment_userid'];
        	$run = mysqli_query($con, $update_query);
        	
        	if($run) {
                header('Location: thank-you.php');
        	} else {
                header('Location: payment_failed.html');
        	}
        } else {
            header('Location: payment_failed.html');
            error_log("failed to collect initial payment for subscription");
        }
        exit;
    }else{
        echo '<pre>';
        print_r($_POST);
        exit();
        
        header('Location: payment_failed.html');
    }
}catch(\Stripe\Exception\CardException $e) {
  // Since it's a decline, \Stripe\Exception\CardException will be caught
  echo 'Status is:' . $e->getHttpStatus() . '\n';
  echo 'Type is:' . $e->getError()->type . '\n';
  echo 'Code is:' . $e->getError()->code . '\n';
  // param is '' in this case
  echo 'Param is:' . $e->getError()->param . '\n';
  echo 'Message is:' . $e->getError()->message . '\n';
} catch (\Stripe\Exception\RateLimitException $e) {
  // Too many requests made to the API too quickly
} catch (\Stripe\Exception\InvalidRequestException $e) {
    // Invalid parameters were supplied to Stripe's API
    // echo '<pre>';
    // print_r($e);
    // exit();
    
    echo 'Status is:' . $e->getHttpStatus() . '<br>';
    echo 'Type is:' . $e->getError()->type . '<br>';
    echo 'Code is:' . $e->getError()->code . '<br>';
    // param is '' in this case
    echo 'Param is:' . $e->getError()->param . '<br>';
    echo 'Message is:' . $e->getError()->message . '<br>';
} catch (\Stripe\Exception\AuthenticationException $e) {
    // Authentication with Stripe's API failed
    // (maybe you changed API keys recently)
    echo '<pre>';
    print_r($e);
    exit();
} catch (\Stripe\Exception\ApiConnectionException $e) {
    // Network communication with Stripe failed
    echo '<pre>';
    print_r($e);
    exit();
} catch (\Stripe\Exception\ApiErrorException $e) {
    // Display a very generic error to the user, and maybe send
    // yourself an email
    
} catch (Exception $e) {
    echo '<pre>';
    print_r($e);
    exit();
  // Something else happened, completely unrelated to Stripe
}
?>