<?php

    session_start();
    
    if ( !isset( $_SESSION['userType'] ) ) {
        header("Location: login.php");
        die();
    }

    if( $_SESSION['userType'] != 'doctor' && $_SESSION['userType'] != 'nurse' ) {
        header("Location: login.php");
        die();
    }
    
    date_default_timezone_set('America/Chicago');
    
    // Include the functions file
    include('process/functions.php');

    // Check if the session has expired
    checkSessionTimeout();
    
    function get_user_info( $patient_id, $field = null ){
    
        $query = "SELECT * FROM patients WHERE patient_id = '$patient_id' limit 1";
        
        $results = array();
        
        if ($result = ddxrxDBConnect()->query($query)) {
    
            /* fetch associative array */
            while ($row = $result->fetch_assoc()) {
                $results[] = $row;
            }
    
            /* free result set */
            $result->free();
        }
        
        /* close connection */
        ddxrxDBConnect()->close();
        
        /* print json object*/
        return $results[0][$field];
        
    }
    
    function get_nurse_dropdown( $type = null, $nurseId = null ){
        
        $temp = '';
        $group_id = get_version();
        
        $sql = "SELECT * FROM `nurse` WHERE groupid = '$group_id'";
        $result = ddxrxDBConnect()->query($sql);
                    
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                
                if( $type == 'main' ){
                    
                    if( isset($_GET['filter']) && $_GET['filter'] ==  $row['user_id'] ){
                        $selected = 'selected';
                    }else{
                        $selected = '';
                    }
                    
                    $temp .= '<option value="'.$row['user_id'].'" '.$selected.'>'.$row['nurse_fname'].' '.$row['nurse_lname'].'</option>';
                    
                }else if( $type == 'assign' ){
                    
                    if( $nurseId ==  $row['user_id'] ){
                        $selected = 'selected';
                    }else{
                        $selected = '';
                    }
                    
                    $temp .= '<option value="'.$row['user_id'].'" '.$selected.'>'.$row['nurse_fname'].' '.$row['nurse_lname'].'</option>';
                    
                }else{
                    
                    $temp .= '<option value="'.$row['user_id'].'">'.$row['nurse_fname'].' '.$row['nurse_lname'].'</option>';
                    
                }
                
                
            }
        }
        
        return $temp;
        
        ddxrxDBConnect()->close();
        
    }

?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>Patient Vital Dashboard</title>
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
    <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
	
	<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/js-cookie@3.0.0/dist/js.cookie.min.js"></script>
	<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script type="text/javascript" src="//cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
	<script type="text/javascript" src="assets/js/vitals_history.js"></script>
	
	<script type="text/javascript">
	    $(document).ready(function(){
	        
	        // Load DataTable JS
            $('#myTable').DataTable({
                "pageLength": 50,
                //"bSort": false,
                "order": []
            });

        });
	</script>
	
</head>
<body class="rpm-dashboard" style="padding-bottom: 70px;">
    
    <!-- Popup -->
    <div class="popup-container">
        <div class="popup">
            <h6>Add Vital Information</h6>
            <div class="padded">
                
                <input type="hidden" id="hidden_patient_id" value="<?php echo $_GET['patient_id']; ?>">
                
                <div class="col-md-6">
                    <label>
                        <span>Systolic BP</span>
                        <input type="text" class="textbox" id="systolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Diastolic BP</span>
                        <input type="text" class="textbox" id="diastolicBP" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Heart Rate</span>
                        <input type="text" class="textbox" id="heartRate" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Respiratory Rate</span>
                        <input type="text" class="textbox" id="respRate" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Pulse OX</span>
                        <input type="text" class="textbox" id="pulseOX" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Temperature</span>
                        <input type="text" class="textbox" id="temp" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
                <div class="col-md-6">
                    <label>
                        <span>Glucose</span>
                        <input type="text" class="textbox" id="glucose" placeholder="">
                    </label>
                </div>
                
                <div class="col-md-6">
                    <label>
                        <span>Weight</span>
                        <input type="text" class="textbox" id="weight" placeholder="">
                    </label>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 50px;"></div>
                
                <div class="col-md-12">
                    <a href="javascript:;" class="button blue add_vitals">Add Vitals</a>
                    <a href="javascript:;" class="button red cancel">Cancel</a>
                    <div class="clear"></div>
                </div>
                
                <div class="clear"></div>
                <div style="width: 100%; height: 30px;"></div>
                
            </div>
        </div>
    </div>
    <!-- Popup -->
    
    <!-- Header -->
    <div class="header">
        
        <div class="container">
            <div class="padded">
                <div class="patient-info">
                    <h3 class="tabtitle">RPM Dashboard</h3>
                    <div class="clear"></div>
                </div>
            </div>
        </div>
        
        <div class="menu-container">
            <div class="container">
                <?php
                    if( $_SESSION['user_type'] == 'nurse' ){
                        include('nurse_dashboard_nav.php');
                    }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
                        include('physician_dashboard_nav.php');
                    }
                ?>
                
                <select class="assigned-filter main">
                    <option>Select Filter</option>
                    <option value="0">All</option>
                    
                    <?php echo get_nurse_dropdown('main'); ?>
                    
                </select>
                
                <div class="clear"></div>
            </div>
        </div>
        
    </div>
    <!-- Header -->
    
    <div class="container">
        <div class="TableContainer">
            <table id="myTable">
            	<thead>
                    <tr>
                        <td>First Name</td>
                        <td>Last Name</td>
                        <td>Gender</td>
                        <td>Age</td>
                        <td>Phone Number</td>
                        <td>User Type</td>
                        <td>Assign to Nurse</td>
                        <td>Patient Vitals</td>
                    </tr>
                </thead>
    
                <tbody>
                    
                    <?php

                        if (isset($_GET['patient_id'])) {
                            $patient_id = $_GET['patient_id'];
                        } else {
                            $patient_id = '0';
                        }
                        
                        $version = get_version();
                        
                        if( isset($_GET['filter']) ){
                            $filter = $_GET['filter'];
                            $sql = "SELECT pat.assigned_nurse, pat.patient_id, pat.patient_fname, pat.patient_lname, pat.patient_dob, pat.cell, pat.patient_gender, cuser.imei FROM patients as pat LEFT JOIN cardiowell_users as cuser ON pat.patient_id = cuser.patient_id WHERE pat.groupid = '$version' AND pat.assigned_nurse = '$filter' ORDER BY cardiowellid DESC";
                        }else{
                            $sql = "SELECT pat.assigned_nurse, pat.patient_id, pat.patient_fname, pat.patient_lname, pat.patient_dob, pat.cell, pat.patient_gender, cuser.imei FROM patients as pat LEFT JOIN cardiowell_users as cuser ON pat.patient_id = cuser.patient_id WHERE pat.groupid = '$version' ORDER BY cardiowellid DESC";
                        }
                        
                        $result = ddxrxDBConnect()->query($sql);
                        
                        if ($result->num_rows > 0) {
                            // output data of each row
                            while($row = $result->fetch_assoc()) {
                                
                                if( $row["patient_gender"] == 'm' ){
                                    $gender = 'Male';
                                }elseif( $row["patient_gender"] == 'f' ){
                                    $gender = 'Female';
                                }
                                
                                if( !empty($row["imei"]) ){
                                    $patient_type = '<span class="patientType ihealth">Cellular User</span>';
                                }else{
                                    $patient_type = '<span class="patientType regular">Regular User</span>';
                                }
                                
                                echo '<tr class="patient_id patient_'.$row["patient_id"].'" id="patient_'.$row["patient_id"].'" data-patient-id="'.$row["patient_id"].'">';
                                
                                echo '<td class="enabled">' . $row["patient_fname"] . '</td>';
                                echo '<td class="enabled">' . $row["patient_lname"] . '</td>';
                                echo '<td class="enabled">' . $gender . '</td>';
                                echo '<td class="enabled">' . $row["patient_dob"] . '</td>';
                                echo '<td class="enabled">' . $row["cell"] . '</td>';
                                echo '<td class="enabled">' . $patient_type . '</td>';
                                echo '<td>
                                    <select class="assigned-filter basic"><option>Select Filter</option><option value="0">All</option>' . get_nurse_dropdown('assign', $row["assigned_nurse"]) . '</select></td>';
                                echo '<td class="enabled"><a href="patient_vitals.php?patient_id='.$row["patient_id"].'&cctype=rpm" class="button">Vitals&nbsp;</a>';
                                echo '</tr>';
                                
                                
                            }
                        } else {
                            //echo "0 results";
                        }
                        
                        ddxrxDBConnect()->close();
                        
                    ?>
                    
                </tbody>
            </table>
        </div>
    </div>
    
    <?php
                
    	if( $_SESSION['userType'] == 'nurse' ){
                        
    		provider_bottom_nav();
                        
    	}elseif( $_SESSION['userType'] == 'doctor' ){
                        
    		physician_bottom_nav();
                        
    	}else{
                        
    		bottom_nav();
                        
    	}

    ?>
    
</body>
</html>