<html>
<head lang="en">
    <meta charset="UTF-8">
    <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
    <title>Login - Admin Panel</title>
    
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
	<script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/additional-methods.min.js"></script>
</head>
<style>
    .login-panel {
        margin-top: 150px;
    }
</style>

<style type="text/css">
	  	@import url("https://fonts.googleapis.com/css?family=Open+Sans");

		/* Styles */
		* {
		  margin: 0;
		  padding: 0;
		}

		body {
		  font-family: "Open Sans";
		  font-size: 14px;
		}


		form label,
		form button {
		  border: 0;
		  margin-bottom: 3px;
		  display: block;
		  width: 100%;
		}


		form .error {
		  color: #ff0000;
		  text-align: left !important;
		}

	</style>

<body>

<div class="container">
    <div class="row">
        <div class="col-md-4 col-md-offset-4">
            <div class="login-panel panel panel-success">
                <div class="panel-heading">
                    <h3 class="panel-title">Sign In</h3>
					<?php 
						if(isset($_GET['msg'])) {
							echo '<span style="color:red;">'.$_GET['msg'].'</span>';
						}
					?>
                </div>
                
                <div class="panel-body">
                    <form role="form" method="post" id="admin_login_form" name="admin_login_form" action="checkLogin.php">
                        <fieldset>
                            <div class="form-group"  >
                                <input class="form-control" placeholder="Name" name="name" type="text" autofocus>
                            </div>
                            <div class="form-group">
                                <input class="form-control" placeholder="Password" name="pass" type="password" value="">
                            </div>

                            <input class="btn btn-lg btn-success btn-block" type="submit" value="login" name="admin" >
                        </fieldset>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

</body>



<script>
$.validator.addMethod("allowOnlyTextAndNumber", function (value) {
        return /^[a-zA-Z0-9]+$/.test(value) // has only allowed chars letter
        
    }, "Username does not allow any special characters");

  // Wait for the DOM to be ready
$(function() {

  // Initialize form validation on the admin_login_form form.
  // It has the name attribute "admin_login_form"
  $("form[name='admin_login_form']").validate({
    // Specify validation rules
    rules: {
		// The key name on the left side is the name attribute
		// of an input field. Validation rules are defined
		// on the right side
		name: {
	        required: true,
	        allowOnlyTextAndNumber: true,
	        minlength: 5,
	        maxlength: 40,
	        // Using the normalizer to trim the value of the element
	        // before validating it.
	        //
	        // The value of `this` inside the `normalizer` is the corresponding
	        // DOMElement. In this example, `this` references the `username` element.
	        normalizer: function(value) {
	          return $.trim(value);
	        },
		},
		pass: {
			required: true,
			minlength: 5
		}
    },
    // Specify validation error messages
    messages: {
      pass: {
        required: "Please provide a password",
        minlength: "Your password must be at least 5 characters long"
      }
    },
    // Make sure the form is submitted to the destination defined
    // in the "action" attribute of the form when valid
    submitHandler: function(form) {
    	
       form.submit();
    }
  });
});
</script>

</html>