<div class="container">
    <div class="col-md-12">
        
        <!-- TAB BUTTONS CONTAINER -->
        <div class="tab-buttons-container">
            <button class="tab-button active" data-tab="follow-up">Follow-up Visits</button>
            <button class="tab-button" data-tab="symptom-checker">Symptom Checker</button>
        </div>
        <!-- TAB BUTTONS CONTAINER -->

        <!-- PATIENT HISTORY CONTAINER -->
        <div class="patient-history-container">
            
            <!-- Has patient selected -->
            <div class="has-selected-patients">
                <div class="patient-history-header">
                    <h2>Follow Up Visit</h2>
                </div>

                <div class="patient-history-form">
                    <input type="text" id="history-input" name="history_qry" placeholder="Search diagnosis or follow-up...">
                    <ul class="history-result-placeholder"></ul>
                </div>

                <div class="patient-history-content">
                    <ul class="patient-history-list">
                        <?php
                            // Create database connection
                            $con = ddxrxDBConnect();

                            // Patient ID from session
                            $patient_id = $_SESSION['current_patient']['patient_id'];
                            $user_id = $_SESSION['userid'];

                            // Fetch patient history from the database
                            $query = "SELECT * FROM `follow_up` WHERE patient_id = ? AND `status` = 'approved' ORDER BY `id` DESC";
                            $stmt = $con->prepare($query);
                            $stmt->bind_param("i", $patient_id);
                            $stmt->execute();
                            $result = $stmt->get_result();

                            // Check if any records were found
                            if($result->num_rows > 0) {
                                while($row = $result->fetch_assoc()) {
                                    
                                    echo '<li data-diagnosis-id="'.$row['id'].'"><span class="material-symbols-outlined icon add">check_box_outline_blank</span><span class="material-symbols-outlined icon delete">cancel</span><span class="value">'.$row['diagnosis'].'</span></li>';
                                }
                            } else {
                                echo '<p>No history available for this patient.</p>';
                            }

                            // Close the database connection
                            $stmt->close();
                            $con->close();

                        ?>
                    </ul>

                    <div class="no-history">
                        <p>No history available for this patient. You can add a new history entry by searching for a patient and selecting them.</p>
                    </div>
                </div>

                <form id="formddX" name="formddX" method="post" action="diagnosis-results.php" data-ajax="false">
                    <input type="hidden" name="user_id" class="form_user_id" value="<?php echo $_SESSION['userid']; ?>">
                    <input type="hidden" name="patient_id" class="form_patient_id" value="<?php echo $_SESSION['current_patient']['patient_id']; ?>">
                    <input type="submit" class="btn btn-primary" value="Submit" id="submit-btn">
                </form>
            </div>
            <!-- Has patient selected -->

        </div>
        <!-- PATIENT HISTORY CONTAINER -->

        <!-- SYMPTOM CHECKER CONTAINER -->
        <div class="symptom-checker-container">
            <div class="symptom-checker-header">
                <span class="material-symbols-outlined icon">content_paste_search</span>
                <h2>Symptom Checker</h2>
                <p>Search and add symptoms to help with diagnosis.</p>
            </div>

            <div class="symptom-search-form">
                <div class="search-input-group">
                    <input type="text" id="symptom-input" name="symptom_qry" placeholder="Search for symptoms...">
                    <button type="button" id="symptom-search-btn" class="search-btn">
                        <span class="material-symbols-outlined">search</span>Search
                    </button>
                </div>
            </div>

            <div class="symptom-checker-content">
                <ul class="symptom-list"></ul>

                <div class="no-symptoms">
                    <p>No symptoms added yet. Use the search above to add symptoms.</p>
                </div>
            </div>

            <form id="formSymptomChecker" name="formSymptomChecker" method="post" action="diagnosis-results.php" data-ajax="false">
                <input type="hidden" name="user_id" class="form_user_id" value="">
                <input type="hidden" name="patient_id" class="form_patient_id" value="">
                <input type="submit" class="btn btn-primary" value="Submit" id="symptom-submit-btn">
            </form>
        </div>
        <!-- SYMPTOM CHECKER CONTAINER -->
        
    </div>
</div>

<?php bottom_nav(); ?>