<?php

// Set JSON header
header('Content-Type: application/json');

// Include function file
include('../process/functions.php');

// Input Data
$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

try {

    // If input is not empty
    if (!empty($input)) {

        $conn = ddxrxDBConnect();

        // Check if the required keys are present
        if (
            isset($input['groupid'], $input['password'], $input['email'],
                $input['patient_fname'], $input['patient_lname'])
        ) {

            // Variables for all_users
            $groupid = $conn->real_escape_string($input['groupid']);
            $username = !empty($input['username']) ? $input['username'] : $input['email'];
            $username = $conn->real_escape_string($username);
            $email = $conn->real_escape_string($input['email']);

            $password = $input['password'];
            $password = $conn->real_escape_string($password);
            $password = password_hash($password, PASSWORD_BCRYPT);

            $unique_id = '0';
            $user_type = '3';
            $location_id = '1';
            $is_active = '1';

            // Check if username already exists
            $check_sql = "SELECT * FROM `all_users` WHERE `username` = '$username'";
            $result = $conn->query($check_sql);

            if ($result->num_rows > 0) {
                $output = array(
                    'status_code' => '400',
                    'title' => 'Bad Request',
                    'message' => 'Username already exists. Please choose a different username.'
                );
            } else {
                // Variables for patients
                $patient_fname = $conn->real_escape_string($input['patient_fname']);

                $mname = !empty($input['mname']) ? $input['mname'] : "";
                $mname = $conn->real_escape_string($mname);

                $patient_lname = $conn->real_escape_string($input['patient_lname']);

                $patient_dob = !empty($input['patient_dob']) ? $input['patient_dob'] : "1970-01-01";
                $patient_dob = $conn->real_escape_string($patient_dob);

                $patient_gender = !empty($input['patient_gender']) ? $input['patient_gender'] : "";
                $patient_gender = $conn->real_escape_string($patient_gender);

                $epic_id = '1';
                $active = '1';
                $occupation = 'not_specified';
                $billing_name = $patient_fname . ' ' . $patient_lname;
                $billing_country = 'not_specified';
                $billing_company = 'not_specified';
                $billing_email = 'not_specified';
                $mrn_hospital = 'not_specified';
                $encounter_id = 'not_specified';
                $assigned_nurse = '0';

                // Insert into all_users table
                $sql = "INSERT INTO `all_users` (`groupid`, `username`, `password_new`, `unique_id`, `email_address`, `user_type`, `location_id`, `is_active`) VALUES ('$groupid', '$username', '$password', '$unique_id', '$email', '$user_type', '$location_id', '$is_active')";

                if ($conn->query($sql) === TRUE) {

                    $last_id = $conn->insert_id;

                    // Insert into patients table using the last_id
                    $sql2 = "INSERT INTO `patients` (`groupid`, `location_id`, `patient_fname`, `mname`, `patient_lname`, `patient_dob`, `patient_gender`, `epic_id`, `active`, `occupation`, `billing_name`, `billing_country`, `billing_company`, `billing_email`, `mrn_hospital`, `encounter_id`, `assigned_nurse`, `user_id`) VALUES ('$groupid', '$location_id', '$patient_fname', '$mname', '$patient_lname', '$patient_dob', '$patient_gender', '$epic_id', '$active', '$occupation', '$billing_name', '$billing_country', '$billing_company', '$billing_email', '$mrn_hospital', '$encounter_id', '$assigned_nurse', '$last_id')";

                    if ($conn->query($sql2) === TRUE) {

                        $output = array(
                            'status_code' => '200',
                            'title' => 'Success',
                            'message' => 'User data and patient data have been inserted to the database!',
                            'user_id' => $last_id
                        );

                    } else {

                        $output = array(
                            'status_code' => '400',
                            'title' => 'Bad Request',
                            'message' => 'Something went wrong when trying to insert the user data.'
                        );

                    }

                } else {

                    $output = array(
                        'status_code' => '400',
                        'title' => 'Bad Request',
                        'message' => 'Something went wrong when trying to insert the user data.'
                    );

                }
            }

        } else {

            // Handle case where required keys are not present
            $output = array(
                'status_code' => '400',
                'title' => 'Bad Request',
                'message' => 'One or more required keys are missing in the input.'
            );

        }

    } else {

        // Change status code to 400
        http_response_code(400);

        $output = array(
            'status_code' => '400',
            'title' => 'Bad Request',
            'message' => 'The request sent by the client was empty. Please send a non-empty request in JSON format.'
        );

    }

} catch (Exception $e) {

    $output = array(
        'user_exist' => false,
        'error' => 'An error occurred: ' . $e->getMessage()
    );

}

// Close the connection
ddxrxDBConnect()->close();

// Output the result
echo json_encode($output);

?>
