<?php

header("Content-Type: application/json");
include('../process/functions.php');

try {

    // sql to delete a record
    $sql = "delete from multi_answer;";
    $sql .= "delete from bot_text";

    // Get the header authentication token
    $auth_header = getallheaders();

    // Check if the key "Auth" is present in the header
    if (isset($auth_header['Auth'])) {

        $token = $auth_header['Auth'];

        // Check if the token is valid
        if (authDecoder($token) == true) {

            if (authDecoder($_COOKIE['access_token']) === FALSE) {

                $output = array(
                    'result' => false,
                    'desc' => 'Invalid Access Token'
                );

            } else {
                if (ddxrxDBConnect()->multi_query($sql) === TRUE) {

                    $output = array(
                        'result' => true,
                        'desc' => 'Record deleted successfully'
                    );

                } else {

                    $output = array(
                        'result' => true,
                        'desc' => 'Error, something went wrong.'
                    );

                }
            }

        } else {

            $output = array(
                'result' => false,
                'result_desc' => 'Invalid Token',
            );

        }
    } else {
        // Handle case where the key "Auth" is not present in the header
        $output = array(
            'result' => false,
            'desc' => 'Error: The key "Auth" is missing in the header.'
        );
    }

} catch (Exception $e) {

    $output = array(
        'user_exist' => false,
        'error' => 'An error occurred: ' . $e->getMessage()
    );

}

// Close database connection after use
ddxrxDBConnect()->close();

// Output the result as a JSON
echo json_encode($output);

?>