<?php

    // Enable error reporting
    // ini_set('display_errors', 1);
    // ini_set('display_startup_errors', 1);
    // error_reporting(E_ALL);

    // Set JSON header
    header('Content-Type: application/json');

    // Declare Variables
    $path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $apiName = basename($path); // Extract the API name from the path
    $apiFile = __DIR__ . '/' . $apiName; // Use the absolute path to the API file

    // Check if the requested API file exists
    if (file_exists($apiFile)) {

        if( $apiName == 'app-login.php' || $apiName == 'dictation-notes.php' ){
            // Handle the login API
            if (is_file($apiFile)) {
                include($apiFile);
                exit;
            } else {
                header('HTTP/1.1 404 Not Found');
                echo json_encode(array('status' => false, 'message' => 'API file not found.'));
                exit;
            }
        }

        // Include the JWT functions
        include('../process/jwt_functions.php');

        // Get the Bearer token
        $token_details = json_decode(get_bearer_token(), true);

        if( $token_details['status'] == true ){

            // Verify the JWT token
            if (verifyJWT($token_details['token'])) {
                
                // Include the API file
                include($apiFile);

            }else{

                $output = array(
                    'status' => false,
                    'message' => 'Invalid token.'
                );

                echo json_encode($output);

            }

        }else{

            $output = array(
                'status' => false,
                'message' => 'Token not found.'
            );

            // Http status code
            header('HTTP/1.1 401 Unauthorized');

            echo json_encode($output);

        }

    } else {
        // Handle the case where the API file does not exist
        header('HTTP/1.1 404 Not Found');

        $output = array(
            'status' => false,
            'message' => 'API not found.'
        );

        echo json_encode($output);

    }

?>