<?php

/*
200 - Everything is OK
201 - Created Successfully
202 - Accepted
204 - No Content
301 - Moved Permanently
400 - Bad Request
401 - Unauthorized
404 - Not Found
500 - Internal Server Error
*/

// Set Content to json
header('Content-Type: application/json');

include('../process/functions.php');

try{

    $data = json_decode(file_get_contents('php://input'), true);
    $user_id = $data['patient_id'];

    $sql = "SELECT patients.user_id, vitals_history.systolic, vitals_history.diastolic, vitals_history.heartrate, vitals_history.respiratory, vitals_history.pulseox, vitals_history.temp, vitals_history.glucose FROM vitals_history LEFT JOIN patients ON vitals_history.patient_id = patients.patient_id WHERE vitals_history.date_added >= NOW() - INTERVAL 1 DAY AND patients.user_id = '$user_id' ORDER BY vitals_history.date_added DESC LIMIT 1";
    $result = ddxrxDBConnect()->query($sql);

    if ($result->num_rows > 0) {

        while($row = $result->fetch_assoc()) {
            
            $output = array(
                'result' => true,
                'user_id' => $row['user_id'],
                'systolic' => $row['systolic'],
                "diastolic" => $row['diastolic'],
                'heartrate' => $row['heartrate'],
                'respiratory' => $row['respiratory'],
                'pulseox' => $row['pulseox'],
                'temp' => $row['temp'],
                'glucose' => $row['glucose'],
            );
            
        }
        
    } else {
        
        $output = array(
            'result' => false,
            'status_code' => '404',
            'message' => 'No vitals found for patient with an ID of:'.$user_id
        );
        
    }

} catch (Exception $e) {

    $output = array(
        'result' => false,
        'status_code' => '500',
        'message' => 'An error occurred: ' . $e->getMessage()
    );

}

ddxrxDBConnect()->close();

echo json_encode($output);

?>