jQuery(document).ready(function($){

    // TAB BUTTON FUNCTIONALITY
    $(document).on('click touchstart', '.tab-button', function(){
        var tabType = $(this).data('tab');
        
        // Remove active class from all buttons
        $('.tab-button').removeClass('active');
        
        // Add active class to clicked button
        $(this).addClass('active');
        
        // Hide all containers
        $('.patient-history-container').hide();
        $('.symptom-checker-container').hide();
        
        // Show selected container
        if(tabType === 'follow-up') {
            $('.patient-history-container').show();
        } else if(tabType === 'symptom-checker') {
            $('.symptom-checker-container').show();
        }
    });

    // SEARCH FUNCTIONALITY
    $('.search-container #search-input').keyup(function(){

		var search_qry = $('.search-container #search-input').val();

		// Start Ajax
		$.ajax({
			type: 'POST',
			url: 'process/search_query.php',

			data: {
				search_qry:search_qry
			},

			beforeSend: function() {
				// Do Something
			},
			success: function(response) {
				// Do Something
				if(response != ''){
					
					$('.search-container .search-result-placeholder').html();
					$('.search-container .search-result-placeholder').html(response);

				}
			},
		});
		// End Ajax

		if( search_qry == '' ){
			$('.search-container .search-result-placeholder').html(' ');
			$('.search-container .search-result-placeholder').hide();
		}else{
			$('.search-container .search-result-placeholder').show();
		}

	});

    // ADD PATIENT TO SELECTED PATIENT AND HIDE SEARCH RESULT ON CLICK
    $(document).on('click touchstart', '.search-container .search-result-placeholder li', function(){
        
        var patient_id = $(this).data('patient-id');
        var user_id = $(this).data('user-id');
        var first_name = $(this).attr('data-firstname');
        var last_name = $(this).attr('data-lastname');
        var fullname = first_name+' '+last_name;
        var dob = $(this).attr('data-dob');
        
        // Reset selected patient
        $('.selected-patient ul').html('');

        // Clear previous patient history
        $('.patient-history-list').html('');
        
        // Clear any previously selected form inputs
        $('#formddX input[name^="symptoms"]').remove();
        $('#formSymptomChecker input[name^="symptoms"]').remove();

        // Clear symptom list display
        $('.symptom-list').empty().removeClass('has-symptoms');
        $('.no-symptoms').show();

        // Delete HTML
        $('.search-container .search-result-placeholder').html('');
        
        // Show sweet alert
        Swal.fire({
            icon: 'success',
            title: 'User: '+fullname+' selected',
            text: fullname+' has been selected as the active user.',
            allowOutsideClick: false
        });

        // Append selected patient details
        $('.selected-patient ul').append('<li><strong>Patient ID: </strong>'+patient_id+'</li>');
        $('.selected-patient ul').append('<li><strong>User ID: </strong>'+user_id+'</li>');
        $('.selected-patient ul').append('<li><strong>Name: </strong>'+fullname+'</li>');
        $('.selected-patient ul').append('<li><strong>Date of birth: </strong>'+dob+'</li>');

        // Add patient ID and user ID to follow-up form
        $('#formddX .form_user_id').val(user_id);
        $('#formddX .form_patient_id').val(patient_id);

        // Add patient ID and user ID to symptom checker form
        $('#formSymptomChecker .form_user_id').val(user_id);
        $('#formSymptomChecker .form_patient_id').val(patient_id);

        // Show patient selected container
        $('.has-selected-patient').show();

        // Hide no patient selected container
        $('.no-selected-patient').hide();

        // Show selected patient
        $('.selected-patient').css('display', 'flex');

        // Show tab buttons
        $('.tab-buttons-container').show();

        // Reset search input
        $('.search-container #search-input').val('');
        
    });


    // GET PATIENTS MEDICAL HISTORY
    $(document).on('click touchstart', '.search-container .search-result-placeholder li', function(){

        var patient_id = $(this).data('patient-id');
        var user_id = $(this).data('user-id');
        var historyList = '';

        // Clear previous history before loading new patient's history
        $('.patient-history-list').html('');
        $('.no-history').hide();

        // Start Ajax
        $.ajax({
            type: 'POST',
            url: 'process/get_patient_followup.php',

            data: {
                patient_id: patient_id,
                user_id: user_id
            },

            beforeSend: function() {
                // Do Something
            },
            success: function(response) {
                
                if(response.status == true){

                    // Iterate through the response and build the history list
                    response.history.forEach(function(item) {
                        historyList += '<li data-diagnosis-id="'+item.id+'"><span class="material-symbols-outlined icon add">check_box_outline_blank</span><span class="material-symbols-outlined icon delete"> cancel </span><span class="value">' + item.diagnosis + '</span></li>';
                    });

                    // Update the patient history list
                    $('.patient-history-list').html(historyList);

                    // Show the patient history list and hide the no history message
                    $('.patient-history-list').show();
                    $('.no-history').hide();

                }else{
                    
                    // If no history found, show the no history message
                    $('.patient-history-list').hide();
                    $('.no-history').show();

                    // Show sweet alert
                    Swal.fire({
                        icon: 'warning',
                        title: 'No History Found',
                        text: 'No medical history found for this patient.',
                        allowOutsideClick: false
                    });

                }

            },
        });
        // End Ajax

    });

    // SEARCH DIAGNOSIS
    $('#history-input').keyup(function(){

        var search_qry = $('#history-input').val();
        var symptomList = '';

        // Start Ajax
        $.ajax({
            type: 'POST',
            url: 'process/search-diagnosis.php',

            data: {
                search_qry: search_qry
            },

            beforeSend: function() {
                // Do Something
            },
            success: function(response) {
                // Do Something
                if(response.result == true){

                    // Iterate through the response and build the history list
                    response.items.forEach(function(item) {
                        symptomList += '<li>' + item.symptom_name + '</li>';
                    });

                    // Update the diagnosis result placeholder
                    $('.history-result-placeholder').html();
                    $('.history-result-placeholder').html(symptomList);

                }
            },
        });
        // End Ajax

        if( search_qry == '' ){
            $('.history-result-placeholder').html(' ');
            $('.history-result-placeholder').hide();
        }else{
            $('.history-result-placeholder').show();
        }

    });


    // ADD DIAGNOSIS TO PATIENT HISTORY
    $(document).on('click touchstart', '.history-result-placeholder li', function(){
        var symptom_name = $(this).text();
        var user_id = $('.form_user_id').val();
        var patient_id = $('.form_patient_id').val();

        // Start Ajax
        $.ajax({
            type: 'POST',
            url: 'process/add_patient_followup.php',

            data: {
                patient_id: patient_id,
                user_id: user_id,
                symptom_name: symptom_name
            },

            beforeSend: function() {
                // Do Something
            },
            success: function(response) {
                
                if(response.status == true){

                    Swal.fire({
                        position: "bottom-end",
                        icon: "success",
                        title: symptom_name + " added to follow up visit",
                        showConfirmButton: false,
                        toast: true,
                        timer: 3500
                    });

                    // Clear the input field
                    $('#history-input').val('');

                    // Hide the history result placeholder
                    $('.history-result-placeholder').hide();

                    // Add the new diagnosis to the patient history list
                    $('.patient-history-list').append('<li data-diagnosis-id="'+response.history_id+'"><span class="material-symbols-outlined icon add">check_box_outline_blank</span><span class="material-symbols-outlined icon delete">cancel</span><span class="value">' + symptom_name + '</span></li>');

                    // Show patient history list
                    $('.patient-history-list').show();

                    // Hide no history message
                    $('.no-history').hide();

                }else{
                    
                    // Show sweet alert
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message,
                        allowOutsideClick: false
                    });

                }

            },
        });
        // End Ajax

    });

    // TOGGLE HISTORY ITEM IN FORM (ADD/REMOVE)
    // Combined function to handle both adding and removing diagnosis items
    $(document).on('click touchstart', '.patient-history-list li .icon.add, .patient-history-list li .icon.added', function(){
        
        var $clickedIcon = $(this);
        var isAdding = $clickedIcon.hasClass('add');
        var diagnosis_id = $clickedIcon.parent().data('diagnosis-id');
        var diagnosis_text = $clickedIcon.siblings('span.value').text();
        
        if (isAdding) {
            // ADD: Change icon and class
            $clickedIcon.removeClass('add').addClass('added').html('check_box');
            
            // Add to form if not already present
            if ($('#formddX input[name^="symptoms"][value="'+diagnosis_text+'"]').length == 0) {
                // Check if diagnosis contains follow-up and add special follow-up input first
                if (diagnosis_text.toLowerCase().indexOf('follow-up') !== -1) {
                    // Add follow-up visit input if not already present
                    if ($('#formddX input[name^="symptoms"][value="follow-up visit"]').length == 0) {
                        $('#formddX').append('<input type="hidden" name="symptoms[0]" value="follow-up visit" />');
                        // Reindex existing symptoms to make room for follow-up at index 0
                        $('#formddX input[name^="symptoms"]:not([value="follow-up visit"])').each(function(index) {
                            $(this).attr('name', 'symptoms[' + (index + 1) + ']');
                        });
                    }
                }
                
                // Get the next sequential index
                var nextIndex = $('#formddX input[name^="symptoms"]').length;
                $('#formddX').append('<input type="hidden" name="symptoms['+nextIndex+']" value="'+diagnosis_text+'" />');
                
                // Show success alert
                Swal.fire({
                    position: "bottom-end",
                    icon: "success",
                    title: diagnosis_text + " added to form",
                    showConfirmButton: false,
                    toast: true,
                    timer: 3500
                });
            }
            
        } else {
            // REMOVE: Change icon and class back
            $clickedIcon.removeClass('added').addClass('add').html('check_box_outline_blank');
            
            // Remove from form
            $('#formddX input[name^="symptoms"][value="'+diagnosis_text+'"]').remove();
            
            // Check if the removed item was a follow-up item
            if (diagnosis_text.toLowerCase().indexOf('follow-up') !== -1) {
                // Check if there are any other follow-up items remaining in the form
                var hasOtherFollowUps = false;
                $('#formddX input[name^="symptoms"]:not([value="follow-up visit"])').each(function() {
                    if ($(this).val().toLowerCase().indexOf('follow-up') !== -1) {
                        hasOtherFollowUps = true;
                        return false; // Break the loop
                    }
                });
                
                // If no other follow-up items remain, remove the special follow-up input
                if (!hasOtherFollowUps) {
                    $('#formddX input[name^="symptoms"][value="follow-up visit"]').remove();
                }
            }
            
            // Reindex remaining symptoms to maintain sequential numbering
            $('#formddX input[name^="symptoms"]').each(function(index) {
                $(this).attr('name', 'symptoms[' + index + ']');
            });

            Swal.fire({
                position: "bottom-end",
                icon: "warning",
                title: diagnosis_text + " removed from form",
                showConfirmButton: false,
                toast: true,
                timer: 3500
            });
        }
        
    });


    // DELETE DIAGNOSIS FROM PATIENT HISTORY
    $(document).on('click touchstart', '.patient-history-list li .icon.delete', function(){
        var $clickedIcon = $(this);
        var diagnosis_id = $clickedIcon.parent().data('diagnosis-id');
        var diagnosis_text = $clickedIcon.siblings('span.value').text();
        var user_id = $('.form_user_id').val();
        var patient_id = $('.form_patient_id').val();

        // Show confirmation dialog
        Swal.fire({
            title: 'Are you sure?',
            text: 'Do you want to delete "' + diagnosis_text + '" from follow up visit?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                // User confirmed deletion, proceed with AJAX
                $.ajax({
                    type: 'POST',
                    url: 'process/delete_patient_followup.php',

                    data: {
                        diagnosis_id: diagnosis_id,
                        diagnosis_text: diagnosis_text,
                        patient_id: patient_id,
                        user_id: user_id
                    },

                    beforeSend: function() {
                        // Do Something
                    },
                    success: function(response) {
                        
                        if(response.status == true){

                            // Remove the item from the patient history list
                            $clickedIcon.parent().remove();

                            // Remove from form
                            $('#formddX input[name^="symptoms"][value="'+diagnosis_text+'"]').remove();

                            // Check if the deleted item was a follow-up item
                            if (diagnosis_text.toLowerCase().indexOf('follow-up') !== -1) {
                                // Check if there are any other follow-up items remaining in the form
                                var hasOtherFollowUps = false;
                                $('#formddX input[name^="symptoms"]:not([value="follow-up visit"])').each(function() {
                                    if ($(this).val().toLowerCase().indexOf('follow-up') !== -1) {
                                        hasOtherFollowUps = true;
                                        return false; // Break the loop
                                    }
                                });
                                
                                // If no other follow-up items remain, remove the special follow-up input
                                if (!hasOtherFollowUps) {
                                    $('#formddX input[name^="symptoms"][value="follow-up visit"]').remove();
                                }
                            }

                            // Reindex remaining symptoms to maintain sequential numbering
                            $('#formddX input[name^="symptoms"]').each(function(index) {
                                $(this).attr('name', 'symptoms[' + index + ']');
                            });

                            // Show sweet alert
                            Swal.fire({
                                position: "bottom-end",
                                icon: "success",
                                title: "Diagnosis deleted successfully",
                                showConfirmButton: false,
                                toast: true,
                                timer: 1500
                            });

                        }else{
                            
                            // Show sweet alert
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: response.message,
                                allowOutsideClick: false
                            });

                        }

                    },
                });
                // End Ajax
            }
        });

    });


    // SUBMIT FORM
    $('#formddX').submit(function(e){
        e.preventDefault();

        // Check if any symptoms/diagnoses are selected
        var selectedSymptoms = $('#formddX input[name^="symptoms"]').length;
        
        if(selectedSymptoms === 0) {
            Swal.fire({
                icon: 'warning',
                title: 'No Items Selected',
                text: 'Please select at least one diagnosis or follow-up item before submitting.',
                allowOutsideClick: false
            });
            return false; // Stop form submission
        }

        // Show loading spinner
        Swal.fire({
            title: 'Submitting...',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // Start Ajax
        $.ajax({
            type: 'POST',
            url: 'process/ambulatory_waitingroom.php',
            data: $(this).serialize(),
            dataType: 'json', // Ensure response is parsed as JSON

            success: function(response) {
                Swal.close(); // Close the loading spinner

                if(response.status == true){
                    
                    // Check if the server operation was successful
                    if(response.data && response.data.msg === 'success') {
                        // Add patient details to local storage in JSON format
                        var waitingroom_data = {
                            checkInTime: response.data.checkInTime,
                            idKey: response.data.guid,
                            waitingroom_id: response.data.waitingroom_id
                        };

                        // Store the selected patient in local storage
                        localStorage.setItem('patient', JSON.stringify(waitingroom_data));

                        // Debug: Verify storage was successful
                        var storedData = localStorage.getItem('patient');

                        // Show success alert with redirect
                        Swal.fire({
                            icon: 'success',
                            title: 'Redirecting...',
                            text: 'Patient data ready for next step.',
                            allowOutsideClick: false,
                            confirmButtonText: 'Next Step'
                        }).then(() => {
                            
                            // Force form submission
                            $('#formddX').off('submit').submit(); // Remove the submit handler to avoid recursion

                        });
                    } else {
                        
                        Swal.fire({
                            icon: 'error',
                            title: 'Operation Failed',
                            text: response.data.error_message || 'Unknown server error',
                            allowOutsideClick: false
                        });
                    }

                }else{
                    
                    // Show error alert
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message || 'An unknown error occurred',
                        allowOutsideClick: false
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.close(); // Close the loading spinner
                
                // Debug: Log error details
                console.log('AJAX Error:', {
                    xhr: xhr,
                    status: status,
                    error: error,
                    responseText: xhr.responseText
                });
                
                // Show error alert
                Swal.fire({
                    icon: 'error',
                    title: 'Connection Error',
                    text: 'Failed to connect to server. Please try again.',
                    allowOutsideClick: false
                });
            }
        });
        // End Ajax

    });

    // SYMPTOM SEARCH FUNCTIONALITY
    $('#symptom-search-btn').click(function(){
        var search_qry = $('#symptom-input').val().trim();
        
        if(search_qry.length < 3) {
            Swal.fire({
                icon: 'warning',
                title: 'Search Too Short',
                text: 'Please enter at least 3 characters to search for symptoms.',
                timer: 3000,
                toast: true,
                position: 'bottom-end'
            });
            return;
        }
        
        searchSymptoms(search_qry);
    });

    // Allow Enter key to trigger search
    $('#symptom-input').keypress(function(e){
        if(e.which === 13) { // Enter key
            e.preventDefault();
            $('#symptom-search-btn').click();
        }
    });

    function searchSymptoms(query) {
        // Get user_id from the form (assuming it's set when patient is selected)
        var user_id = $('.form_user_id').val() || 2; // Default to 2 if not set
        
        // Disable search button during search
        $('#symptom-search-btn').prop('disabled', true).html('<span class="material-symbols-outlined">hourglass_empty</span>Searching...');
        
        // Show loading
        Swal.fire({
            title: 'Searching symptoms...',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // API call to ddxrx.ai
        $.ajax({
            type: 'POST',
            url: 'https://ddxrx.ai',
            contentType: 'application/json',
            data: JSON.stringify({
                "user_id": parseInt(user_id),
                "question": query,
                "entity": ""
            }),
            success: function(response) {
                Swal.close();
                
                // Re-enable search button
                $('#symptom-search-btn').prop('disabled', false).html('<span class="material-symbols-outlined">search</span>Search');
                
                if(response.response === "success") {
                    // Check if symptoms array has data (direct symptoms)
                    if(response.symptoms && response.symptoms.length > 0) {
                        // Direct symptoms found, add them to the form immediately
                        addSymptomsToForm(response.symptoms);
                    } 
                    // If symptoms array is empty but symptoms_data exists, show popup
                    else if((!response.symptoms || response.symptoms.length === 0) && response.symptoms_data && response.symptoms_data.length > 0) {
                        // Pass the nexturl field to determine the next API call type
                        showSymptomSelectionPopup(response.symptoms_data, user_id, response.nexturl);
                    } 
                    else {
                        Swal.fire({
                            icon: 'info',
                            title: 'No symptoms found',
                            text: 'No matching symptoms found for your search.',
                            timer: 3000,
                            toast: true,
                            position: 'bottom-end'
                        });
                    }
                } else {
                    Swal.fire({
                        icon: 'info',
                        title: 'No symptoms found',
                        text: 'No matching symptoms found for your search.',
                        timer: 3000,
                        toast: true,
                        position: 'bottom-end'
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.close();
                
                // Re-enable search button
                $('#symptom-search-btn').prop('disabled', false).html('<span class="material-symbols-outlined">search</span>Search');
                
                console.log('Symptom search error:', error);
                
                Swal.fire({
                    icon: 'error',
                    title: 'Search Error',
                    text: 'Failed to search symptoms. Please try again.',
                    timer: 3000,
                    toast: true,
                    position: 'bottom-end'
                });
            }
        });
    }

    function showSymptomSelectionPopup(symptomsData, userId, nextUrl) {
        // Create HTML for symptom options
        var optionsHtml = '';
        symptomsData.forEach(function(item, index) {
            if(item.option && item.option.question) {
                optionsHtml += `
                    <div class="symptom-option">
                        <label>
                            <input type="checkbox" value="${item.option.question}" data-index="${index}">
                            <span>${item.option.question}</span>
                        </label>
                    </div>
                `;
            }
        });

        // Show popup with symptom options
        Swal.fire({
            title: 'Additional Symptom Questions',
            html: `
                <div class="symptom-selection-popup">
                    <p style="margin-bottom: 15px; color: #666;">Please select one or more symptoms that match your condition:</p>
                    <div class="symptom-options">
                        ${optionsHtml}
                    </div>
                </div>
            `,
            showCancelButton: true,
            confirmButtonText: 'Confirm Selection',
            cancelButtonText: 'Cancel',
            width: '600px',
            allowOutsideClick: false,
            allowEscapeKey: false,
            customClass: {
                popup: 'symptom-popup',
                content: 'symptom-popup-content'
            },
            preConfirm: () => {
                // Get selected symptoms
                var selectedSymptoms = [];
                $('.symptom-selection-popup input[type="checkbox"]:checked').each(function() {
                    selectedSymptoms.push($(this).val());
                });
                
                if(selectedSymptoms.length === 0) {
                    Swal.showValidationMessage('Please select at least one symptom');
                    return false;
                }
                
                return selectedSymptoms;
            }
        }).then((result) => {
            if (result.isConfirmed && result.value.length > 0) {
                // Send selected symptoms to API, passing the nextUrl context
                confirmSelectedSymptoms(result.value, userId, nextUrl);
            }
        });
    }

    function confirmSelectedSymptoms(selectedQuestions, userId, nextUrl) {
        // Join questions with $ separator, but handle single question differently
        var questionString;
        if(selectedQuestions.length === 1) {
            // Single question: no trailing $
            questionString = selectedQuestions[0];
        } else {
            // Multiple questions: join with $ and add trailing $
            questionString = selectedQuestions.join('$') + '$';
        }
        
        // Show loading
        Swal.fire({
            title: 'Confirming symptoms...',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // Determine the correct URL based on the nextUrl parameter
        // If nextUrl is "questionSearch", use base URL (no parameter)
        // Otherwise, use parameterized URL
        var apiUrl;
        if(nextUrl === "questionSearch") {
            apiUrl = 'https://ddxrx.ai';
        } else {
            apiUrl = 'https://ddxrx.ai?parameter=questionSearch';
        }
        
        console.log('Ambulatory API call - NextUrl:', nextUrl, 'URL:', apiUrl, 'Question:', questionString);

        // Send confirmation to API
        $.ajax({
            type: 'POST',
            url: apiUrl,
            contentType: 'application/json',
            data: JSON.stringify({
                "user_id": parseInt(userId),
                "question": questionString,
                "entity": ""
            }),
            success: function(response) {
                Swal.close();
                
                console.log('Confirm symptoms response:', response);
                
                if(response.response === "success" || response.response === "Success") {
                    // Check if we got final symptoms (confirmed diagnosis)
                    if(response.symptoms && response.symptoms.length > 0) {
                        console.log('Final symptoms found:', response.symptoms);
                        // Final symptoms confirmed, add them to form
                        addSymptomsToForm(response.symptoms);
                        
                        // Show success message
                        Swal.fire({
                            icon: 'success',
                            title: 'Symptoms Added',
                            text: (response.text || 'Selected symptoms have been added to your form.').replace(/\$/g, ''),
                            timer: 3000,
                            toast: true,
                            position: 'bottom-end'
                        });
                    }
                    // If symptoms array is still empty but we have more symptoms_data, continue the flow
                    else if((!response.symptoms || response.symptoms.length === 0) && response.symptoms_data && response.symptoms_data.length > 0) {
                        console.log('More questions found:', response.symptoms_data.length);
                        // Pass the new nextUrl for the next iteration
                        showSymptomSelectionPopup(response.symptoms_data, userId, response.nexturl);
                    }
                    else {
                        console.log('No symptoms or symptoms_data found');
                        // No more questions and no final symptoms
                        Swal.fire({
                            icon: 'warning',
                            title: 'No Symptoms Confirmed',
                            text: 'Unable to confirm the selected symptoms. Please try again.',
                            timer: 3000,
                            toast: true,
                            position: 'bottom-end'
                        });
                    }
                } else {
                    console.log('Response not success:', response.response);
                    Swal.fire({
                        icon: 'warning',
                        title: 'No Symptoms Confirmed',
                        text: 'Unable to confirm the selected symptoms. Please try again.',
                        timer: 3000,
                        toast: true,
                        position: 'bottom-end'
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.close();
                console.log('Symptom confirmation error:', error);
                
                Swal.fire({
                    icon: 'error',
                    title: 'Confirmation Error',
                    text: 'Failed to confirm symptoms. Please try again.',
                    timer: 3000,
                    toast: true,
                    position: 'bottom-end'
                });
            }
        });
    }

    function addSymptomsToForm(symptoms) {
        // Get current count of existing symptoms to continue indexing
        var existingCount = $('#formSymptomChecker input[name^="symptoms"]').length;
        
        // Add new symptoms to form and display (append, don't replace)
        symptoms.forEach(function(symptom, index) {
            var newIndex = existingCount + index;
            
            // Check if this symptom already exists to avoid duplicates
            var existingSymptom = $('#formSymptomChecker input[name^="symptoms"][value="' + symptom + '"]');
            if(existingSymptom.length === 0) {
                // Add hidden input to form
                $('#formSymptomChecker').append(`<input type="hidden" name="symptoms[${newIndex}]" value="${symptom}">`);
                
                // Add to symptom list display
                $('.symptom-list').append(`
                    <li data-symptom-index="${newIndex}">
                        <span class="material-symbols-outlined icon delete">cancel</span>
                        <span class="value">${symptom}</span>
                    </li>
                `);
            } else {
                // Show notification that symptom already exists
                Swal.fire({
                    position: "bottom-end",
                    icon: "info",
                    title: symptom + " already added",
                    showConfirmButton: false,
                    toast: true,
                    timer: 2000
                });
            }
        });
        
        // Update display state based on total symptoms
        var totalSymptoms = $('#formSymptomChecker input[name^="symptoms"]').length;
        if(totalSymptoms > 0) {
            $('.no-symptoms').hide();
            $('.symptom-list').addClass('has-symptoms').show();
        } else {
            $('.no-symptoms').show();
            $('.symptom-list').removeClass('has-symptoms').hide();
        }
        
        // Clear the search input
        $('#symptom-input').val('');
    }

    // Remove symptom from form
    $(document).on('click touchstart', '.symptom-list li .icon.delete', function(){
        var $listItem = $(this).parent();
        var symptomIndex = $listItem.data('symptom-index');
        var symptomText = $listItem.find('.value').text();
        
        // Remove from form
        $('#formSymptomChecker input[name="symptoms[' + symptomIndex + ']"]').remove();
        
        // Remove from display
        $listItem.remove();
        
        // Reindex ALL remaining symptoms to maintain sequential numbering
        var allInputs = $('#formSymptomChecker input[name^="symptoms"]');
        var allListItems = $('.symptom-list li');
        
        // Clear all current inputs
        allInputs.remove();
        
        // Re-add inputs with sequential indexing
        allListItems.each(function(index) {
            var symptomValue = $(this).find('.value').text();
            $(this).attr('data-symptom-index', index);
            $('#formSymptomChecker').append(`<input type="hidden" name="symptoms[${index}]" value="${symptomValue}">`);
        });
        
        // Show no symptoms message if no symptoms left
        if($('.symptom-list li').length === 0) {
            $('.no-symptoms').show();
            $('.symptom-list').removeClass('has-symptoms').hide();
        }
        
        // Show removal notification
        Swal.fire({
            position: "bottom-end",
            icon: "warning",
            title: symptomText + " removed",
            showConfirmButton: false,
            toast: true,
            timer: 2000
        });
    });

    // SYMPTOM CHECKER FORM SUBMISSION
    $('#formSymptomChecker').submit(function(e){
        e.preventDefault();

        // Check if any symptoms are selected
        var selectedSymptoms = $('#formSymptomChecker input[name^="symptoms"]').length;
        
        if(selectedSymptoms === 0) {
            Swal.fire({
                icon: 'warning',
                title: 'No Symptoms Selected',
                text: 'Please search and select at least one symptom before submitting.',
                allowOutsideClick: false
            });
            return false; // Stop form submission
        }

        // Show loading spinner
        Swal.fire({
            title: 'Submitting...',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // Start Ajax
        $.ajax({
            type: 'POST',
            url: 'process/ambulatory_waitingroom.php',
            data: $(this).serialize(),
            dataType: 'json', // Ensure response is parsed as JSON

            success: function(response) {
                Swal.close(); // Close the loading spinner

                if(response.status == true){
                    
                    // Check if the server operation was successful
                    if(response.data && response.data.msg === 'success') {
                        // Add patient details to local storage in JSON format
                        var waitingroom_data = {
                            checkInTime: response.data.checkInTime,
                            idKey: response.data.guid,
                            waitingroom_id: response.data.waitingroom_id
                        };

                        // Store the selected patient in local storage
                        localStorage.setItem('patient', JSON.stringify(waitingroom_data));

                        // Debug: Verify storage was successful
                        var storedData = localStorage.getItem('patient');

                        // Show success alert with redirect
                        Swal.fire({
                            icon: 'success',
                            title: 'Redirecting...',
                            text: 'Patient data ready for next step.',
                            allowOutsideClick: false,
                            confirmButtonText: 'Next Step'
                        }).then(() => {
                            
                            // Force form submission
                            $('#formSymptomChecker').off('submit').submit(); // Remove the submit handler to avoid recursion

                        });
                    } else {
                        
                        Swal.fire({
                            icon: 'error',
                            title: 'Operation Failed',
                            text: response.data.error_message || 'Unknown server error',
                            allowOutsideClick: false
                        });
                    }

                }else{
                    
                    // Show error alert
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message || 'An unknown error occurred',
                        allowOutsideClick: false
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.close(); // Close the loading spinner
                
                // Debug: Log error details
                console.log('AJAX Error:', {
                    xhr: xhr,
                    status: status,
                    error: error,
                    responseText: xhr.responseText
                });
                
                // Show error alert
                Swal.fire({
                    icon: 'error',
                    title: 'Connection Error',
                    text: 'Failed to connect to server. Please try again.',
                    allowOutsideClick: false
                });
            }
        });
        // End Ajax

    });

});