$(document).ready(function(){

    var table = $('#myTable').DataTable({
        "processing": false,
        "serverSide": true,
        "ajax": {
            "url": "process/billing-code-data.php",
            "type": "POST",
            "data": function(d) {
                d.month = $('.filterSelect.month').val();
                d.year = $('.filterSelect.year').val();
            }
        },
        "pageLength": 50,
        "bSort": true,
        "paging": true, // Explicitly enable pagination
        "language": {
            "loadingRecords": "<p>Please wait, loading data...</p>"
        }
    });

    function reloadTable() {
        table.ajax.reload(null, false); // false to keep the current paging position
    }



    $(document).on('click', '.manual-time-btn', function(e) {

        // Prevent Default Behaviour
        e.preventDefault();

        // Change patient ID data
        var patient_id = $(this).data('patient-id');
        $('.manual-timer-popup').attr('data-patient-id', patient_id);

        // Show Popup
        $('.manual-timer-popup').css("display", "flex");

    });    
    
    // Close Button
    $('.manual-timer-popup .close').click(function(e){

        // Prevent Default Behaviour
        e.preventDefault();

        // Close popup
        $('.manual-timer-popup').fadeOut();

    });
   
    // Submit CPT codes
    $('.manual-timer-popup .btn').click(function(){
        
        var user_type = $('body').data('user-type');
        var cctype = 'rpm';
        var patient_id = $('.manual-timer-popup').data('patient-id');
        var mm = $('.min').val();
        var ss = $('.sec').val();
        
        if( user_type == 'nurse' ){
            
            var provider_type = 'nurse';
            var provider_id = $('body').data('nurse-id');
            
        }else if( user_type == 'doctor' ){
            
            var provider_type = 'doctor';
            var provider_id = $('body').data('physician-id');
            
        }
        
        if( mm != '' && ss != '' ){
        
            $.ajax({
                type: 'POST',
                url: 'process/submit_manual_time.php',
                data:{
                    cctype: cctype,
                    provider_id: provider_id,
                    provider_type:provider_type,
                    patient_id : patient_id,
                    mm : mm,
                    ss : ss
                },
                beforeSend: function() {
                        					
                },
                    
                success: function(response) {
                        
                    $('.billing-code-popup').hide();
                        
                    if( response.result === true ){
                        
                        Swal.fire({
                            icon: 'success',
                            title: 'Time Added',
                            text: 'Manual time added',
                        });
                        
                        $('.manual-timer-popup').fadeOut();
                        $('.min').val('1');
                        $('.sec').val('0');

                        reloadTable();
                        
                    }else{
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'Something went wrong!',
                        });
                    }
                        
                }
                        
            });
        
        }else{
            
            Swal.fire({
                icon: "error",
                title: "Time Field Empty",
                text: "Both the seconds and minutes field cannot be empty at the same time, please fill up atleast 1 before submitting.",
            });
            
        }
        
    });

});